/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.context;

import com.sun.faces.context.FacesContextImpl;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.FacesWrapper;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.lifecycle.Lifecycle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InjectionFacesContextFactory
extends FacesContextFactory
implements FacesWrapper<FacesContextFactory> {
    private static final Logger LOGGER = FacesLogger.CONTEXT.getLogger();
    private FacesContextFactory delegate;
    private Field defaultFacesContext;

    public InjectionFacesContextFactory(FacesContextFactory delegate) {
        Util.notNull((String)"facesContextFactory", (Object)delegate);
        this.delegate = delegate;
        try {
            this.defaultFacesContext = FacesContext.class.getDeclaredField("defaultFacesContext");
            this.defaultFacesContext.setAccessible(true);
        }
        catch (NoSuchFieldException nsfe) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Unable to find private field named 'defaultFacesContext' in javax.faces.context.FacesContext.");
            }
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, e.toString(), e);
            }
            this.defaultFacesContext = null;
        }
    }

    public FacesContext getFacesContext(Object context, Object request, Object response, Lifecycle lifecycle) throws FacesException {
        FacesContext ctx = this.delegate.getFacesContext(context, request, response, lifecycle);
        if (ctx == null) {
            String message = MessageFormat.format("Delegate FacesContextFactory, {0}, returned null when calling getFacesContext().", this.delegate.getClass().getName());
            throw new IllegalStateException(message);
        }
        this.injectDefaults(ctx);
        return ctx;
    }

    public FacesContextFactory getWrapped() {
        return this.delegate;
    }

    private void injectDefaults(FacesContext target) {
        block3: {
            FacesContext defaultFC;
            if (this.defaultFacesContext != null && (defaultFC = FacesContextImpl.getDefaultFacesContext()) != null) {
                try {
                    this.defaultFacesContext.set(target, defaultFC);
                }
                catch (IllegalAccessException e) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) break block3;
                    LOGGER.log(Level.SEVERE, e.toString(), e);
                }
            }
        }
    }
}

