if (!Exadel) var Exadel = {};

Exadel.PanelBar = Class.create();

Exadel.PanelBar.prototype = {


	initialize: function(panelId) {
		
		this.FF = (RichFaces.navigatorType() == "FF")?true:false;
		this.isIE = ((navigator.userAgent.toLowerCase().indexOf("msie")!=-1) || (navigator.userAgent.toLowerCase().indexOf("explorer")!=-1))?true:false;
		this.panel=$(panelId); //+"_p"

		if (!this.panel) {
			return;
		}
		this.hclient=0;
		this.COUNT=0;
		this.STEP=0;
		this.slides=new Array();
		this.ch=this.panel.clientHeight;
		this._attachBehaviors();
		
		this.input=$(panelId+"_panelBarInput");

		this.defaultIndex=$F(panelId+"_panelBarInput");
		
		Event.observe(window,'load',this.handleOnLoad.bindAsEventListener(this));

		
		this.showSlide(this.slides[this.defaultIndex]);		

		this.contentHight = -1;
	
	},
	
	handleOnLoad: function() {
	    if ( this.timer ){
			clearTimeout(this.timer);
		}
		if (this.panel.clientHeight<=0){
		  this.contentHight = -1;
 		  this.timer = setTimeout(this.handleOnLoad.bind(this), 100);
 		}
	
		
		this.showSlide(this.slides[this.defaultIndex]);		
	},

	getContentHeight: function() {
 
        if(this.contentHight) {
        }
        else{
         this.contentHight = -1;
        }
        
		if(this.contentHight <= -1) {
			var h=0;
			this.hclient=0;
			for(var i=0; i<this.slides.length; i++) {
				h+=this.slides[i].item.offsetHeight;


			}
			this.hclient=h;
			this.contentHight = this.panel.clientHeight-h;
	    }
	 
		return this.contentHight;
	},

	showSlide: function(slide) {
		if (this.current) this.current.hideContent();
		var h=this.getContentHeight();

		slide.content.style.height=(h>0?h:0)+"px";
		if (h<=1 && (this.panel.style.height=="" || this.panel.style.height.indexOf("%")!=-1)) {
			this.panel.style.height="";
			slide.content.style.height="100%";
		}
		slide.showContent();
		this.current=slide;
		this.input.value=this.current.index;

	},
	
	_attachBehaviors: function() {
		var rows=this._getDirectChildrenByTag(this.panel,'DIV');
		for(var i=0; i<rows.length; i++) {
			var subrows=this._getDirectChildrenByTag(rows[i],'DIV');
			this.slides.push(new Exadel.PanelBar.Slide(this,rows[i],subrows[0],subrows[1],subrows[2],i)); //ndex
		}
	},


	_getDirectChildrenByTag: function( e, tagName ) {
	
		var kids = new Array();
		var allKids = e.childNodes;
		for( var i = 0 ; i < allKids.length ; i++ ) {
			var item=allKids[i];
			if (item && item.tagName && item.tagName.toUpperCase() == tagName.toUpperCase()){
				kids.push(item);
			}
		}
		return kids;

	}

}

Exadel.PanelBar.Slide = Class.create();
Exadel.PanelBar.Slide.prototype = {

	initialize: function(slidePanel,item,header,header_act,content,index){

		this.index=index;
		this.slidePanel=slidePanel;
		this.item=item;
		this.header=header;
		this.header_act=header_act;
		this.content=content;
		this.item.style.overflow="hidden";
//		this.header.style.overflowX="hidden";
//		this.header.style.overflowY="visible";
//		this.header.style.cursor="pointer";
		this.header.onclick=this.headerOnClick.bindAsEventListener(this);
		this.header.onselectstart=this.headerOnSelectStart.bindAsEventListener(this);
		this.header_act.onclick=this.headerOnClick.bindAsEventListener(this);
		this.header_act.onselectstart=this.headerOnSelectStart.bindAsEventListener(this);
		this.content.style.display="none";
		this.content.style.overflow="auto";
		this.content.style.height="0px";
//		this.content.style.paddingRight="0px";
		this.hightFirefoxDelta = 0;

		if (this.slidePanel.isIE){
			if (this.slidePanel.panel.style.width.indexOf("%")!=-1) {
				this.item.style.width="100%";
			} else {
				this.item.style.width=this.slidePanel.panel.style.width;
			}
        }

		
	},

	showContent: function() {
		this.content.style.display="block";
		this.content.firstChild.style.height="";
		this.header.style.display="none";
		this.header_act.style.display="";		
		
	},

	hideContent: function() {
		this.content.style.display="none";
		this.content.firstChild.style.height="100%";
		this.header_act.style.display="none";
		this.header.style.display="";				
	},

	headerOnClick: function() {
		if (this.content.style.display=="block") return;		
		//this.header.style.display="none";
		//this.header_act.style.display="";		
		this.slidePanel.showSlide(this);
		this.slidePanel.panel.style.maxHeight="";
		this.slidePanel.panel.style.minHeight="";
	},

	headerOnSelectStart: function() {
		return false;
	}
}
