/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io.archive.tar;

import de.schlichtherle.io.archive.Archive;
import de.schlichtherle.io.archive.tar.TarDriver;
import de.schlichtherle.io.archive.tar.TarInputArchive;
import de.schlichtherle.io.archive.tar.TarOutputArchive;
import de.schlichtherle.io.rof.ReadOnlyFile;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import javax.swing.Icon;

public class TarGZipDriver
extends TarDriver {
    private static final long serialVersionUID = 7736164529936091928L;
    private static final int BUFSIZE = 4096;
    public static final int DEFAULT_LEVEL = 9;
    private final int level;

    public TarGZipDriver() {
        this("US-ASCII", null, null, 9);
    }

    public TarGZipDriver(String charset) {
        this(charset, null, null, 9);
    }

    public TarGZipDriver(int level) {
        this("US-ASCII", null, null, level);
    }

    public TarGZipDriver(String charset, Icon openIcon, Icon closedIcon, int level) {
        super(charset, null, null);
        if ((level < 1 || level > 9) && level != -1) {
            throw new IllegalArgumentException();
        }
        this.level = level;
    }

    public final int getLevel() {
        return this.level;
    }

    protected InputStream createInputStream(Archive archive, ReadOnlyFile rof) throws IOException {
        return new GZIPInputStream(super.createInputStream(archive, rof), 4096);
    }

    protected TarOutputArchive createTarOutputArchive(Archive archive, OutputStream out, TarInputArchive source) throws IOException {
        return super.createTarOutputArchive(archive, new GZIPOutputStream(out, 4096, this.level), source);
    }

    public static class GZIPOutputStream
    extends java.util.zip.GZIPOutputStream {
        public GZIPOutputStream(OutputStream out, int size, int level) throws IOException {
            super(out, size);
            this.def.setLevel(level);
        }
    }
}

