/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.util.Map;
import javax.faces.context.FacesContext;
import org.richfaces.component.UIPanelMenu;
import org.richfaces.context.RequestContext;

public final class PanelMenuRendererHelper {
    private static final String CONTEXT_ATTRIBUTE_NAME = PanelMenuRendererHelper.class.getName();

    private PanelMenuRendererHelper() {
    }

    public static PanelMenuState getOrCreateState(FacesContext context, UIPanelMenu panelMenu) {
        String clientId;
        RequestContext requestContext = RequestContext.getInstance((FacesContext)context);
        Map panelMenuStatesMap = requestContext.getOrCreateNestedMap(CONTEXT_ATTRIBUTE_NAME);
        PanelMenuState panelMenuState = (PanelMenuState)panelMenuStatesMap.get(clientId = panelMenu.getClientId(context));
        if (panelMenuState == null) {
            panelMenuState = new PanelMenuState(panelMenu.getSelectedName());
            panelMenuStatesMap.put(clientId, panelMenuState);
        }
        return panelMenuState;
    }

    public static final class PanelMenuState {
        private boolean childMarked = false;
        private String selectedChildName;

        public PanelMenuState(String selectedChildName) {
            this.selectedChildName = selectedChildName;
        }

        public boolean queryAndMarkSelection(String childName) {
            if (this.selectedChildName == null || this.selectedChildName.length() == 0) {
                return false;
            }
            boolean selected = false;
            if (this.selectedChildName.equals(childName)) {
                this.childMarked = true;
                selected = true;
            }
            return selected;
        }

        public String getSelectedItemInputValue() {
            return this.childMarked ? this.selectedChildName : null;
        }
    }
}

