/*
 * Decompiled with CFR 0.152.
 */
package org.custommonkey.xmlunit;

import org.custommonkey.xmlunit.NodeDescriptor;
import org.custommonkey.xmlunit.NodeDetail;

public class Difference {
    private final int id;
    private final String description;
    private boolean recoverable;
    private NodeDetail controlNodeDetail = null;
    private NodeDetail testNodeDetail = null;

    protected Difference(int id, String description) {
        this(id, description, false);
    }

    protected Difference(int id, String description, boolean recoverable) {
        this.id = id;
        this.description = description;
        this.recoverable = recoverable;
    }

    protected Difference(Difference prototype, NodeDetail controlNodeDetail, NodeDetail testNodeDetail) {
        this(prototype.getId(), prototype.getDescription(), prototype.isRecoverable());
        this.controlNodeDetail = controlNodeDetail;
        this.testNodeDetail = testNodeDetail;
    }

    public int getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isRecoverable() {
        return this.recoverable;
    }

    protected void setRecoverable(boolean overrideValue) {
        this.recoverable = overrideValue;
    }

    public NodeDetail getControlNodeDetail() {
        return this.controlNodeDetail;
    }

    public NodeDetail getTestNodeDetail() {
        return this.testNodeDetail;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other instanceof Difference) {
            Difference otherDifference = (Difference)other;
            return this.id == otherDifference.getId();
        }
        return false;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.controlNodeDetail == null || this.testNodeDetail == null) {
            this.appendBasicRepresentation(buf);
        } else {
            this.appendDetailedRepresentation(buf);
        }
        return buf.toString();
    }

    private void appendBasicRepresentation(StringBuffer buf) {
        buf.append("Difference (#").append(this.id).append(") ").append(this.description);
    }

    private void appendDetailedRepresentation(StringBuffer buf) {
        buf.append("Expected ").append(this.getDescription()).append(" '").append(this.controlNodeDetail.getValue()).append("' but was '").append(this.testNodeDetail.getValue()).append("' - comparing ");
        NodeDescriptor.appendNodeDetail(buf, this.controlNodeDetail);
        buf.append(" to ");
        NodeDescriptor.appendNodeDetail(buf, this.testNodeDetail);
    }
}

