/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.hibernate.util.StringHelper;

public class InFragment {
    public static final String NULL = "null";
    public static final String NOT_NULL = "not null";
    private String columnName;
    private List values = new ArrayList();

    public InFragment addValue(Object value) {
        this.values.add(value);
        return this;
    }

    public InFragment setColumn(String columnName) {
        this.columnName = columnName;
        return this;
    }

    public InFragment setColumn(String alias, String columnName) {
        this.columnName = StringHelper.qualify(alias, columnName);
        return this.setColumn(this.columnName);
    }

    public InFragment setFormula(String alias, String formulaTemplate) {
        this.columnName = StringHelper.replace(formulaTemplate, "$PlaceHolder$", alias);
        return this.setColumn(this.columnName);
    }

    public String toFragmentString() {
        if (this.values.size() == 0) {
            return "1=2";
        }
        StringBuffer buf = new StringBuffer(this.values.size() * 5);
        buf.append(this.columnName);
        if (this.values.size() > 1) {
            boolean allowNull = false;
            buf.append(" in (");
            Iterator iter = this.values.iterator();
            while (iter.hasNext()) {
                Object value = iter.next();
                if (NULL.equals(value)) {
                    allowNull = true;
                    continue;
                }
                if (NOT_NULL.equals(value)) {
                    throw new IllegalArgumentException("not null makes no sense for in expression");
                }
                buf.append(value);
                buf.append(", ");
            }
            buf.setLength(buf.length() - 2);
            buf.append(')');
            if (allowNull) {
                buf.insert(0, " is null or ").insert(0, this.columnName).insert(0, '(').append(')');
            }
        } else {
            Object value = this.values.iterator().next();
            if (NULL.equals(value)) {
                buf.append(" is null");
            } else if (NOT_NULL.equals(value)) {
                buf.append(" is not null");
            } else {
                buf.append("=").append(value);
            }
        }
        return buf.toString();
    }
}

