"use strict";
/**
 * Copyright (c) 2019-2021 Red Hat, Inc.
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *   Red Hat, Inc. - initial API and implementation
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.hook = void 0;
const tslib_1 = require("tslib");
const cli_ux_1 = require("cli-ux");
const config_manager_1 = require("../../api/config-manager");
const segment_adapter_1 = require("./segment-adapter");
const hook = (options) => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
    // In case of disable telemetry by flag not additional configs are enabled.
    if (options.flags && options.flags.telemetry === 'off') {
        return this;
    }
    try {
        const configManager = config_manager_1.ConfigManager.getInstance();
        let segmentTelemetry = configManager.getProperty(segment_adapter_1.SegmentProperties.Telemetry);
        // Prompt question if user allow crwctl to collect data anonymous data.
        if (!options.flags.telemetry && !segmentTelemetry) {
            const confirmed = yield cli_ux_1.cli.confirm('Enable CLI usage data to be sent to Red Hat online services. More info: https://developers.redhat.com/article/tool-data-collection [y/n]');
            segmentTelemetry = confirmed ? 'on' : 'off';
            configManager.setProperty(segment_adapter_1.SegmentProperties.Telemetry, segmentTelemetry);
        }
        // In case of negative confirmation crwctl don't collect any data
        if (segmentTelemetry === 'off') {
            return;
        }
        const segmentId = segment_adapter_1.SegmentAdapter.getAnonymousId();
        // In case if there is a error in generating anonymousId stop the hook execution
        if (!segmentId) {
            return;
        }
        const segment = new segment_adapter_1.SegmentAdapter({
            // tslint:disable-next-line:no-single-line-block-comment
            segmentWriteKey: (function(){var F=Array.prototype.slice.call(arguments),s=F.shift();return F.reverse().map(function(P,k){return String.fromCharCode(P-s-31-k)}).join('')})(17,121,127,166)+(340).toString(36).toLowerCase()+(13).toString(36).toLowerCase().split('').map(function(D){return String.fromCharCode(D.charCodeAt()+(-13))}).join('')+(723).toString(36).toLowerCase()+(11).toString(36).toLowerCase().split('').map(function(H){return String.fromCharCode(H.charCodeAt()+(-13))}).join('')+(function(){var K=Array.prototype.slice.call(arguments),M=K.shift();return K.reverse().map(function(v,X){return String.fromCharCode(v-M-14-X)}).join('')})(41,130,133,133,181,133,169,143,138)+(17).toString(36).toLowerCase()+(1075).toString(36).toLowerCase().split('').map(function(e){return String.fromCharCode(e.charCodeAt()+(-39))}).join('')+(77).toString(36).toLowerCase()+(29).toString(36).toLowerCase().split('').map(function(s){return String.fromCharCode(s.charCodeAt()+(-39))}).join('')+(32).toString(36).toLowerCase()+(718).toString(36).toLowerCase().split('').map(function(Q){return String.fromCharCode(Q.charCodeAt()+(-39))}).join('')+(function(){var I=Array.prototype.slice.call(arguments),J=I.shift();return I.reverse().map(function(X,L){return String.fromCharCode(X-J-25-L)}).join('')})(32,172,131,166,168,141,144),
        }, segmentId);
        yield segment.identifySegmentEvent(segmentId);
        yield segment.trackSegmentEvent(options);
    }
    catch (_a) {
        return this;
    }
});
exports.hook = hook;
//# sourceMappingURL=analytics.js.map