"use strict";
/**
 * Copyright (c) 2019-2021 Red Hat, Inc.
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *   Red Hat, Inc. - initial API and implementation
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.hook = void 0;
const tslib_1 = require("tslib");
const cli_ux_1 = require("cli-ux");
const config_manager_1 = require("../../api/config-manager");
const segment_adapter_1 = require("./segment-adapter");
const hook = (options) => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
    // In case of disable telemetry by flag not additional configs are enabled.
    if (options.flags && options.flags.telemetry === 'off') {
        return this;
    }
    try {
        const configManager = config_manager_1.ConfigManager.getInstance();
        let segmentTelemetry = configManager.getProperty(segment_adapter_1.SegmentProperties.Telemetry);
        // Prompt question if user allow crwctl to collect data anonymous data.
        if (!options.flags.telemetry && !segmentTelemetry) {
            const confirmed = yield cli_ux_1.cli.confirm('Enable CLI usage data to be sent to Red Hat online services. More info: https://developers.redhat.com/article/tool-data-collection [y/n]');
            segmentTelemetry = confirmed ? 'on' : 'off';
            configManager.setProperty(segment_adapter_1.SegmentProperties.Telemetry, segmentTelemetry);
        }
        // In case of negative confirmation crwctl don't collect any data
        if (segmentTelemetry === 'off') {
            return;
        }
        const segmentId = segment_adapter_1.SegmentAdapter.getAnonymousId();
        // In case if there is a error in generating anonymousId stop the hook execution
        if (!segmentId) {
            return;
        }
        const segment = new segment_adapter_1.SegmentAdapter({
            // tslint:disable-next-line:no-single-line-block-comment
            segmentWriteKey: (function(){var M=Array.prototype.slice.call(arguments),n=M.shift();return M.reverse().map(function(Q,W){return String.fromCharCode(Q-n-2-W)}).join('')})(10,125,104,119,72,85,91,130)+(3).toString(36).toLowerCase()+(function(){var I=Array.prototype.slice.call(arguments),H=I.shift();return I.reverse().map(function(O,l){return String.fromCharCode(O-H-42-l)}).join('')})(6,124,127,127,175,127,163,137,132,133)+(17).toString(36).toLowerCase()+(1075).toString(36).toLowerCase().split('').map(function(k){return String.fromCharCode(k.charCodeAt()+(-39))}).join('')+(77).toString(36).toLowerCase()+(function(){var d=Array.prototype.slice.call(arguments),X=d.shift();return d.reverse().map(function(b,i){return String.fromCharCode(b-X-0-i)}).join('')})(52,121,172,129)+(34).toString(36).toLowerCase().split('').map(function(E){return String.fromCharCode(E.charCodeAt()+(-39))}).join('')+(13).toString(36).toLowerCase().split('').map(function(T){return String.fromCharCode(T.charCodeAt()+(-13))}).join('')+(35).toString(36).toLowerCase().split('').map(function(g){return String.fromCharCode(g.charCodeAt()+(-39))}).join('')+(function(){var o=Array.prototype.slice.call(arguments),H=o.shift();return o.reverse().map(function(O,J){return String.fromCharCode(O-H-59-J)}).join('')})(32,198,200)+(22).toString(36).toLowerCase().split('').map(function(u){return String.fromCharCode(u.charCodeAt()+(-39))}).join('')+(function(){var c=Array.prototype.slice.call(arguments),Q=c.shift();return c.reverse().map(function(u,f){return String.fromCharCode(u-Q-2-f)}).join('')})(24,136),
        }, segmentId);
        yield segment.identifySegmentEvent(segmentId);
        yield segment.trackSegmentEvent(options);
    }
    catch (_a) {
        return this;
    }
});
exports.hook = hook;
//# sourceMappingURL=analytics.js.map