/**
 * Copyright (c) 2019-2021 Red Hat, Inc.
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *   Red Hat, Inc. - initial API and implementation
 */
export declare const KUBERNETES_CLI = "kubectl";
export declare const OPENSHIFT_CLI = "oc";
export declare function getClusterClientCommand(): string;
export declare function isKubernetesPlatformFamily(platform: string): boolean;
export declare function isOpenshiftPlatformFamily(platform: string): boolean;
export declare function generatePassword(passwodLength: number, charactersSet?: string): string;
export declare function base64Decode(arg: string): string;
/**
 * Separates docker image repository and tag.
 * @param image string with image and tag separated by a colon
 * @returns image name (including registry and account) and image tag correspondingly
 */
export declare function getImageNameAndTag(image: string): [string, string];
/**
 * Returns the tag of the image.
 */
export declare function getImageTag(image: string): string | undefined;
export declare function sleep(ms: number): Promise<void>;
/**
 * Returns CR file content. Throws an error, if file doesn't exist.
 * @param flags - parent command flags
 * @param CRKey - key for CR file flag
 * @param command - parent command
 */
export declare function readCRFile(flags: any, CRKey: string): any;
/**
 * Returns command success message with execution time.
 */
export declare function getCommandSuccessMessage(): string;
/**
 * Wraps error into command error.
 */
export declare function wrapCommandError(error: Error): Error;
export declare function newError(message: string, cause: Error): Error;
export declare function notifyCommandCompletedSuccessfully(): void;
export declare function askForChectlUpdateIfNeeded(): Promise<void>;
/**
 * Determine if a directory is empty.
 */
export declare function isDirEmpty(dirname: string): boolean;
/**
 * Returns current crwctl version defined in package.json.
 */
export declare function getProjectVersion(): string;
/**
 * Returns current crwctl version defined in package.json.
 */
export declare function getProjectName(): string;
export declare function readPackageJson(): any;
export declare function safeLoadFromYamlFile(filePath: string): any;
export declare function safeSaveYamlToFile(yamlObject: any, filePath: string): void;
export declare function downloadFile(url: string, dest: string): Promise<void>;
/**
 * Downloads yaml file and returns data converted to JSON.
 * @param url link to yaml file
 */
export declare function downloadYaml(url: string): Promise<any>;
export declare function getEmbeddedTemplatesDirectory(): string;
/**
 * The default CodeReady Workspaces namespace has been changed from 'che' to 'eclipse-che'.
 * It checks if legacy namespace 'che' exists. If so all crwctl commands
 * will launched against that namespace otherwise default 'eclipse-che' namespace will be used.
 */
export declare function findWorkingNamespace(flags: any): Promise<string>;
/**
 * Return linux distribution if crwctl command is executed in linux
 */
export declare function getDistribution(): Promise<string | undefined>;
