/// <reference types="mocha" />
export declare type PluginBuilder<I, Args extends any[]> = (...args: Args) => Plugin<I>;
import Nock = require('nock');
export interface Context {
    test: (typeof it | typeof it.skip);
    plugins: {
        [k: string]: PluginBuilder<any, any>;
    };
    expectation?: string;
    chain: Plugin<any>[];
    error?: Error & {
        code?: string;
    };
    retries?: number;
    timeout?: number;
}
export interface Plugin<I> {
    run?(context: I): any;
    init?(context: I): any;
    finally?(context: I): any;
    catch?(context: I): any;
}
export interface PluginDef {
    output: object;
    args: any[];
}
export interface Plugins {
    [k: string]: PluginDef;
}
export interface ITestCallbackContext {
    skip(): this;
    timeout(ms: number | string): this;
    retries(n: number): this;
    slow(ms: number): this;
    [index: string]: any;
}
export declare type MochaCallback<I> = (this: ITestCallbackContext, context: I, done: Mocha.Done) => any;
export interface It<I> {
    (expectation: string, cb?: MochaCallback<I>): void;
    (cb?: MochaCallback<I>): void;
}
export declare type Base<I extends Context, T extends Plugins> = {
    it: It<I>;
    end: It<I>;
    add<K extends string, O>(key: K, cb: ((context: I) => Promise<O> | O) | Promise<O> | O): Base<I & {
        [P in K]: O;
    }, T>;
    do<O>(cb: (context: I & O) => any): Base<O & I, T>;
    finally(cb: (context: I) => any): Base<I, T>;
    register<K extends string, O, A extends any[]>(key: K, plugin: (...args: A) => Plugin<O & I>): Base<I, T & {
        [P in K]: {
            output: O;
            args: A;
        };
    }>;
} & {
    [P in keyof T]: (...args: T[P]['args']) => Base<T[P]['output'] & I, T>;
};
export interface EnvOptions {
    clear?: boolean;
}
export interface NockScope extends Nock.Scope {
}
export interface NockOptions extends Nock.Options {
}
export declare type NockCallback = (nock: NockScope) => any;
