/*********************************************************************
 * Copyright (c) 2019-2020 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 **********************************************************************/
/// <reference types="node" />
import { ExtensionsV1beta1IngressList, KubeConfig, Log, PortForward, V1beta1CustomResourceDefinition, V1ClusterRole, V1ClusterRoleBinding, V1ConfigMap, V1Deployment, V1DeploymentList, V1Job, V1NamespaceList, V1PersistentVolumeClaimList, V1Pod, V1PodList, V1RoleBinding, V1Secret, V1Service, V1ServiceAccount, V1ServiceList } from '@kubernetes/client-node';
import { Cluster, Context } from '@kubernetes/client-node/dist/config_types';
import { CatalogSource, ClusterServiceVersionList, InstallPlan, PackageManifest, Subscription } from './typings/olm';
import { IdentityProvider } from './typings/openshift';
export declare class KubeHelper {
    static readonly KUBE_CONFIG: KubeConfig;
    static initializeKubeConfig(): KubeConfig;
    portForwardHelper: PortForward;
    logHelper: Log;
    podWaitTimeout: number;
    podReadyTimeout: number;
    constructor(flags?: any);
    deleteAllServices(namespace?: string): Promise<void>;
    applyResource(yamlPath: string, opts?: string): Promise<void>;
    getServicesBySelector(labelSelector?: string, namespace?: string): Promise<V1ServiceList>;
    waitForService(selector: string, namespace?: string, intervalMs?: number, timeoutMs?: number): Promise<void>;
    serviceAccountExist(name?: string, namespace?: string): Promise<boolean>;
    createServiceAccount(name?: string, namespace?: string): Promise<{
        response: import("http").IncomingMessage;
        body: V1ServiceAccount;
    }>;
    waitServiceAccount(name: string, namespace: string, timeout?: number): Promise<void>;
    deleteServiceAccount(name?: string, namespace?: string): Promise<void>;
    createServiceAccountFromFile(filePath: string, namespace?: string): Promise<{
        response: import("http").IncomingMessage;
        body: V1ServiceAccount;
    }>;
    replaceServiceAccountFromFile(filePath: string, namespace?: string): Promise<{
        response: import("http").IncomingMessage;
        body: V1ServiceAccount;
    }>;
    roleExist(name?: string, namespace?: string): Promise<boolean>;
    clusterRoleExist(name?: string): Promise<boolean>;
    getClusterRole(name: string): Promise<V1ClusterRole | undefined>;
    createRoleFromFile(filePath: string, namespace?: string): Promise<any>;
    replaceRoleFromFile(filePath: string, namespace?: string): Promise<any>;
    createClusterRoleFromFile(filePath: string, roleName?: string): Promise<any>;
    replaceClusterRoleFromFile(filePath: string, roleName?: string): Promise<any>;
    addClusterRoleRule(name: string, apiGroups: string[], resources: string[], verbs: string[]): Promise<V1ClusterRole | undefined>;
    deleteRole(name?: string, namespace?: string): Promise<void>;
    getPodListByLabel(namespace: string | undefined, labelSelector: string): Promise<V1Pod[]>;
    deleteClusterRole(name?: string): Promise<void>;
    roleBindingExist(name?: string, namespace?: string): Promise<boolean>;
    clusterRoleBindingExist(name?: string): Promise<boolean | ''>;
    createAdminRoleBinding(name?: string, serviceAccount?: string, namespace?: string): Promise<{
        response: import("http").IncomingMessage;
        body: V1RoleBinding;
    }>;
    createRoleBindingFromFile(filePath: string, namespace?: string): Promise<{
        response: import("http").IncomingMessage;
        body: V1RoleBinding;
    }>;
    replaceRoleBindingFromFile(filePath: string, namespace?: string): Promise<{
        response: import("http").IncomingMessage;
        body: V1RoleBinding;
    }>;
    createClusterRoleBindingFrom(yamlClusterRoleBinding: V1ClusterRoleBinding): Promise<{
        response: import("http").IncomingMessage;
        body: V1ClusterRoleBinding;
    }>;
    createClusterRoleBinding(name: string, saName: string, saNamespace?: string, roleName?: string): Promise<{
        response: import("http").IncomingMessage;
        body: V1ClusterRoleBinding;
    }>;
    replaceClusterRoleBinding(name: string, saName: string, saNamespace?: string, roleName?: string): Promise<{
        response: import("http").IncomingMessage;
        body: V1ClusterRoleBinding;
    }>;
    deleteRoleBinding(name?: string, namespace?: string): Promise<{
        response: import("http").IncomingMessage;
        body: import("@kubernetes/client-node").V1Status;
    }>;
    deleteClusterRoleBinding(name?: string): Promise<{
        response: import("http").IncomingMessage;
        body: import("@kubernetes/client-node").V1Status;
    }>;
    getConfigMap(name?: string, namespace?: string): Promise<V1ConfigMap | undefined>;
    createConfigMapFromFile(filePath: string, namespace?: string): Promise<V1ConfigMap>;
    createNamespacedConfigMap(namespace: string, configMap: V1ConfigMap): Promise<V1ConfigMap>;
    patchConfigMap(name: string, patch: any, namespace?: string): Promise<{
        response: import("http").IncomingMessage;
        body: V1ConfigMap;
    }>;
    deleteConfigMap(name: string, namespace?: string): Promise<void>;
    replaceNamespacedConfigMap(name: string, namespace: string, configMap: V1ConfigMap): Promise<V1ConfigMap>;
    namespaceExist(namespace: string): Promise<boolean>;
    hasReadPermissionsForNamespace(namespace: string): Promise<boolean>;
    readNamespacedPod(podName: string, namespace: string): Promise<V1Pod | undefined>;
    patchNamespacedPod(name: string, namespace: string, patch: any): Promise<V1Pod | undefined>;
    podsExistBySelector(selector: string, namespace?: string): Promise<boolean>;
    getPodPhase(labelSelector: string, namespace?: string): Promise<string | undefined>;
    getPodReadyConditionStatus(selector: string, namespace?: string): Promise<string | undefined>;
    waitForPodPhase(selector: string, targetPhase: string, namespace?: string, intervalMs?: number, timeoutMs?: number): Promise<void>;
    waitForPodPending(selector: string, namespace?: string, intervalMs?: number, timeoutMs?: number): Promise<void>;
    waitForPodReady(selector: string, namespace?: string, intervalMs?: number, timeoutMs?: number): Promise<void>;
    waitUntilPodIsDeleted(selector: string, namespace?: string, intervalMs?: number, timeoutMs?: number): Promise<void>;
    deletePod(name: string, namespace?: string): Promise<{
        response: import("http").IncomingMessage;
        body: V1Pod;
    }>;
    waitLatestReplica(deploymentName: string, namespace?: string, intervalMs?: number, timeoutMs?: number): Promise<void>;
    deploymentExist(name?: string, namespace?: string): Promise<boolean>;
    deploymentReady(name?: string, namespace?: string): Promise<boolean>;
    deploymentStopped(name?: string, namespace?: string): Promise<boolean>;
    isDeploymentPaused(name?: string, namespace?: string): Promise<boolean>;
    pauseDeployment(name?: string, namespace?: string): Promise<void>;
    resumeDeployment(name?: string, namespace?: string): Promise<void>;
    scaleDeployment(name: string | undefined, namespace: string | undefined, replicas: number): Promise<void>;
    createDeployment(name: string, image: string, serviceAccount: string, pullPolicy: string, configMapEnvSource: string, namespace: string): Promise<{
        response: import("http").IncomingMessage;
        body: V1Deployment;
    }>;
    createDeploymentFromFile(filePath: string, namespace?: string, containerImage?: string, containerIndex?: number): Promise<{
        response: import("http").IncomingMessage;
        body: V1Deployment;
    }>;
    createDeploymentFrom(yamlDeployment: V1Deployment, namespace?: string): Promise<{
        response: import("http").IncomingMessage;
        body: V1Deployment;
    }>;
    createServiceFrom(yamlService: V1Service, namespace?: string): Promise<{
        response: import("http").IncomingMessage;
        body: V1Service;
    }>;
    replaceDeploymentFromFile(filePath: string, namespace?: string, containerImage?: string, containerIndex?: number): Promise<{
        response: import("http").IncomingMessage;
        body: V1Deployment;
    }>;
    deleteAllDeployments(namespace?: string): Promise<void>;
    getDeploymentsBySelector(labelSelector?: string, namespace?: string): Promise<V1DeploymentList>;
    getDeployment(name: string, namespace: string): Promise<V1Deployment | undefined>;
    createPod(name: string, image: string, serviceAccount: string, restartPolicy: string, pullPolicy: string, configMapEnvSource: string, namespace: string): Promise<{
        response: import("http").IncomingMessage;
        body: V1Pod;
    }>;
    createJob(name: string, image: string, serviceAccount: string, namespace: string, backoffLimit?: number, restartPolicy?: string): Promise<{
        response: import("http").IncomingMessage;
        body: V1Job;
    }>;
    getJob(jobName: string, namespace: string): Promise<V1Job>;
    waitJob(jobName: string, namespace: string, timeout?: number): Promise<void>;
    deleteJob(jobName: string, namespace: string): Promise<boolean>;
    compare(body: any, name: string): Promise<boolean>;
    isCRDCompatible(crdClusterName: string, crdFilePath: string): Promise<boolean>;
    ingressExist(name?: string, namespace?: string): Promise<boolean>;
    deleteAllIngresses(namespace?: string): Promise<void>;
    createCrdFromFile(filePath: string): Promise<{
        response: import("http").IncomingMessage;
        body: V1beta1CustomResourceDefinition;
    }>;
    replaceCrdFromFile(filePath: string, resourceVersion: string): Promise<{
        response: import("http").IncomingMessage;
        body: V1beta1CustomResourceDefinition;
    }>;
    crdExist(name?: string): Promise<boolean>;
    getCrd(name?: string): Promise<V1beta1CustomResourceDefinition>;
    deleteCrd(name: string): Promise<void>;
    createCheClusterFromFile(filePath: string, flags: any, ctx: any, useDefaultCR: boolean): Promise<any>;
    overrideDefaultValues(yamlCr: any, filePath: string): any;
    /**
     * Returns `checlusters.org.eclipse.che' in the given namespace.
     */
    getCheCluster(namespace: string): Promise<any | undefined>;
    /**
     * Returns all `checlusters.org.eclipse.che' resources
     */
    getAllCheCluster(): Promise<any[]>;
    /**
     * Deletes `checlusters.org.eclipse.che' resources in the given namespace.
     */
    deleteCheCluster(namespace: string): Promise<void>;
    isPreInstalledOLM(): Promise<boolean>;
    getAmoutUsers(): Promise<number>;
    getOpenshiftAuthProviders(): Promise<IdentityProvider[]>;
    operatorSourceExists(name: string, namespace: string): Promise<boolean>;
    catalogSourceExists(name: string, namespace: string): Promise<boolean>;
    getOAuthClientAuthorizations(clientName: string): Promise<string[]>;
    deleteOAuthClientAuthorizations(oAuthClientAuthorizations: any[]): Promise<void>;
    consoleLinkExists(name: string): Promise<boolean>;
    deleteConsoleLink(name: string): Promise<void>;
    getCatalogSource(name: string, namespace: string): Promise<CatalogSource>;
    readCatalogSourceFromFile(filePath: string): CatalogSource;
    createCatalogSource(catalogSource: CatalogSource): Promise<object>;
    waitCatalogSource(namespace: string, catalogSourceName: string, timeout?: number): Promise<CatalogSource>;
    deleteCatalogSource(namespace: string, catalogSourceName: string): Promise<void>;
    operatorGroupExists(name: string, namespace: string): Promise<boolean>;
    createOperatorGroup(operatorGroupName: string, namespace: string): Promise<object>;
    deleteOperatorGroup(operatorGroupName: string, namespace: string): Promise<void>;
    createOperatorSubscription(subscription: Subscription): Promise<object>;
    getOperatorSubscription(name: string, namespace: string): Promise<Subscription>;
    operatorSubscriptionExists(name: string, namespace: string): Promise<boolean>;
    deleteOperatorSubscription(operatorSubscriptionName: string, namespace: string): Promise<void>;
    waitOperatorSubscriptionReadyForApproval(namespace: string, subscriptionName: string, timeout?: number): Promise<InstallPlan>;
    approveOperatorInstallationPlan(name?: string, namespace?: string): Promise<void>;
    waitUntilOperatorIsInstalled(installPlanName: string, namespace: string, timeout?: number): Promise<InstallPlan>;
    getClusterServiceVersions(namespace: string): Promise<ClusterServiceVersionList>;
    deleteClusterServiceVersion(namespace: string, csvName: string): Promise<ClusterServiceVersionList>;
    getPackageManifect(name: string): Promise<PackageManifest>;
    deleteNamespace(namespace: string): Promise<void>;
    clusterIssuerExists(name: string): Promise<boolean>;
    createCheClusterIssuer(cheClusterIssuerYamlPath: string): Promise<void>;
    createCheClusterCertificate(certificateTemplatePath: string, domain: string, namespace: string): Promise<void>;
    currentContext(): Promise<string>;
    getContext(name: string): Context | null;
    /**
     * Retrieve the default token from the default serviceAccount.
     */
    getDefaultServiceAccountToken(): Promise<string>;
    checkKubeApi(): Promise<void>;
    requestKubeHealthz(currentCluster: Cluster, token?: string): Promise<void>;
    isOpenShift(): Promise<boolean>;
    getIngressHost(name?: string, namespace?: string): Promise<string>;
    getIngressProtocol(name?: string, namespace?: string): Promise<string>;
    getIngressesBySelector(labelSelector?: string, namespace?: string): Promise<ExtensionsV1beta1IngressList>;
    isOpenShift4(): Promise<boolean>;
    getSecret(name?: string, namespace?: string): Promise<V1Secret | undefined>;
    /**
     * Creates a secret with given name and data.
     * Data should not be base64 encoded.
     */
    createSecret(name: string, data: {
        [key: string]: string;
    }, namespace: string): Promise<V1Secret | undefined>;
    /**
     * Awaits secret to be present and contain non-empty data fields specified in dataKeys parameter.
     */
    waitSecret(secretName: string, namespace: string, dataKeys?: string[], timeout?: number): Promise<void>;
    persistentVolumeClaimExist(name?: string, namespace?: string): Promise<boolean>;
    deletePersistentVolumeClaim(name?: string, namespace?: string): Promise<void>;
    getPersistentVolumeClaimsBySelector(labelSelector?: string, namespace?: string): Promise<V1PersistentVolumeClaimList>;
    listNamespace(): Promise<V1NamespaceList>;
    listNamespacedPod(namespace: string, fieldSelector?: string, labelSelector?: string): Promise<V1PodList>;
    /**
     * Reads log by chunk and writes into a file.
     */
    readNamespacedPodLog(pod: string, namespace: string, container: string, filename: string, follow: boolean): Promise<void>;
    /**
     * Forwards port, based on the example
     * https://github.com/kubernetes-client/javascript/blob/master/examples/typescript/port-forward/port-forward.ts
     */
    portForward(podName: string, namespace: string, port: number): Promise<void>;
    /**
     * Checks if message is present and returns error with it
     * or returns error with the specified error if message is not found.
     *
     * @param e k8s error to wrap
     */
    private wrapK8sClientError;
    private safeLoadFromYamlFile;
}
