# Licensed to the Apache Software Foundation (ASF) under one or more
# contributor license agreements.  See the NOTICE file distributed with
# this work for additional information regarding copyright ownership.
# The ASF licenses this file to You under the Apache License, Version 2.0
# (the "License"); you may not use this file except in compliance with
# the License.  You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Originally contributed by Mladen Turk <mturk apache.org>
#

CC = cl.exe
LN = link.exe
AR = lib.exe
RC = rc.exe

_CPU = x64
_LIB = lib64

DESTLIB = $(PREFIX)\$(_LIB)
DESTBIN = $(PREFIX)\bin
DESTINC = $(PREFIX)\include\apr-1

!IF !DEFINED(WINVER) || "$(WINVER)" == ""
WINVER = 0x0601
!ENDIF

!IF DEFINED(_STATIC_MSVCRT)
CRT_CFLAGS = -MT
EXTRA_LIBS =
!ELSE
CRT_CFLAGS = -MD
!ENDIF

!IF DEFINED(_STATIC)
TARGET   = lib
PROJECT  = apr-1
ARFLAGS  = /nologo /MACHINE:$(_CPU) $(EXTRA_ARFLAGS)
CFLAGS   = -DAPR_DECLARE_STATIC
!ELSE
TARGET   = dll
PROJECT  = libapr-1
LDFLAGS  = /nologo /INCREMENTAL:NO /OPT:REF /DLL /SUBSYSTEM:WINDOWS /MACHINE:$(_CPU) /DEBUG $(EXTRA_LDFLAGS)
CFLAGS   = -DAPR_DECLARE_EXPORT
!ENDIF

SRCDIR   = .
WORKDIR  = $(_CPU)_$(TARGET)
LDLIBS   = kernel32.lib advapi32.lib ws2_32.lib mswsock.lib shell32.lib rpcrt4.lib $(EXTRA_LIBS)

!IF "$(TARGET)" == "dll"
BUILDOUT = $(WORKDIR)\$(PROJECT).dll
BUILDPDB = $(WORKDIR)\$(PROJECT).pdb
BUILDRES = $(WORKDIR)\$(PROJECT).res
BUILDLIB = $(WORKDIR)\$(PROJECT).lib
!ELSE
BUILDOUT = $(WORKDIR)\$(PROJECT).lib
!ENDIF

INCLUDES = -I$(SRCDIR)\include -I$(SRCDIR)\include\private -I$(SRCDIR)\include\arch -I$(SRCDIR)\include\arch\win32 -I$(SRCDIR)\include\arch\unix
PDBFLAGS = -Fo$(WORKDIR)\ -Fd$(WORKDIR)\$(PROJECT)

CLOPTS = /c /nologo $(CRT_CFLAGS) -W3 -O2 -Ob2 -Zi
CFLAGS = $(CFLAGS) -DNDEBUG -DWIN32 -DWINNT -D_WINDOWS -D_WIN32_WINNT=$(WINVER) -DWINVER=$(WINVER)
CFLAGS = $(CFLAGS) -D_CRT_SECURE_NO_DEPRECATE -D_CRT_NONSTDC_NO_DEPRECATE $(EXTRA_CFLAGS)
RFLAGS = /l 0x409 /n /d NDEBUG /d WIN32 /d WINNT /d WINVER=$(WINVER)
RFLAGS = $(RFLAGS) /d _WIN32_WINNT=$(WINVER) $(EXTRA_RFLAGS)

!IF DEFINED(_VENDOR_SFX)
# vendor_sfx=_2
# perl -pi -e "s;#define APR_IS_DEV_STRING.*;#define APR_IS_DEV_STRING \"$vendor_sfx\";g" include/apr_version.h
CFLAGS = $(CFLAGS) -DAPR_IS_DEV_STRING=\"$(_VENDOR_SFX)\"
RFLAGS = $(RFLAGS) /d APR_IS_DEV_STRING=\"$(_VENDOR_SFX)\"
!ENDIF

OBJECTS = \
	$(WORKDIR)\apr_atomic.obj \
	$(WORKDIR)\apr_atomic64.obj \
	$(WORKDIR)\apr_cpystrn.obj \
	$(WORKDIR)\apr_cstr.obj \
	$(WORKDIR)\apr_encode.obj \
	$(WORKDIR)\apr_escape.obj \
	$(WORKDIR)\apr_fnmatch.obj \
	$(WORKDIR)\apr_getpass.obj \
	$(WORKDIR)\apr_hash.obj \
	$(WORKDIR)\apr_pools.obj \
	$(WORKDIR)\apr_random.obj \
	$(WORKDIR)\apr_skiplist.obj \
	$(WORKDIR)\apr_snprintf.obj \
	$(WORKDIR)\apr_strings.obj \
	$(WORKDIR)\apr_strnatcmp.obj \
	$(WORKDIR)\apr_strtok.obj \
	$(WORKDIR)\apr_tables.obj \
	$(WORKDIR)\buffer.obj \
	$(WORKDIR)\charset.obj \
	$(WORKDIR)\common.obj \
	$(WORKDIR)\copy.obj \
	$(WORKDIR)\dir.obj \
	$(WORKDIR)\dso.obj \
	$(WORKDIR)\env.obj \
	$(WORKDIR)\errorcodes.obj \
	$(WORKDIR)\fileacc.obj \
	$(WORKDIR)\filedup.obj \
	$(WORKDIR)\filepath.obj \
	$(WORKDIR)\filepath_util.obj \
	$(WORKDIR)\filestat.obj \
	$(WORKDIR)\filesys.obj \
	$(WORKDIR)\flock.obj \
	$(WORKDIR)\fullrw.obj \
	$(WORKDIR)\getopt.obj \
	$(WORKDIR)\groupinfo.obj \
	$(WORKDIR)\inet_ntop.obj \
	$(WORKDIR)\inet_pton.obj \
	$(WORKDIR)\internal.obj \
	$(WORKDIR)\misc.obj \
	$(WORKDIR)\mktemp.obj \
	$(WORKDIR)\mmap.obj \
	$(WORKDIR)\multicast.obj \
	$(WORKDIR)\open.obj \
	$(WORKDIR)\otherchild.obj \
	$(WORKDIR)\pipe.obj \
	$(WORKDIR)\poll.obj \
	$(WORKDIR)\pollcb.obj \
	$(WORKDIR)\pollset.obj \
	$(WORKDIR)\proc.obj \
	$(WORKDIR)\proc_mutex.obj \
	$(WORKDIR)\rand.obj \
	$(WORKDIR)\readwrite.obj \
	$(WORKDIR)\seek.obj \
	$(WORKDIR)\select.obj \
	$(WORKDIR)\sendrecv.obj \
	$(WORKDIR)\sha2.obj \
	$(WORKDIR)\sha2_glue.obj \
	$(WORKDIR)\shm.obj \
	$(WORKDIR)\signals.obj \
	$(WORKDIR)\sockaddr.obj \
	$(WORKDIR)\socket_util.obj \
	$(WORKDIR)\sockets.obj \
	$(WORKDIR)\sockopt.obj \
	$(WORKDIR)\start.obj \
	$(WORKDIR)\tempdir.obj \
	$(WORKDIR)\thread.obj \
	$(WORKDIR)\thread_cond.obj \
	$(WORKDIR)\thread_mutex.obj \
	$(WORKDIR)\thread_rwlock.obj \
	$(WORKDIR)\threadpriv.obj \
	$(WORKDIR)\time.obj \
	$(WORKDIR)\timestr.obj \
	$(WORKDIR)\userinfo.obj \
	$(WORKDIR)\utf8.obj \
	$(WORKDIR)\version.obj \
	$(WORKDIR)\wakeup.obj


HEADERS = \
	$(SRCDIR)\include\apr.h \
	$(SRCDIR)\include\private\apr_escape_test_char.h

all : $(WORKDIR) $(HEADERS) $(BUILDOUT)

$(WORKDIR):
	@-md $(WORKDIR)

$(SRCDIR)\include\apr.h: $(SRCDIR)\include\apr.hw
	@type $** > $@

$(SRCDIR)\include\private\apr_escape_test_char.h: $(SRCDIR)\tools\gen_test_char.c
	$(CC) /nologo -MT -W3 -O2 -Ob2 $(CFLAGS) -D_CONSOLE -D_MBCS /Fo$(WORKDIR)\ /Fe$(WORKDIR)\gen_test_char.exe $**
	$(WORKDIR)\gen_test_char.exe > $@

{$(SRCDIR)\atomic\win32}.c{$(WORKDIR)}.obj:
	$(CC) $(CLOPTS) $(INCLUDES) $(CFLAGS) $(PDBFLAGS) $<

{$(SRCDIR)\dso\win32}.c{$(WORKDIR)}.obj:
	$(CC) $(CLOPTS) $(INCLUDES) $(CFLAGS) $(PDBFLAGS) $<

{$(SRCDIR)\encoding}.c{$(WORKDIR)}.obj:
	$(CC) $(CLOPTS) $(INCLUDES) $(CFLAGS) $(PDBFLAGS) $<

{$(SRCDIR)\file_io\unix}.c{$(WORKDIR)}.obj:
	$(CC) $(CLOPTS) $(INCLUDES) $(CFLAGS) $(PDBFLAGS) $<

{$(SRCDIR)\file_io\win32}.c{$(WORKDIR)}.obj:
	$(CC) $(CLOPTS) $(INCLUDES) $(CFLAGS) $(PDBFLAGS) $<

{$(SRCDIR)\locks\win32}.c{$(WORKDIR)}.obj:
	$(CC) $(CLOPTS) $(INCLUDES) $(CFLAGS) $(PDBFLAGS) $<

{$(SRCDIR)\memory\unix}.c{$(WORKDIR)}.obj:
	$(CC) $(CLOPTS) $(INCLUDES) $(CFLAGS) $(PDBFLAGS) $<

{$(SRCDIR)\misc\unix}.c{$(WORKDIR)}.obj:
	$(CC) $(CLOPTS) $(INCLUDES) $(CFLAGS) $(PDBFLAGS) $<

{$(SRCDIR)\misc\win32}.c{$(WORKDIR)}.obj:
	$(CC) $(CLOPTS) $(INCLUDES) $(CFLAGS) $(PDBFLAGS) $<

{$(SRCDIR)\mmap\unix}.c{$(WORKDIR)}.obj:
	$(CC) $(CLOPTS) $(INCLUDES) $(CFLAGS) $(PDBFLAGS) $<

{$(SRCDIR)\mmap\win32}.c{$(WORKDIR)}.obj:
	$(CC) $(CLOPTS) $(INCLUDES) $(CFLAGS) $(PDBFLAGS) $<

{$(SRCDIR)\network_io\unix}.c{$(WORKDIR)}.obj:
	$(CC) $(CLOPTS) $(INCLUDES) $(CFLAGS) $(PDBFLAGS) $<

{$(SRCDIR)\network_io\win32}.c{$(WORKDIR)}.obj:
	$(CC) $(CLOPTS) $(INCLUDES) $(CFLAGS) $(PDBFLAGS) $<

{$(SRCDIR)\passwd}.c{$(WORKDIR)}.obj:
	$(CC) $(CLOPTS) $(INCLUDES) $(CFLAGS) $(PDBFLAGS) $<

{$(SRCDIR)\poll\unix}.c{$(WORKDIR)}.obj:
	$(CC) $(CLOPTS) $(INCLUDES) $(CFLAGS) $(PDBFLAGS) $<

{$(SRCDIR)\random\unix}.c{$(WORKDIR)}.obj:
	$(CC) $(CLOPTS) $(INCLUDES) $(CFLAGS) $(PDBFLAGS) $<

{$(SRCDIR)\shmem\win32}.c{$(WORKDIR)}.obj:
	$(CC) $(CLOPTS) $(INCLUDES) $(CFLAGS) $(PDBFLAGS) $<

{$(SRCDIR)\strings}.c{$(WORKDIR)}.obj:
	$(CC) $(CLOPTS) $(INCLUDES) $(CFLAGS) $(PDBFLAGS) $<

{$(SRCDIR)\tables}.c{$(WORKDIR)}.obj:
	$(CC) $(CLOPTS) $(INCLUDES) $(CFLAGS) $(PDBFLAGS) $<

{$(SRCDIR)\threadproc\win32}.c{$(WORKDIR)}.obj:
	$(CC) $(CLOPTS) $(INCLUDES) $(CFLAGS) $(PDBFLAGS) $<

{$(SRCDIR)\time\win32}.c{$(WORKDIR)}.obj:
	$(CC) $(CLOPTS) $(INCLUDES) $(CFLAGS) $(PDBFLAGS) $<

{$(SRCDIR)\user\win32}.c{$(WORKDIR)}.obj:
	$(CC) $(CLOPTS) $(INCLUDES) $(CFLAGS) $(PDBFLAGS) $<

!IF "$(TARGET)" == "dll"
$(BUILDRES): $(SRCDIR)\libapr.rc
	$(RC) $(RFLAGS) /i "$(SRCDIR)\include" /d "APR_VERSION_ONLY" /fo $(BUILDRES) $**

$(BUILDOUT): $(OBJECTS) $(BUILDRES)
	$(LN) $(LDFLAGS) $** $(LDLIBS) /pdb:$(BUILDPDB) /out:$(BUILDOUT) /implib:$(BUILDLIB)
	@cd build
	@$(MAKE) /nologo -f Makefile.mak
	@cd ..

!ELSE
$(BUILDOUT): $(OBJECTS)
	$(AR) $(ARFLAGS) $** /out:$(BUILDOUT)
	@cd build
	@$(MAKE) /nologo -f Makefile.mak
	@cd ..

!ENDIF

check: all
	@cd test
	@$(MAKE) /nologo -f Makefile.mak check
	@cd ..

clean:
	@-rd /S /Q $(WORKDIR) >NUL 2>&1
	@-del /Q $(SRCDIR)\include\apr.h >NUL 2>&1
	@-del /Q $(SRCDIR)\include\private\apr_escape_test_char.h >NUL 2>&1

!IF "$(TARGET)" == "dll"
install: all
	@xcopy /I /Y /Q "$(SRCDIR)\include\*.h" "$(DESTINC)"
	@xcopy /I /Y /Q "$(SRCDIR)\include\arch\*.h" "$(DESTINC)\arch"
	@xcopy /I /Y /Q "$(SRCDIR)\include\arch\win32\*.h" "$(DESTINC)\arch\win32"
	@xcopy /I /Y /Q "$(WORKDIR)\*.lib" "$(DESTLIB)"
	@xcopy /I /Y /Q "$(WORKDIR)\*.dll" "$(DESTBIN)"
	@xcopy /I /Y /Q "$(WORKDIR)\*.pdb" "$(DESTBIN)"
!ELSE
install: all
	@xcopy /I /Y /Q "$(WORKDIR)\*.lib" "$(DESTLIB)"
	@xcopy /I /Y /Q "$(WORKDIR)\*.pdb" "$(DESTLIB)"
!ENDIF

