# Licensed to the Apache Software Foundation (ASF) under one or more
# contributor license agreements.  See the NOTICE file distributed with
# this work for additional information regarding copyright ownership.
# The ASF licenses this file to You under the Apache License, Version 2.0
# (the "License"); you may not use this file except in compliance with
# the License.  You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Originally contributed by Mladen Turk <mturk apache.org>
#

CC = cl.exe
LN = link.exe
AR = lib.exe
RC = rc.exe

_CPU = x64
_LIB = lib

APRDIR = ..
SRCDIR = .

!IF !DEFINED(WINVER) || "$(WINVER)" == ""
WINVER = 0x0601
!ENDIF

!IF DEFINED(_STATIC_MSVCRT)
CRT_CFLAGS = -MT
!ELSE
CRT_CFLAGS = -MD
!ENDIF

!IF DEFINED(_STATIC)
TARGET   = lib
WORKDIR  = $(_CPU)_$(TARGET)
APR_LIB  = $(APRDIR)\$(WORKDIR)\apr-1.lib
APP_LIB  = $(APRDIR)\$(WORKDIR)\aprapp-1.lib
CFLAGS   = -DAPR_DECLARE_STATIC
!ELSE
TARGET   = dll
WORKDIR  = $(_CPU)_$(TARGET)
APR_LIB  = $(APRDIR)\$(WORKDIR)\libapr-1.lib
APP_LIB  = $(APRDIR)\$(WORKDIR)\libaprapp-1.lib
!ENDIF

INCLUDES = -I$(APRDIR)\include -I$(APRDIR)\include\private -I$(APRDIR)\include\arch -I$(APRDIR)\include\arch\win32 -I$(APRDIR)\include\arch\unix
PDBFLAGS = -Fo$(WORKDIR)\ -Fd$(WORKDIR)\test-suite
LDFLAGS  = /nologo /INCREMENTAL:NO /OPT:REF /SUBSYSTEM:CONSOLE /MACHINE:$(_CPU) /DEBUG $(EXTRA_LDFLAGS)
SHFLAGS  = /nologo /INCREMENTAL:NO /OPT:REF /SUBSYSTEM:WINDOWS /MACHINE:$(_CPU) /DEBUG /DLL $(EXTRA_SHFLAGS)

CLOPTS = /c /nologo /wd4267 /wd4244 $(CRT_CFLAGS) -W3 -O2 -Ob2 -Zi
CFLAGS = $(CFLAGS) -DNDEBUG -DWIN32 -DWINNT -D_WINDOWS -D_WIN32_WINNT=$(WINVER) -DWINVER=$(WINVER)
CFLAGS = $(CFLAGS) -D_CRT_SECURE_NO_DEPRECATE -D_CRT_NONSTDC_NO_DEPRECATE $(EXTRA_CFLAGS)
CFLAGS = $(CFLAGS) -DBINPATH=$(WORKDIR)
LDLIBS = kernel32.lib advapi32.lib ws2_32.lib wsock32.lib ole32.lib shell32.lib rpcrt4.lib $(APR_LIB) $(EXTRA_LIBS)

STDTEST_PORTABLE = \
	$(WORKDIR)\testapp.exe \
	$(WORKDIR)\testall.exe \
	$(WORKDIR)\testlockperf.exe \
	$(WORKDIR)\testmutexscope.exe

OTHER_PROGRAMS = \
	$(WORKDIR)\echod.exe \
	$(WORKDIR)\sendfile.exe \
	$(WORKDIR)\sockperf.exe

TESTALL_COMPONENTS = \
	$(WORKDIR)\mod_test.dll \
	$(WORKDIR)\occhild.exe \
	$(WORKDIR)\readchild.exe \
	$(WORKDIR)\proc_child.exe \
	$(WORKDIR)\tryread.exe \
	$(WORKDIR)\sockchild.exe \
	$(WORKDIR)\testshmproducer.exe \
	$(WORKDIR)\testshmconsumer.exe \
	$(WORKDIR)\globalmutexchild.exe

ALL_TESTS = \
	$(WORKDIR)\testutil.obj \
	$(WORKDIR)\testtime.obj \
	$(WORKDIR)\teststr.obj \
	$(WORKDIR)\testvsn.obj \
	$(WORKDIR)\testipsub.obj \
	$(WORKDIR)\testmmap.obj \
	$(WORKDIR)\testud.obj \
	$(WORKDIR)\testtable.obj \
	$(WORKDIR)\testsleep.obj \
	$(WORKDIR)\testpools.obj \
	$(WORKDIR)\testfmt.obj \
	$(WORKDIR)\testfile.obj \
	$(WORKDIR)\testdir.obj \
	$(WORKDIR)\testfileinfo.obj \
	$(WORKDIR)\testrand.obj \
	$(WORKDIR)\testdso.obj \
	$(WORKDIR)\testoc.obj \
	$(WORKDIR)\testdup.obj \
	$(WORKDIR)\testsockets.obj \
	$(WORKDIR)\testproc.obj \
	$(WORKDIR)\testpoll.obj \
	$(WORKDIR)\testlock.obj \
	$(WORKDIR)\testsockopt.obj \
	$(WORKDIR)\testpipe.obj \
	$(WORKDIR)\testthread.obj \
	$(WORKDIR)\testhash.obj \
	$(WORKDIR)\testargs.obj \
	$(WORKDIR)\testnames.obj \
	$(WORKDIR)\testuser.obj \
	$(WORKDIR)\testpath.obj \
	$(WORKDIR)\testenv.obj \
	$(WORKDIR)\testprocmutex.obj \
	$(WORKDIR)\testfnmatch.obj \
	$(WORKDIR)\testatomic.obj \
	$(WORKDIR)\testflock.obj \
	$(WORKDIR)\testshm.obj \
	$(WORKDIR)\testsock.obj \
	$(WORKDIR)\testglobalmutex.obj \
	$(WORKDIR)\teststrnatcmp.obj \
	$(WORKDIR)\testfilecopy.obj \
	$(WORKDIR)\testtemp.obj \
	$(WORKDIR)\testlfs.obj \
	$(WORKDIR)\testcond.obj \
	$(WORKDIR)\testescape.obj \
	$(WORKDIR)\testskiplist.obj \
	$(WORKDIR)\testencode.obj

PROGRAMS = \
	$(TESTALL_COMPONENTS) \
	$(STDTEST_PORTABLE) \
	$(OTHER_PROGRAMS)

all: $(WORKDIR) $(PROGRAMS)

$(WORKDIR):
	@-md $(WORKDIR)

{$(SRCDIR)}.c{$(WORKDIR)}.obj:
	$(CC) $(CLOPTS) $(INCLUDES) $(CFLAGS) $(PDBFLAGS) $<

# STDTEST_PORTABLE;

$(WORKDIR)\testall.exe: $(ALL_TESTS) $(WORKDIR)\abts.obj
	$(LN) $(LDFLAGS) /out:$@ $** $(LDLIBS)

$(WORKDIR)\testapp.exe: $(WORKDIR)\testapp.obj $(APP_LIB)
	$(LN) $(LDFLAGS) /entry:wmainCRTStartup /out:$@ $** $(LDLIBS)

$(WORKDIR)\testlockperf.exe: $(WORKDIR)\testlockperf.obj
	$(LN) $(LDFLAGS) /out:$@ $** $(LDLIBS)

$(WORKDIR)\testmutexscope.exe: $(WORKDIR)\testmutexscope.obj
	$(LN) $(LDFLAGS) /out:$@ $** $(LDLIBS)

# OTHER_PROGRAMS;

$(WORKDIR)\echod.exe: $(WORKDIR)\echod.obj
	$(LN) $(LDFLAGS) /out:$@ $** $(LDLIBS)

$(WORKDIR)\sendfile.exe: $(WORKDIR)\sendfile.obj
	$(LN) $(LDFLAGS) /out:$@ $** $(LDLIBS)

$(WORKDIR)\sockperf.exe: $(WORKDIR)\sockperf.obj
	$(LN) $(LDFLAGS) /out:$@ $** $(LDLIBS)

# TESTALL_COMPONENTS;

$(WORKDIR)\globalmutexchild.exe: $(WORKDIR)\globalmutexchild.obj
	$(LN) $(LDFLAGS) /out:$@ $** $(LDLIBS)

$(WORKDIR)\mod_test.dll: $(WORKDIR)\mod_test.obj
	$(LN) $(SHFLAGS) /out:$@ $** \
		   /export:print_hello /export:count_reps $(LDLIBS)

$(WORKDIR)\occhild.exe: $(WORKDIR)\occhild.obj
	$(LN) $(LDFLAGS) /out:$@ $** $(LDLIBS)

$(WORKDIR)\proc_child.exe: $(WORKDIR)\proc_child.obj
	$(LN) $(LDFLAGS) /out:$@ $** $(LDLIBS)

$(WORKDIR)\readchild.exe: $(WORKDIR)\readchild.obj
	$(LN) $(LDFLAGS) /out:$@ $** $(LDLIBS)

$(WORKDIR)\sockchild.exe: $(WORKDIR)\sockchild.obj
	$(LN) $(LDFLAGS) /out:$@ $** $(LDLIBS)

$(WORKDIR)\testshmconsumer.exe: $(WORKDIR)\testshmconsumer.obj
	$(LN) $(LDFLAGS) /out:$@ $** $(LDLIBS)

$(WORKDIR)\testshmproducer.exe: $(WORKDIR)\testshmproducer.obj
	$(LN) $(LDFLAGS) /out:$@ $** $(LDLIBS)

$(WORKDIR)\tryread.exe: $(WORKDIR)\tryread.obj
	$(LN) $(LDFLAGS) /out:$@ $** $(LDLIBS)

cleandata:
    @-del /Q data\*.dat >NUL 2>&1
    @-del /Q data\*.shm >NUL 2>&1
	@-rd /S /Q lfstests >NUL 2>&1

clean: cleandata
	@-rd /S /Q $(WORKDIR) >NUL 2>&1

PATH=$(WORKDIR);$(APRDIR)\$(WORKDIR);$(PATH)
check: all
	@for %p in ($(STDTEST_PORTABLE)) do @( \
		echo Testing %p && %p -v || echo %p failed \
	)

