<?xml version="1.0" encoding="ISO-8859-1" ?>
<!DOCTYPE manualpage SYSTEM "./style/manualpage.dtd">
<?xml-stylesheet type="text/xsl" href="./style/manual.fr.xsl"?>
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->
<!-- English Revision: 1562488 -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<manualpage metafile="filter.xml.meta">

  <title>Filtres</title>

  <summary>
    <p>Ce document d&eacute;crit l'utilisation des filtres avec Apache.</p>
  </summary>

  <section id="intro">
    <title>Le filtrage avec Apache 2</title>
    <related>
      <modulelist>
        <module>mod_filter</module>
        <module>mod_deflate</module>
        <module>mod_ext_filter</module>
        <module>mod_include</module>
        <module>mod_charset_lite</module>
	<module>mod_reflector</module>
	<module>mod_buffer</module>
        <module>mod_data</module>
        <module>mod_ratelimit</module>
        <module>mod_reqtimeout</module>
        <module>mod_request</module>
        <module>mod_sed</module>
        <module>mod_substitute</module>
	<module>mod_xml2enc</module>
        <module>mod_proxy_html</module>
      </modulelist>
      <directivelist>
        <directive module="mod_filter">FilterChain</directive>
        <directive module="mod_filter">FilterDeclare</directive>
        <directive module="mod_filter">FilterProtocol</directive>
        <directive module="mod_filter">FilterProvider</directive>
        <directive module="mod_mime">AddInputFilter</directive>
        <directive module="mod_mime">AddOutputFilter</directive>
        <directive module="mod_mime">RemoveInputFilter</directive>
        <directive module="mod_mime">RemoveOutputFilter</directive>
	<directive module="mod_reflector">ReflectorHeader</directive>
        <directive module="mod_ext_filter">ExtFilterDefine</directive>
        <directive module="mod_ext_filter">ExtFilterOptions</directive>
        <directive module="core">SetInputFilter</directive>
        <directive module="core">SetOutputFilter</directive>
      </directivelist>
    </related>

<p>La cha&icirc;ne de filtrage est disponible depuis la version 2.0 d'Apache,
et permet aux applications de traiter les donn&eacute;es en entr&eacute;e et en sortie
d'une mani&egrave;re hautement flexible et configurable, quelle que soit la
provenance de ces donn&eacute;es.  Il est possible de pr&eacute;-traiter les donn&eacute;es
en entr&eacute;e, et post-traiter les donn&eacute;es en sortie, selon
vos souhaits.
Ces traitements sont tout &agrave; fait ind&eacute;pendants des traditionnelles phases
de traitement des requ&ecirc;tes.</p>
<p class="figure">
<img src="images/filter_arch.png" width="569" height="392" alt=
"les filtres peuvent s'encha&icirc;ner, perpendiculairement au traitement
des requ&ecirc;tes"
/>
</p>
<p>Voici quelques exemples de filtrage avec la distribution standard d'Apache:</p>
<ul>
<li><module>mod_include</module>, impl&eacute;mente les inclusions c&ocirc;t&eacute; serveur.</li>
<li><module>mod_ssl</module>, impl&eacute;mente le cryptage SSL (https).</li>
<li><module>mod_deflate</module>, impl&eacute;mente la compression/d&eacute;compression
&agrave; la vol&eacute;e.</li>
<li><module>mod_charset_lite</module>, transcodage entre diff&eacute;rents
jeux de caract&egrave;res.</li>
<li><module>mod_ext_filter</module>, utilisation d'un programme externe
comme filtre.</li>
</ul>
<p>Apache utilise aussi plusieurs filtres en interne pour accomplir des t&acirc;ches
comme le d&eacute;coupage des grosses requ&ecirc;tes (chunking) et la gestion des
requ&ecirc;tes portant sur une partie d'un fichier (byte-range).</p>

<p>Un grand choix d'applications sont impl&eacute;ment&eacute;es par des modules de filtrage
tiers disponibles &agrave; <a
href="http://modules.apache.org/">modules.apache.org</a> entre autres.
En voici quelques exemples :</p>

<ul>
<li>Traitement et r&eacute;&eacute;criture HTML et XML</li>
<li>Transformations XSLT et inclusions XML (XIncludes)</li>
<li>Support de l'espace de nommage XML</li>
<li>Gestion du chargement de fichier et d&eacute;codage des formulaires HTML</li>
<li>Traitement d'image</li>
<li>Protection des applications vuln&eacute;rables comme les scripts PHP</li>
<li>Edition de texte par Chercher/Remplacer</li>
</ul>
</section>

<section id="smart">
<title>Filtrage intelligent</title>
<p class="figure">
<img src="images/mod_filter_new.png" width="423" height="331"
alt="Le filtrage intelligent applique diff&eacute;rents fournisseurs de filtrage en
fonction de l'&eacute;tat du traitement de la requ&ecirc;te"/>
</p>
<p><module>mod_filter</module>, inclus dans les version 2.1 et sup&eacute;rieures
d'Apache, permet de configurer la cha&icirc;ne de filtrage dynamiquement
&agrave; l'ex&eacute;cution.
Ainsi par exemple, vous pouvez d&eacute;finir un proxy pour r&eacute;&eacute;crire du code HTML
avec un filtre HTML et traiter des images JPEG avec un filtre totalement
s&eacute;par&eacute;, bien que le proxy ne poss&egrave;de aucune information pr&eacute;liminaire
sur ce que le serveur &agrave; l'origine des donn&eacute;es &agrave; filtrer va envoyer.
Ceci fonctionne gr&acirc;ce &agrave; l'utilisation d'un gestionnaire de filtre,
qui distribue les t&acirc;ches &agrave; diff&eacute;rents fournisseurs de filtrage en fonction
du contenu r&eacute;el &agrave; filtrer &agrave; l'ex&eacute;cution.  Tout filtre peut se voir soit
ins&eacute;r&eacute; directement dans la cha&icirc;ne et lanc&eacute; inconditionnellement, soit
utilis&eacute; comme un fournisseur de filtrage et ins&eacute;r&eacute; dynamiquement.
Par exemple,</p>
<ul>
<li>un filtre de traitement HTML sera lanc&eacute; uniquement si le contenu est
de type text/html ou application/xhtml+xml</li>
<li>Un filtre de compression sera lanc&eacute; uniquement si les donn&eacute;es en entr&eacute;e
sont de type compressible et non d&eacute;j&agrave; compress&eacute;es</li>
<li>Un filtre de conversion de jeux de caract&egrave;res ne sera ins&eacute;r&eacute; que si
le document texte n'est pas d&eacute;j&agrave; dans le jeu de caract&egrave;res voulu</li>
</ul>
</section>

<section id="service">

<title>Pr&eacute;sentation des filtres en tant que service HTTP</title>
<p>Les filtres permettent de traiter les requ&ecirc;tes des clients avant
traitement par le serveur, ainsi que les contenus issus du serveur avant de les renvoyer
au client. Le module <module>mod_reflector</module> permet aussi
d'utiliser les filtres pour traiter les requ&ecirc;tes des clients avant de
les renvoyer directement &agrave; ces derniers.</p>

<p>Le module <module>mod_reflector</module> re&ccedil;oit les requ&ecirc;tes POST des
clients, et en r&eacute;percute le corps dans la requ&ecirc;te POST constituant la
r&eacute;ponse, lors de l'envoi de cette derni&egrave;re au client en passant &agrave; travers la
pile de filtres en sortie.</p>

<p>Cette technique peut &ecirc;tre utilis&eacute;e comme alternative &agrave; un service web
s'ex&eacute;cutant &agrave; l'int&eacute;rieur de la pile d'un serveur d'applications, o&ugrave; un
filtre en sortie effectue la transformation requise sur le corps de la
requ&ecirc;te. Par exemple, on peut utiliser le module
<module>mod_deflate</module> pour fournir un service g&eacute;n&eacute;ral de
compression ; un filtre de transformation d'images peut aussi se voir
mu&eacute; en service de transformation d'images.</p>

</section>


<section id="using">
<title>Utilisation des filtres</title>
<p>Il y a deux mani&egrave;res d'utiliser le filtrage : Simple et Dynamique.
En g&eacute;n&eacute;ral, vous utiliserez l'une ou l'autre m&eacute;thode; le m&eacute;lange des deux
peut avoir des cons&eacute;quences inattendues (bien que le filtrage simple en entr&eacute;e
puisse &ecirc;tre associ&eacute; sans probl&egrave;me avec le filtrage simple ou dynamique
en sortie).</p>
<p>La m&eacute;thode Simple est la seule permettant de configurer les filtres
en entr&eacute;e, et suffit pour les filtres en sortie pour lesquels vous avez besoin
d'une cha&icirc;ne de filtres statique.
Les directives correspondantes sont
    <directive module="core">SetInputFilter</directive>,
    <directive module="core">SetOutputFilter</directive>,
    <directive module="mod_mime">AddInputFilter</directive>,
    <directive module="mod_mime">AddOutputFilter</directive>,
    <directive module="mod_mime">RemoveInputFilter</directive>, et
    <directive module="mod_mime">RemoveOutputFilter</directive>.</p>

<p>La m&eacute;thode Dynamique permet une configuration dynamique des filtres en
sortie &agrave; la fois statique et flexible, comme discut&eacute; dans la page
<module>mod_filter</module>.
Les directives correspondantes sont
    <directive module="mod_filter">FilterChain</directive>,
    <directive module="mod_filter">FilterDeclare</directive>, et
    <directive module="mod_filter">FilterProvider</directive>.</p>

<p>Une autre directive <directive
module="mod_filter">AddOutputFilterByType</directive> est encore support&eacute;e,
mais obsol&egrave;te. Utilisez la
configuration dynamique &agrave; la place.</p>

  </section>
</manualpage>
