<?xml version="1.0"?>
<!DOCTYPE modulesynopsis SYSTEM "../style/modulesynopsis.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision: 1673563 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<modulesynopsis metafile="mod_charset_lite.xml.meta">

<name>mod_charset_lite</name>
<description>Sp&eacute;cifie dans quel jeu de caract&egrave;re doivent s'effectuer les
traductions ou les r&eacute;encodages</description>
<status>Extension</status>
<sourcefile>mod_charset_lite.c</sourcefile>
<identifier>charset_lite_module</identifier>

<summary>
    <p>Le module <module>mod_charset_lite</module> permet au serveur de
    modifier le jeu de caract&egrave;res des r&eacute;ponses avant de les envoyer aux
    clients. Dans un environnement EBCDIC, Apache traduit toujours les
    contenus au protocole HTTP (par exemples les en-t&ecirc;tes de r&eacute;ponses)
    de la page de code de la locale du processus Apache vers ISO-8859-1,
    mais pas le corps des r&eacute;ponses. Dans tous les environnements, on
    peut utiliser <module>mod_charset_lite</module> pour sp&eacute;cifier que
    les corps des r&eacute;ponses doivent &ecirc;tre traduits. Par exemple, si les
    fichiers sont stock&eacute;s sous forme EBCDIC,
    <module>mod_charset_lite</module> pourra les traduire en ISO-8859-1
    avant de les envoyer au client.</p>

    <p>Ce module fournit quelques proc&eacute;d&eacute;s de configuration impl&eacute;ment&eacute;s
    par Apache version russe, ainsi que son module
    <code>mod_charset</code> associ&eacute;.</p>
</summary>

<section id="problems"><title>Probl&egrave;mes courants</title>

    <section><title>Noms de jeux de caract&egrave;res non valides</title>

      <p>Les noms des jeux de caract&egrave;res pass&eacute;s en param&egrave;tres aux
      directives  <directive
      module="mod_charset_lite">CharsetSourceEnc</directive> et
      <directive module="mod_charset_lite">CharsetDefault</directive>
      doivent &ecirc;tre reconnus par le m&eacute;canisme de traduction utilis&eacute; par
      <glossary>APR</glossary> sur le syst&egrave;me o&ugrave;
      <module>mod_charset_lite</module> est utilis&eacute;. Ces noms de jeux de
      caract&egrave;res ne sont pas standardis&eacute;s, et sont en g&eacute;n&eacute;ral diff&eacute;rents
      des valeurs qui leur correspondent dans les en-t&ecirc;tes HTTP.
      Actuellement, APR ne peut utiliser que iconv(3) ; vous pouvez donc
      tester facilement vos noms de jeux de caract&egrave;res en utilisant le
      programme iconv(1), de la mani&egrave;re suivante :</p>

      <example>
        iconv -f valeur-charsetsourceenc -t valeur-charsetdefault
      </example>
    </section>

    <section><title>Incompatibilit&eacute; entre le jeu de caract&egrave;res du
    contenu et les r&egrave;gles de traduction</title>

      <p>Si les r&egrave;gles de traduction ne peuvent s'appliquer au contenu,
      la traduction peut &eacute;chouer avec des cons&eacute;quences diverses, comme
      :</p>

      <ul>
      <li>Le m&eacute;canisme de traduction peut renvoyer un mauvais code de
      retour, et la connexion sera interrompue.</li>

      <li>Le m&eacute;canisme de traduction peut ins&eacute;rer silencieusement des
      caract&egrave;res sp&eacute;ciaux (par exemple des points d'interrogation) dans
      le tampon de sortie lorsqu'il n'est pas en mesure de traduire le
      tampon d'entr&eacute;e.</li>
      </ul>
    </section>
</section>

<directivesynopsis>
<name>CharsetSourceEnc</name>
<description>Jeu de caract&egrave;res source des fichiers</description>
<syntax>CharsetSourceEnc <var>jeu de caract&egrave;res</var></syntax>
<contextlist><context>server config</context>
<context>virtual host</context><context>directory</context>
<context>.htaccess</context>
</contextlist>
<override>FileInfo</override>

<usage>
    <p>La directive <directive>CharsetSourceEnc</directive> permet de
    sp&eacute;cifier un jeu de caract&egrave;res source pour les fichiers situ&eacute;s dans
    le conteneur associ&eacute;.</p>

    <p>La valeur de l'argument <var>jeu de caract&egrave;res</var> doit &ecirc;tre
    un nom de jeu de caract&egrave;res valide du point de vue du support des
    jeux de caract&egrave;res dans <glossary>APR</glossary>. En g&eacute;n&eacute;ral, cela
    implique qu'elle doit &ecirc;tre reconnue par iconv.</p>

    <example><title>Exemple</title>
      <highlight language="config">
&lt;Directory "/export/home/trawick/apacheinst/htdocs/convert"&gt;
    CharsetSourceEnc  UTF-16BE
    CharsetDefault    ISO-8859-1
&lt;/Directory&gt;
      </highlight>
    </example>

    <p>Les noms de jeux de caract&egrave;res de cet exemple sont reconnus par
    le m&eacute;canisme de traduction d'iconv sous Solaris 8.</p>

    <note>
     Sp&eacute;cifier le m&ecirc;me jeu de caract&egrave;res pour les deux directives
     <directive module="mod_charset_lite">CharsetSourceEnc</directive>
     et <directive module="mod_charset_lite">CharsetDefault</directive>
     d&eacute;sactive la traduction. Le jeu de caract&egrave;res ne doit pas forc&eacute;ment
     correspondre au jeu de caract&egrave;res de la r&eacute;ponse, mais il doit &ecirc;tre
     valide du point de vue du syst&egrave;me.
     </note>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>CharsetDefault</name>
<description>Jeu de caract&egrave;re vers lequel la traduction doit
s'effectuer</description>
<syntax>CharsetDefault <var>jeu de caract&egrave;res</var></syntax>
<contextlist><context>server config</context>
<context>virtual host</context><context>directory</context>
<context>.htaccess</context>
</contextlist>
<override>FileInfo</override>

<usage>
    <p>La directive <directive>CharsetDefault</directive> permet de
    sp&eacute;cifier le jeu de caract&egrave;res vers lequel le contenu situ&eacute; dans le
    conteneur associ&eacute; devra &ecirc;tre traduit.</p>

    <p>La valeur de l'argument <var>jeu de caract&egrave;res</var> doit &ecirc;tre
    un nom de jeu de caract&egrave;res valide du point de vue du support des
    jeux de caract&egrave;res dans <glossary>APR</glossary>. En g&eacute;n&eacute;ral, cela
    implique qu'elle doit &ecirc;tre reconnue par iconv.</p>

    <example><title>Exemple</title>
      <highlight language="config">
&lt;Directory "/export/home/trawick/apacheinst/htdocs/convert"&gt;
    CharsetSourceEnc  UTF-16BE
    CharsetDefault    ISO-8859-1
&lt;/Directory&gt;
      </highlight>
    </example>

    <note>
     Sp&eacute;cifier le m&ecirc;me jeu de caract&egrave;res pour les deux directives
     <directive module="mod_charset_lite">CharsetSourceEnc</directive>
     et <directive module="mod_charset_lite">CharsetDefault</directive>
     d&eacute;sactive la traduction. Le jeu de caract&egrave;res ne doit pas forc&eacute;ment
     correspondre au jeu de caract&egrave;res de la r&eacute;ponse, mais il doit &ecirc;tre
     valide du point de vue du syst&egrave;me.
     </note>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>CharsetOptions</name>
<description>Pr&eacute;cise les d&eacute;tails de la traduction du jeu de
caract&egrave;res</description>
<syntax>CharsetOptions <var>option</var> [<var>option</var>] ...</syntax>
<default>CharsetOptions ImplicitAdd</default>
<contextlist><context>server config</context>
<context>virtual host</context><context>directory</context>
<context>.htaccess</context>
</contextlist>
<override>FileInfo</override>

<usage>
    <p>La directive <directive>CharsetOptions</directive> permet de
    pr&eacute;ciser certains d&eacute;tails du comportement du module
    <module>mod_charset_lite</module>. <var>Option</var> accepte les
    valeurs suivantes :</p>

    <dl>
      <dt><code>ImplicitAdd | NoImplicitAdd</code></dt>

      <dd>Le mot-cl&eacute; <code>ImplicitAdd</code> indique que
      <module>mod_charset_lite</module> doit ins&eacute;rer son filtre de
      mani&egrave;re implicite lorsque la configuration indique que le jeu de
      caract&egrave;re du contenu doit &ecirc;tre traduit. Si la cha&icirc;ne de filtrage
      est configur&eacute;e de mani&egrave;re explicite via la directive <directive
      module="mod_mime">AddOutputFilter</directive>, l'option
      <code>NoImplicitAdd</code> doit &ecirc;tre utilis&eacute;e afin que
      <module>mod_charset_lite</module> n'ajoute pas son propre
      filtre.</dd>

      <dt><code>TranslateAllMimeTypes | NoTranslateAllMimeTypes</code></dt>
      <dd>Normalement, <module>mod_charset_lite</module> n'effectuera
      une traduction qu'en pr&eacute;sence d'un petit nombre de types MIME
      parmi tous les types possibles. Lorsque l'option
      <code>TranslateAllMimeTypes</code> est utilis&eacute;e pour une section
      de configuration donn&eacute;e, la traduction est effectu&eacute;e sans se
      pr&eacute;occuper du type MIME.</dd>

    </dl>
</usage>
</directivesynopsis>

</modulesynopsis>
