<?xml version="1.0" encoding="UTF-8" ?>
<!DOCTYPE modulesynopsis SYSTEM "../style/modulesynopsis.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision: 1737464 -->
<!-- French translation: Fabien Coelho -->
<!-- Updated by Lucien Gentis -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<modulesynopsis metafile="mod_macro.xml.meta">

<name>mod_macro</name>
<description>Ce module permet d'utiliser des macros dans les fichiers
de configuration Apache.</description>
<status>Base</status>
<sourcefile>mod_macro.c</sourcefile>
<identifier>macro_module</identifier>

<summary>

    <p>Ce module permet d'utiliser des macros dans les fichiers de
    configuration à l'exécution du serveur HTTP Apache afin de faciliter
    la création de nombreux blocs de configuration similaires. Quand le
    serveur démarre, les macros sont exécutées avec les paramètres
    fournis, et le résultat obtenu est traité au même titre que le reste
    du fichier de configuration.</p>

</summary>

<section id="usage"><title>Utilisation</title>    
<p>On définit une macro à l'aide des blocs <directive module="mod_macro"
type="section">Macro</directive> qui contiennent la portion de votre
configuration qui intervient de manière répétitive, y compris les
variables pour les parties qui devront être substituées.</p>

<p>Par exemple, vous pouvez utiliser une macro pour définir un bloc
<directive module="core" type="section">VirtualHost</directive>, afin de pouvoir
définir de nombreux serveurs virtuels similaires :</p>    

    <highlight language="config">
&lt;Macro VHost $name $domain&gt;
&lt;VirtualHost *:80&gt;
    ServerName $domain
    ServerAlias www.$domain

    DocumentRoot "/var/www/vhosts/$name"
    ErrorLog "/var/log/httpd/$name.error_log"
    CustomLog "/var/log/httpd/$name.access_log" combined
&lt;/VirtualHost&gt;
&lt;/Macro&gt;
</highlight>

<p>Comme les directives de configuration httpd, les noms des macros sont
insensibles à la casse, à la différence des variables qui y sont, elles,
sensibles.</p>

<p>Vous pouvez alors invoquer cette macro autant de fois que vous le
voulez pour créer des serveurs virtuels </p>

<highlight language="config">
Use VHost example example.com
Use VHost myhost hostname.org
Use VHost apache apache.org

UndefMacro VHost
    </highlight>

<p>Au démarrage du serveur, chacune de ces invocations
<directive module="mod_macro">Use</directive> sera remplacée par une définition de serveur
virtuel complète, comme décrit dans la définition de la
<directive module="mod_macro" type="section">Macro</directive>.</p>

<p>La directive <directive module="mod_macro">UndefMacro</directive> permet d'éviter les
conflits de définitions qui pourraient provenir de l'utilisation
ultérieure de macros contenant les mêmes noms de variables.</p>

<p>Vous trouverez une version plus élaborée de cet exemple plus loin
dans la section Exemples.</p>

</section>

<section id="tips"><title>Conseils</title>

<p>Les noms de paramètres doivent commencer par un sigil tel que
<code>$</code>, <code>%</code>, ou <code>@</code>, de façon à ce qu'ils
soient clairement identifiables, mais aussi afin de faciliter les
interactions avec les autres directives, comme la directive de base
<directive module="core">Define</directive>. Dans le cas contraire, vous
recevrez un avertissement. En tout état de cause, il est conseillé
d'avoir une bonne connaissance globale de la configuration du serveur,
afin d'éviter la réutilisation des mêmes variables à différents niveaux,
ce qui peut être à l'origine de confusions.</p>

<p>Les paramètres préfixés par <code>$</code> ou <code>%</code> ne sont
pas échappés. Les paramètres préfixés par <code>@</code> sont échappés
entre guillemets.</p>

<p>Evitez de préfixer un paramètre par le nom d'un autre paramètre (par
exemple, présence simultanée des paramètres <code>$win</code> et
<code>$winter</code>), car ceci peut introduire de la confusion lors de
l'évaluation des expressions. Si cela se produit, c'est le nom de
paramètre le plus long possible qui sera utilisé.</p>

<p>Si vous désirez insérer une valeur dans une chaîne, il est conseillé
de l'entourer d'accolades afin d'éviter toute confusion :</p>

<highlight language="config">
&lt;Macro DocRoot ${docroot}&gt;
    DocumentRoot "/var/www/${docroot}/htdocs"
&lt;/Macro&gt;
</highlight>

</section>

<section id="examples">
<title>Exemples</title>

<section>
<title>Définition de serveurs virtuels</title>

<p>Un exemple typique d'utilisation de <module>mod_macro</module> est la
création dynamique de serveurs virtuels.</p>

<highlight language="config">
## Définition d'une macro VHost pour les configurations répétitives

&lt;Macro VHost $host $port $dir&gt;
  Listen $port
  &lt;VirtualHost *:$port&gt;

    ServerName $host
    DocumentRoot "$dir"

    # Racine des documents publique
    &lt;Directory "$dir"&gt;
      Require all granted
    &lt;/Directory&gt;

    # restriction d'accès au sous-répertoire intranet.
    &lt;Directory "$dir/intranet"&gt;
      Require ip 10.0.0.0/8
    &lt;/Directory&gt;
  &lt;/VirtualHost&gt;
&lt;/Macro&gt;

## Utilisation de la macro VHost avec différents arguments.

Use VHost www.apache.org 80 /vhosts/apache/htdocs
Use VHost example.org 8080 /vhosts/example/htdocs
Use VHost www.example.fr 1234 /vhosts/example.fr/htdocs
</highlight>
</section> <!-- Vhosts -->

<section>
<title>Suppression d'une définition de macro</title>

<p>Il est recommandé de supprimer la définition d'une macro après
l'avoir utilisée. Ceci permet d'éviter les confusions au sein d'un
fichier de configuration complexe où des conflits entre noms de
variables peuvent survenir.</p>

<highlight language="config">
&lt;Macro DirGroup $dir $group&gt;
  &lt;Directory "$dir"&gt;
    Require group $group
  &lt;/Directory&gt;
&lt;/Macro&gt;

Use DirGroup /www/apache/private private
Use DirGroup /www/apache/server  admin

UndefMacro DirGroup
</highlight>

</section> <!-- UndefMacro -->

</section> <!-- Example -->

<!-- Macro -->
<directivesynopsis type="section">
<name>Macro</name>
<description>Définition d'une macro dans un fichier de configuration</description>
<syntax>
&lt;Macro <var>nom</var> [<var>par1</var> .. <var>parN</var>]&gt;
... &lt;/Macro&gt;</syntax>
<contextlist>
<context>server config</context>
<context>virtual host</context>
<context>directory</context>
</contextlist>

<usage>
    <p>La directive <directive type="section">Macro</directive> permet de définir une macro
    dans un fichier de configuration Apache. Le premier argument est le nom
    de la macro, et les arguments suivants sont les paramètres. Il
    est de bon aloi de préfixer les noms des paramètres d'une macro
    avec un caractère parmi '<code>$%@</code>', et d'éviter d'en faire
    de même avec les noms de macros.
    </p>

    <highlight language="config">
&lt;Macro LocalAccessPolicy&gt;
  Require ip 10.2.16.0/24
&lt;/Macro&gt;

&lt;Macro RestrictedAccessPolicy $ipnumbers&gt;
   Require ip $ipnumbers
&lt;/Macro&gt;
    </highlight>
</usage>
</directivesynopsis>

<!-- Use -->
<directivesynopsis>
<name>Use</name>
<description>Utilisation d'une macro</description>
<syntax>Use <var>nom</var> [<var>valeur1</var> ... <var>valeurN</var>]
</syntax>
<contextlist>
<context>server config</context>
<context>virtual host</context>
<context>directory</context>
</contextlist>

<usage>
    <p> La directive <directive>Use</directive> permet d'utiliser une macro.
    La macro considérée est expansée. Son nombre d'arguments doit être égal au
    nombre de paramètres précisés dans sa définition. Les valeurs passées en
    argument sont attribuées aux paramètres correspondants et
    substituées avant l'interprétation du texte de la macro.</p>

    <highlight language="config">
Use LocalAccessPolicy
...
Use RestrictedAccessPolicy "192.54.172.0/24 192.54.148.0/24"
    </highlight>

    <p>est équivalent, avec les macros définies ci-dessus à :</p>

    <highlight language="config">
Require ip 10.2.16.0/24
...
Require ip 192.54.172.0/24 192.54.148.0/24
    </highlight>
</usage>
</directivesynopsis>

<!-- UndefMacro -->
<directivesynopsis>
<name>undefMacro</name>
<description>Supprime une macro</description>

<syntax>UndefMacro <var>nom</var></syntax>
<contextlist>
<context>server config</context>
<context>virtual host</context>
<context>directory</context>
</contextlist>

<usage>
    <p>La directive <directive>UndefMacro</directive> annule la définition
    d'une macro qui doit avoir été définie auparavant.</p>

    <highlight language="config">
UndefMacro LocalAccessPolicy
UndefMacro RestrictedAccessPolicy
    </highlight>
</usage>
</directivesynopsis>

</modulesynopsis>
