<?xml version="1.0" encoding="ISO-8859-1" ?>
<!DOCTYPE manualpage SYSTEM "../style/manualpage.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision : 1420732 -->
<!-- French translation : Lucien GENTIS -->
<!-- $LastChangedRevision: 2013010501 $ -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<manualpage metafile="dbmmanage.xml.meta">
<parentdocument href="./">Programmes</parentdocument>

<title>dbmmanage - Gestion des fichiers d'authentification des
utilisateurs au format DBM</title>

<summary>
    <p><code>dbmmanage</code> permet de cr&eacute;er et de maintenir les
    fichiers au format DBM o&ugrave; sont stock&eacute;s les noms d'utilisateurs et
    mots de passe &agrave; des fins d'authentification de base des utilisateurs
    HTTP via le module <module>mod_authn_dbm</module>. Il est possible
    de restreindre l'acc&egrave;s aux ressources disponibles sur le serveur
    HTTP Apache aux seuls utilisateurs sp&eacute;cifi&eacute;s dans les fichiers cr&eacute;&eacute;s
    par <code>dbmmanage</code>. Ce programme ne peut &ecirc;tre utilis&eacute;
    qu'avec des fichiers d'utilisateurs au format DBM. Pour
    l'utilisation de fichiers textes, voir le programme
    <program>htpasswd</program>.</p>

    <p>Le programme <program>htdbm</program> est aussi un utilitaire
    permettant de maintenir une base de donn&eacute;es de mots de passe DBM.</p>

    <p>Cette page de manuel ne d&eacute;crit que les arguments de la ligne de
    commande. Pour plus de d&eacute;tails &agrave; propos des directives n&eacute;cessaires
    pour configurer l'authentification des utilisateurs dans
    <program>httpd</program>, voir le manuel httpd qui est fourni avec
    la distribution d'Apache, ou peut &ecirc;tre consult&eacute; &agrave; <a
    href="http://httpd.apache.org/">http://httpd.apache.org/</a>.</p>
</summary>
<seealso><program>httpd</program></seealso>
<seealso><program>htdbm</program></seealso>
<seealso><module>mod_authn_dbm</module></seealso>
<seealso><module>mod_authz_dbm</module></seealso>

<section id="synopsis"><title>Syntaxe</title>
    <p><code><strong>dbmmanage</strong> [ <var>codage</var> ]
    <var>nom-fichier</var> add|adduser|check|delete|update
    <var>nom-utilisateur</var>
    [ <var>mot-de-passe-chiffr&eacute;</var>
      [ <var>groupe</var>[,<var>groupe</var>...]
        [ <var>commentaire</var> ] ] ]</code></p>

    <p><code><strong>dbmmanage</strong> <var>nom-fichier</var>
    view [ <var>nom-utilisateur</var> ]</code></p>

    <p><code><strong>dbmmanage</strong> <var>nom-fichier</var>import</code></p>
</section>

<section id="options"><title>Options</title>
    <dl>
    <dt><code><var>nom-fichier</var></code></dt>
    <dd>Le nom du fichier au format DBM, en g&eacute;n&eacute;ral sans l'extension
    <code>.db</code>, <code>.pag</code>, ou <code>.dir</code>.</dd>

    <dt><code><var>nom-utilisateur</var></code></dt>
    <dd>L'utilisateur concern&eacute; par l'op&eacute;ration effectu&eacute;e. Le
    <var>nom-utilisateur</var> ne doit pas contenir de caract&egrave;re
    <code>:</code>.</dd>

    <dt><code><var>mot-de-passe-chiffr&eacute;</var></code></dt>
    <dd>C'est le mot de passe sous sa forme chiffr&eacute;e &agrave; utiliser avec les
    commandes <code>update</code> et <code>add</code>. Vous pouvez
    utiliser un tiret (<code>-</code>) si vous voulez que le mot de
    passe vous soit demand&eacute;, mais remplissez les champs par la suite. En
    outre, avec la commande <code>update</code>, un point
    (<code>.</code>) permet de conserver le mot de passe original.</dd>

    <dt><code><var>groupe</var></code></dt>
    <dd>Un groupe dont l'utilisateur est membre. Un nom de groupe ne
    doit pas contenir de caract&egrave;re (<code>:</code>). Vous pouvez
    utiliser un tiret (<code>-</code>) si vous ne voulez pas associer
    l'utilisateur &agrave; un groupe, mais remplissez le champ commentaire. En
    outre, avec la commande <code>update</code>, un point
    (<code>.</code>) permet de conserver le groupe original.</dd>

    <dt><code><var>commentaire</var></code></dt>
    <dd>C'est l'endroit o&ugrave; vous pouvez enregistrer diverses informations
    &agrave; propos de l'utilisateur telles que son nom r&eacute;el, sont e-mail,
    etc... Le serveur ignore ce champ.</dd>
    </dl>

    <section id="options.encodings"><title>Codages</title>
      <dl>
      <dt><code>-d</code></dt>
      <dd>chiffrement crypt (chiffrement par d&eacute;faut sauf sous Win32,
      Netware)</dd>

      <dt><code>-m</code></dt>
      <dd>chiffrement MD5 (chiffrement par d&eacute;faut sous Win32,
      Netware)</dd>

      <dt><code>-s</code></dt>
      <dd>chiffrement SHA1</dd>

      <dt><code>-p</code></dt>
      <dd>en clair (<em>d&eacute;conseill&eacute;</em>)</dd>
      </dl>
    </section>

    <section id="options.commands"><title>Commandes</title>
      <dl>
      <dt><code>add</code></dt>
      <dd>Ajoute une entr&eacute;e pour <var>nom-utilisateur</var> &agrave;
      <var>nom-fichier</var> en utilisant le mot de passe chiffr&eacute;
      <var>mot-de-passe-chiffr&eacute;</var>.

      <example>dbmmanage passwords.dat add rbowen foKntnEF3KSXA</example>
      </dd>

      <dt><code>adduser</code></dt>
      <dd>Demande un mot de passe puis ajoute une entr&eacute;e pour
      <var>nom-utilisateur</var> &agrave; <var>nom-fichier</var>.

      <example>dbmmanage passwords.dat adduser krietz</example>
      </dd>

      <dt><code>check</code></dt>
      <dd>Demande un mot de passe puis v&eacute;rifie si
      <var>nom-utilisateur</var> est pr&eacute;sent dans <var>nom-fichier</var>
      et si son mot de passe correspond au mot de passe fourni.

      <example>dbmmanage passwords.dat check rbowen</example>
      </dd>

      <dt><code>delete</code></dt>
      <dd>Supprime l'entr&eacute;e <var>nom-utilisateur</var> de
      <var>nom-fichier</var>.

      <example>dbmmanage passwords.dat delete rbowen</example>
      </dd>

      <dt><code>import</code></dt>
      <dd>Lit les entr&eacute;es
      <code><var>nom-utilisateur</var>:<var>mot-de-passe</var></code>
      (une par ligne) depuis <code>STDIN</code>, et les ajoute &agrave;
      <var>nom-fichier</var>. Les mots de passe doivent &ecirc;tre d&eacute;j&agrave;
      chiffr&eacute;s.</dd>

      <dt><code>update</code></dt>
      <dd>Identique &agrave; la commande <code>adduser</code>, &agrave; l'exception
      que la pr&eacute;sence de <var>nom-utilisateur</var> dans
      <var>nom-fichier</var> est v&eacute;rifi&eacute;e.

      <example>dbmmanage passwords.dat update rbowen</example>
      </dd>

      <dt><code>view</code></dt>
      <dd>Affiche le contenu du fichier DBM. Si vous sp&eacute;cifiez un
      <var>nom-utilisateur</var>, seule l'entr&eacute;e correspondante est
      affich&eacute;e.

      <example>dbmmanage passwords.dat view</example>
      </dd>
      </dl>
    </section>
</section>

<section id="bugs"><title>Bogues</title>
    <p>Vous devez garder &agrave; l'esprit qu'il existe de nombreux formats de
    fichiers DBM diff&eacute;rents, et que selon toute vraisemblance, des
    biblioth&egrave;ques pour plus d'un format sont pr&eacute;sentes sur votre
    syst&egrave;me. Les trois exemples de base sont SDBM, NDBM, le projet GNU
    GDBM, et Berkeley DB 2. Malheureusement, toutes ces biblioth&egrave;ques
    utilisent des formats de fichiers diff&eacute;rents, et vous devez vous
    assurer que le format de fichier utilis&eacute; par <var>nom-fichier</var>
    correspond au format attendu par <code>dbmmanage</code>.
    Actuellement, <code>dbmmanage</code> n'a aucun moyen de savoir &agrave;
    quel type de fichier DBM il a &agrave; faire. S'il est utilis&eacute; avec un
    format inappropri&eacute;, il ne renverra rien, ou pourra cr&eacute;er un fichier
    DBM diff&eacute;rent avec un nom diff&eacute;rent, ou au pire, va corrompre le
    fichier DBM si vous avez tent&eacute; de le modifier.</p>

    <p><code>dbmmanage</code> poss&egrave;de une liste de pr&eacute;f&eacute;rences en
    mati&egrave;re de formats DBM, d&eacute;finies dans le tableau
    <code>@AnyDBM::ISA</code> au d&eacute;but du programme. Comme nous
    pr&eacute;f&eacute;rons le format de fichier Berkeley DB 2, l'ordre dans lequel
    <code>dbmmanage</code> va rechercher les biblioth&egrave;ques syst&egrave;me est
    Berkeley DB 2, puis NDBM, GDBM et enfin SDBM. La premi&egrave;re
    biblioth&egrave;que trouv&eacute;e sera celle que <code>dbmmanage</code> tentera
    d'utiliser pour toutes les op&eacute;rations sur les fichiers DBM. Cette
    ordre est sensiblement diff&eacute;rent de l'ordre standard de Perl
    <code>@AnyDBM::ISA</code>, et de l'ordre utilis&eacute; par l'appel
    <code>dbmopen()</code> de Perl ; si vous utilisez un autre
    utilitaire pour g&eacute;rer vos fichiers DBM, il doit donc se conformer &agrave;
    l'ordre de pr&eacute;f&eacute;rence indiqu&eacute; pr&eacute;c&eacute;demment. Vous devez pr&ecirc;ter la
    m&ecirc;me attention si vous utilisez des programmes &eacute;crits dans d'autres
    langages, comme C, pour acc&eacute;der &agrave; ces fichiers.</p>

    <p>Vous pouvez utiliser le programme <code>file</code> fourni par la
    plupart des syst&egrave;mes Unix pour d&eacute;terminer le format d'un fichier
    DBM.</p>
</section>

</manualpage>
