<?xml version="1.0" encoding="UTF-8" ?>
<!DOCTYPE modulesynopsis SYSTEM "../style/modulesynopsis.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision: 1744186 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<modulesynopsis metafile="mod_authn_dbm.xml.meta">

<name>mod_authn_dbm</name>
<description>Authentification utilisateur utilisant des fichiers
DBM</description>
<status>Extension</status>
<sourcefile>mod_authn_dbm.c</sourcefile>
<identifier>authn_dbm_module</identifier>
<compatibility>Disponible depuis les versions 2.1 et supérieures
d'Apache</compatibility>

<summary>
    <p>Ce module permet aux frontaux comme
    <module>mod_auth_digest</module> et <module>mod_auth_basic</module>
    d'authentifier les utilisateurs en les recherchant dans des fichiers
    de mots de passe <dfn>dbm</dfn>. <module>mod_authn_file</module>
    fournit une fonctionnalité similaire.</p>

    <p>Lorsqu'on utilise <module>mod_auth_basic</module> ou
    <module>mod_auth_digest</module>, ce module est invoqué en affectant
    la valeur <code>dbm</code> à la directive <directive
    module="mod_auth_basic">AuthBasicProvider</directive> ou <directive
    module="mod_auth_digest">AuthDigestProvider</directive>.</p>
</summary>

<seealso><directive module="mod_authn_core">AuthName</directive></seealso>
<seealso><directive module="mod_authn_core">AuthType</directive></seealso>
<seealso>
  <directive module="mod_auth_basic">AuthBasicProvider</directive>
</seealso>
<seealso>
  <directive module="mod_auth_digest">AuthDigestProvider</directive>
</seealso>
<seealso><program>htpasswd</program></seealso>
<seealso><program>htdbm</program></seealso>
<seealso><a href="../misc/password_encryptions.html">Formats de mots de
passe</a></seealso>

<directivesynopsis>
<name>AuthDBMUserFile</name>
<description>Définit le nom d'un fichier de base de données pour
l'authentification contenant la liste
des utilisateurs et de leurs mots de passe</description>
<syntax>AuthDBMUserFile <var>chemin-fichier</var></syntax>
<contextlist><context>directory</context><context>.htaccess</context>
</contextlist>
<override>AuthConfig</override>

<usage>
    <p>La directive <directive>AuthDBMUserFile</directive> permet de
    définir le nom d'un fichier de base de données pour
    l'authentification contenant la liste des utilisateurs et de leurs
    mots de passe. <var>chemin-fichier</var> doit être un chemin absolu
    vers le fichier de base de données.</p>

    <p>La clé du fichier de base de données est le nom de l'utilisateur.
    La valeur associée est le mot de passe chiffré, éventuellement suivi
    par un ':' et des données arbitraires. Ce ':' ainsi que les données
    arbitraires qui suivent seront ignorées par le serveur.</p>

    <note type="warning"><title>Sécurité :</title>
      <p>Faites en sorte que le fichier spécifié par la directive
      <directive>AuthDBMUserFile</directive> soit stocké en dehors de
      l'arborescence des documents du serveur web ; en particulier, ne
      l'enregistrez <em>pas</em> dans le répertoire qu'il protège, faute
      de quoi, les clients auraient la possibilité de
      télécharger le fichier des mots de passe.</p>
    </note>

    <p>Le format de mot de passe chiffré dépend du frontal
    d'authentification utilisé (par exemple
    <module>mod_auth_basic</module> ou
    <module>mod_auth_digest</module>). Voir la documentation sur les <a
    href="../misc/password_encryptions.html">Formats de mots de
    passe</a> pour plus de détails.</p>

    <p>Note importante concernant la compatibilité : l'implémentation de
    <code>dbmopen</code> dans les modules d'Apache lit la longueur de la
    chaîne correspondant aux données chiffrées dans la structure des
    données DBM, plutôt que de calculer cette longueur en se basant sur
    le caractère nul final. Certaines applications par contre, comme le
    serveur web Netscape, calculent cette longueur en se basant sur
    le caractère nul final ; par conséquent, si vous rencontrez des
    difficultés en échangeant des fichiers DBM entre plusieurs
    applications, le problème peut éventuellement s'expliquer par cette
    différence d'implémentation.</p>

    <p>Un script perl nommé <program>dbmmanage</program> est fourni avec
    Apache. On peut utiliser ce programme pour créer et mettre à jour
    les fichiers de mots de passe au format DBM que ce module
    utilise. Il existe également un autre outil pour gérer les fichiers DBM,
    inclus dans le programme <program>htdbm</program>.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>AuthDBMType</name>
<description>Définit le type de fichier de base de données utilisé pour
stocker les mots de passe</description>
<syntax>AuthDBMType default|SDBM|GDBM|NDBM|DB</syntax>
<default>AuthDBMType default</default>
<contextlist><context>directory</context><context>.htaccess</context>
</contextlist>
<override>AuthConfig</override>

<usage>
    <p>Cette directive permet de définir le type de fichier de base de
    données utilisé pour stocker les mots de passe. Le type de base de
    données par défaut est défini à la compilation. La liste des autres
    types de bases de données disponibles dépend aussi de la <a
    href="../programs/configure.html#options">configuration de la
    compilation</a>.</p>

    <p>Par exemple, pour activer le support de Berkeley DB (correspondant au
    type <code>db</code>), il faut ajouter l'option
    <code>--with-berkeley-db</code> à la ligne de commande configure de httpd
    pour générer le DSO approprié.</p>

    <p>Il est impératif que le programme que vous utilisez pour créer
    vos fichiers de mots de passe soit configuré pour utiliser le même
    type de base de données.</p>
</usage>
</directivesynopsis>

</modulesynopsis>
