<?xml version="1.0"?>
<!DOCTYPE modulesynopsis SYSTEM "../style/modulesynopsis.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision: 1673563 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<modulesynopsis metafile="mod_ext_filter.xml.meta">

<name>mod_ext_filter</name>
<description>Fait traiter le corps de la r&eacute;ponse par un programme
externe avant de l'envoyer au client</description>
<status>Extension</status>
<sourcefile>mod_ext_filter.c</sourcefile>
<identifier>ext_filter_module</identifier>

<summary>
    <p><module>mod_ext_filter</module> repr&eacute;sente un mod&egrave;le de
    programmation simple et bien connu pour les <a
    href="../filter.html">filtres</a>. Avec ce module, tout programme
    qui lit l'entr&eacute;e standard stdin et &eacute;crit sur la sortie standard
    stdout (autrement dit une commande filtre de style Unix) peut
    servir de filtre pour Apache. Ce m&eacute;canisme de filtrage est beaucoup
    plus lent qu'un filtre sp&eacute;cialement &eacute;crit pour
    l'API d'Apache et faisant partie int&eacute;grante du processus du serveur
    Apache, mais il pr&eacute;sente les avantages suivants :</p>

    <ul>
      <li>le mod&egrave;le de programmation est beaucoup plus simple</li>

      <li>tout langage de script ou de programmation peut &ecirc;tre utilis&eacute;,
      pourvu qu'il permette au programme de lire l'entr&eacute;e standard et
      d'&eacute;crire sur la sortie standard.</li>

      <li>on peut utiliser des programmes existants comme filtres Apache
      sans modification.</li>
    </ul>

    <p>M&ecirc;me dans le cas o&ugrave; le niveau de performance est insuffisant pour
    une utilisation en production, on peut utiliser
    <module>mod_ext_filter</module> comme prototype d'environnement pour
    les filtres.</p>

</summary>
<seealso><a href="../filter.html">Filtres</a></seealso>

<section id="examples"><title>Exemples</title>

    <section><title>G&eacute;n&eacute;rer du HTML &agrave; partir d'un autre type de
    contenu</title>

      <highlight language="config">
# la directive de mod_ext_filter d&eacute;finissant un filtre
# permettant de mettre des fichiers text/c au format HTML en
# utilisant le programme externe /usr/bin/enscript, le type du
# fichier r&eacute;sultant &eacute;tant d&eacute;fini &agrave; text/html
ExtFilterDefine c-to-html mode=output \
    intype=text/c outtype=text/html \
    cmd="/usr/bin/enscript --color -W html -Ec -o - -"

&lt;Directory "/export/home/trawick/apacheinst/htdocs/c"&gt;
    # directive de base permettant de traiter la sortie avec le
    # nouveau filtre
    SetOutputFilter c-to-html

    # directive de mod_mime d&eacute;finissant le type des fichiers dont
    # le nom poss&egrave;de l'extension .c &agrave; text/c
    AddType text/c .c
&lt;/Directory&gt;
      </highlight>
    </section>

    <section><title>Impl&eacute;mentation d'un filtre de codage de
    contenu</title>
      <p>Note : cet exemple avec gzip n'est fourni qu'&agrave; titre
      d'illustration. Veuillez vous reporter &agrave; la documentation de
      <module>mod_deflate</module> pour un exemple d'impl&eacute;mentation plus
      pratique.</p>

      <highlight language="config">
# la directive de mod_ext_filter qui d&eacute;finit le filtre externe
ExtFilterDefine gzip mode=output cmd=/bin/gzip

&lt;Location "/gzipped"&gt;

    # directive de base permettant de traiter la sortie avec le
  # filtre gzip
    SetOutputFilter gzip

    # la directive de mod_headers permettant d'ajouter le champ
  # d'en-t&ecirc;te "Content-Encoding: gzip"
    Header set Content-Encoding gzip
&lt;/Location&gt;
      </highlight>

    </section>

    <section><title>Ralentissement du serveur</title>
      <highlight language="config">
# directive de mod_ext_filter d&eacute;finissant un filtre qui fait
# passer tous les flux en sortie par la commande cat ; cat ne
# modifie rien ; elle ne fait que compliquer le cheminement des
# flux et consommer des ressources suppl&eacute;mentaires
       ExtFilterDefine slowdown mode=output cmd=/bin/cat \
ExtFilterDefine slowdown mode=output cmd=/bin/cat \
    preservescontentlength

&lt;Location "/"&gt;
    # directive de base permettant de traiter plusieurs fois la
    # sortie avec le filtre slowdown
    #
    SetOutputFilter slowdown;slowdown;slowdown
&lt;/Location&gt;
      </highlight>
    </section>

    <section><title>Utilisation de sed pour remplacer du texte dans la
    r&eacute;ponse</title>

      <highlight language="config">
# directive de mod_ext_filter d&eacute;finissant un filtre qui
# remplace du texte dans la r&eacute;ponse
#
ExtFilterDefine fixtext mode=output intype=text/html \
    cmd="/bin/sed s/verdana/arial/g"

&lt;Location "/"&gt;
    # directive de base permettant de traiter la sortie avec le
    # filtre fixtext
    SetOutputFilter fixtext
&lt;/Location&gt;
      </highlight>

<note>
<p>Vous pouvez aussi utiliser <module>mod_substitute</module> pour
effectuer le m&ecirc;me traitement sans avoir &agrave; invoquer un programme
externe.</p>
</note>      

    </section>

    <section><title>Tracer un autre filtre</title>
      <highlight language="config">
# Trace les donn&eacute;es lues et &eacute;crites par mod_deflate pour un
# client particulier (IP 192.168.1.31) qui a des probl&egrave;mes de
# compression.
# Ce premier filtre va tracer ce qui entre dans mod_deflate.
ExtFilterDefine tracebefore \
    cmd="/bin/tracefilter.pl /tmp/tracebefore" \
    EnableEnv=trace_this_client

# Ce second filtre va tracer ce qui sort de mod_deflate.
# Notez que sans le param&egrave;tre ftype, le type de filtre par
# d&eacute;faut AP_FTYPE_RESOURCE placerait le filtre *avant*
# mod_deflate dans la cha&icirc;ne de filtrage. Le fait d'affecter
# &agrave; ce param&egrave;tre une valeur num&eacute;rique sensiblement sup&eacute;rieure &agrave;
# AP_FTYPE_CONTENT_SET permet de s'assurer que le filtre sera
# plac&eacute; apr&egrave;s mod_deflate.
ExtFilterDefine traceafter \
    cmd="/bin/tracefilter.pl /tmp/traceafter" \
    EnableEnv=trace_this_client ftype=21

&lt;Directory "/usr/local/docs"&gt;
    SetEnvIf Remote_Addr 192.168.1.31 trace_this_client
    SetOutputFilter tracebefore;deflate;traceafter
&lt;/Directory&gt;
      </highlight>

      <example><title>Voici le filtre qui trace les donn&eacute;es :</title>
        <highlight language="perl">
#!/usr/local/bin/perl -w
use strict;

open(SAVE, "&gt;$ARGV[0]")
    or die "can't open $ARGV[0]: $?";

while (&lt;STDIN&gt;) {
    print SAVE $_;
    print $_;
}

close(SAVE);
        </highlight>
      </example>
    </section>
</section> <!-- /Examples -->

<directivesynopsis>
<name>ExtFilterDefine</name>
<description>D&eacute;finit un filtre externe</description>
<syntax>ExtFilterDefine <var>nom_filtre</var> <var>param&egrave;tres</var></syntax>
<contextlist><context>server config</context></contextlist>

<usage>
    <p>La directive <directive>ExtFilterDefine</directive>
    d&eacute;finit les caract&eacute;ristiques d'un filtre externe, et en particulier
    le programme &agrave; ex&eacute;cuter ainsi que ses arguments.</p>

    <p><var>nom_filtre</var> sp&eacute;cifie le nom du filtre en cours de
    d&eacute;finition. On peut ensuite utiliser ce nom pour r&eacute;f&eacute;rencer le
    filtre dans les directives <directive module="core"
    >SetOutputFilter</directive>. Il doit &ecirc;tre unique parmi les noms de
    tous les filtres enregistr&eacute;s. <em>Pour le moment, aucune erreur
    n'est signal&eacute;e par l'API register-filter, si bien qu'un probl&egrave;me de
    noms dupliqu&eacute;s ne sera pas port&eacute; &agrave; la connaissance de
    l'utilisateur.</em></p>

    <p>Viennent ensuite un ou plusieurs param&egrave;tres dans un ordre
    ind&eacute;fini, qui permettent de sp&eacute;cifier la commande externe &agrave; ex&eacute;cuter
    et certaines autres caract&eacute;ristiques. Le seul param&egrave;tre obligatoire
    est <code>cmd=</code>. Voici la liste de ces param&egrave;tres :</p>

    <dl>
      <dt><code>cmd=<var>ligne de commande</var></code></dt>

      <dd>Le mot-cl&eacute; <code>cmd=</code> sp&eacute;cifie la commande
      externe &agrave; ex&eacute;cuter. Si la ligne de commande comporte des
      arguments, elle doit &ecirc;tre entour&eacute;e de guillemets (par exemple
      <code>cmd="<var>/bin/mypgm</var> <var>arg1</var>
      <var>arg2</var>"</code>). Les guillemets habituels du shell ne
      sont pas n&eacute;cessaires car le programme est lanc&eacute; directement, sans
      passer par le shell. Les arguments du programme doivent &ecirc;tre
      s&eacute;par&eacute;s par des espaces. Si un argument contient des espaces, ces
      derniers doivent &ecirc;tre &eacute;chapp&eacute;s par un antislash '\'. Si un
      argument contient des antislashes '\', ces derniers doivent &ecirc;tre
      eux-m&ecirc;mes &eacute;chapp&eacute;s par un antislash '\'. Outre les variables
      d'environnement CGI standards, les variables DOCUMENT_URI,
      DOCUMENT_PATH_INFO, et QUERY_STRING_UNESCAPED seront &eacute;galement
      d&eacute;finies pour le programme.</dd>

      <dt><code>mode=<var>mode</var></code></dt>

      <dd>Utilisez <code>mode=output</code> (valeur par d&eacute;faut) pour les
      filtres qui traitent les r&eacute;ponses. Utilisez
      <code>mode=input</code> pour les filtres qui traitent les
      requ&ecirc;tes. <code>mode=input</code> est disponible depuis la version
      2.1 d'Apache.</dd>

      <dt><code>intype=<var>type MIME</var></code></dt>

      <dd>Ce param&egrave;tre sp&eacute;cifie le type de m&eacute;dium Internet
      (c'est &agrave; dire le type MIME) des documents qui doivent &ecirc;tre
      filtr&eacute;s. Par d&eacute;faut, tous les documents sont filtr&eacute;s. Aucun des
      documents poss&eacute;dant un type MIME autre que celui sp&eacute;cifi&eacute; par
      <code>intype=</code> ne sera filtr&eacute;.</dd>

      <dt><code>outtype=<var>type MIME</var></code></dt>

      <dd>Ce param&egrave;tre sp&eacute;cifie le type de m&eacute;dium Internet
      (c'est &agrave; dire le type MIME) des documents filtr&eacute;s. Il intervient
      lorsque les op&eacute;rations de filtrage comprennent une modification du
      type MIME. Par d&eacute;faut, le type MIME n'est pas modifi&eacute;.</dd>

      <dt><code>PreservesContentLength</code></dt>

      <dd>Le mot-cl&eacute; <code>PreservesContentLength</code> indique que le
      filtre doit conserver la taille du contenu. Ce n'est pas le
      comportement par d&eacute;faut, car la plupart des filtres modifient cette
      taille. Ce mot-cl&eacute; doit &ecirc;tre sp&eacute;cifi&eacute; si le filtre ne doit pas
      modifier la taille du contenu.</dd>

      <dt><code>ftype=<var>type de filtre</var></code></dt>

      <dd>Ce param&egrave;tre sp&eacute;cifie une valeur num&eacute;rique
      repr&eacute;sentant le type de filtre sous lequel le filtre doit &ecirc;tre
      enregistr&eacute;. La valeur par d&eacute;faut, AP_FTYPE_RESOURCE, convient dans
      la plupart des situations. Ce param&egrave;tre devient n&eacute;cessaire d&egrave;s lors
      que le filtre doit op&eacute;rer &agrave; un autre point de la cha&icirc;ne de filtrage
      que les filtres de ressources.
      Voir les d&eacute;finitions de AP_FTYPE_...
      dans util_filter.h pour trouver une valeur appropri&eacute;e.</dd>

      <dt><code>disableenv=<var>env</var></code></dt>

      <dd>Ce param&egrave;tre sp&eacute;cifie le nom d'une variable
      d'environnement qui, si elle est d&eacute;finie, va d&eacute;sactiver le
      filtre.</dd>

      <dt><code>enableenv=<var>env</var></code></dt>

      <dd>Ce param&egrave;tre sp&eacute;cifie le nom d'une variable
      d'environnement qui doit &ecirc;tre d&eacute;finie pour que le filtre ne soit
      pas d&eacute;sactiv&eacute;.</dd>
    </dl>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>ExtFilterOptions</name>
<description>Configure les options de
<module>mod_ext_filter</module></description>
<syntax>ExtFilterOptions <var>option</var> [<var>option</var>] ...</syntax>
<default>ExtFilterOptions NoLogStderr</default>
<contextlist><context>directory</context></contextlist>

<usage>
    <p>La directive <directive>ExtFilterOptions</directive>
    sp&eacute;cifie des options de traitement particuli&egrave;res pour
    <module>mod_ext_filter</module>. Les arguments <var>option</var>
    peuvent contenir :</p>

    <dl>
      <dt><code>LogStderr | NoLogStderr</code></dt>

      <dd>Le mot-cl&eacute; <code>LogStderr</code> indique que les messages
      envoy&eacute;s par le programme de filtrage externe sur la sortie
      d'erreurs standard doivent &ecirc;tre enregistr&eacute;s dans le journal des
      erreurs d'Apache. <code>NoLogStderr</code> inverse ce
      comportement.</dd>

      <dt><code>Onfail=[abort|remove]</code></dt>
      <dd>Indique la marche &agrave; suivre si le programme de filtrage externe
      ne peut pas d&eacute;marrer. Avec <code>abort</code> (la valeur par
      d&eacute;faut), le traitement de la requ&ecirc;te sera abandonn&eacute;. Avec <code>remove</code>, le
      filtre est supprim&eacute;, et le traitement de la requ&ecirc;te se poursuit
      sans lui.</dd>
    </dl>

    <highlight language="config">
      ExtFilterOptions LogStderr
    </highlight>

    <p>Les messages envoy&eacute;s vers la sortie d'erreurs standard du filtre
    seront enregistr&eacute;s dans le journal des erreurs d'Apache.</p>
</usage>
</directivesynopsis>

</modulesynopsis>
