/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.io.ByteArrayInputStream;
import java.security.Security;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509CRL;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.util.ArrayList;
import java.util.Collection;
import org.bouncycastle.jce.MultiCertStoreParameters;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.provider.test.CertPathTest;
import org.bouncycastle.util.test.SimpleTest;

public class MultiCertStoreTest
extends SimpleTest {
    public void performTest() throws Exception {
        this.basicTest();
    }

    private void basicTest() throws Exception {
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", "BC");
        X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(CertPathTest.rootCertBin));
        X509Certificate x509Certificate2 = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(CertPathTest.interCertBin));
        X509Certificate x509Certificate3 = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(CertPathTest.finalCertBin));
        X509CRL x509CRL = (X509CRL)certificateFactory.generateCRL(new ByteArrayInputStream(CertPathTest.rootCrlBin));
        X509CRL x509CRL2 = (X509CRL)certificateFactory.generateCRL(new ByteArrayInputStream(CertPathTest.interCrlBin));
        ArrayList<X509Extension> arrayList = new ArrayList<X509Extension>();
        arrayList.add(x509Certificate);
        arrayList.add(x509Certificate2);
        arrayList.add(x509Certificate3);
        arrayList.add(x509CRL);
        arrayList.add(x509CRL2);
        CollectionCertStoreParameters collectionCertStoreParameters = new CollectionCertStoreParameters(arrayList);
        CertStore certStore = CertStore.getInstance("Collection", (CertStoreParameters)collectionCertStoreParameters, "BC");
        CertStore certStore2 = CertStore.getInstance("Collection", (CertStoreParameters)collectionCertStoreParameters, "BC");
        ArrayList<CertStore> arrayList2 = new ArrayList<CertStore>();
        arrayList2.add(certStore);
        arrayList2.add(certStore2);
        CertStore certStore3 = CertStore.getInstance("Multi", new MultiCertStoreParameters(arrayList2));
        X509CertSelector x509CertSelector = new X509CertSelector();
        x509CertSelector.setSubject(x509Certificate.getSubjectX500Principal().getName());
        Collection<? extends Certificate> collection = certStore3.getCertificates(x509CertSelector);
        if (collection.size() != 2 || !collection.contains(x509Certificate)) {
            this.fail("2 rootCerts not found by subjectDN");
        }
        if ((collection = (certStore3 = CertStore.getInstance("Multi", new MultiCertStoreParameters(arrayList2, false))).getCertificates(x509CertSelector)).size() != 1 || !collection.contains(x509Certificate)) {
            this.fail("1 rootCert not found by subjectDN");
        }
    }

    public String getName() {
        return "MultiCertStore";
    }

    public static void main(String[] stringArray) {
        Security.addProvider(new BouncyCastleProvider());
        MultiCertStoreTest.runTest(new MultiCertStoreTest());
    }
}

