/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class ElGamalTest
extends SimpleTest {
    private BigInteger g512 = new BigInteger("153d5d6172adb43045b68ae8e1de1070b6137005686d29d3d73a7749199681ee5b212c9b96bfdcfa5b20cd5e3fd2044895d609cf9b410b7a0f12ca1cb9a428cc", 16);
    private BigInteger p512 = new BigInteger("9494fec095f3b85ee286542b3836fc81a5dd0a0349b4c239dd38744d488cf8e31db8bcb7d33b41abb9e5a33cca9144b1cef332c94bf0573bf047a3aca98cdf3b", 16);
    private BigInteger g768 = new BigInteger("7c240073c1316c621df461b71ebb0cdcc90a6e5527e5e126633d131f87461c4dc4afc60c2cb0f053b6758871489a69613e2a8b4c8acde23954c08c81cbd36132cfd64d69e4ed9f8e51ed6e516297206672d5c0a69135df0a5dcf010d289a9ca1", 16);
    private BigInteger p768 = new BigInteger("8c9dd223debed1b80103b8b309715be009d48860ed5ae9b9d5d8159508efd802e3ad4501a7f7e1cfec78844489148cd72da24b21eddd01aa624291c48393e277cfc529e37075eccef957f3616f962d15b44aeab4039d01b817fde9eaa12fd73f", 16);
    private BigInteger g1024 = new BigInteger("1db17639cdf96bc4eabba19454f0b7e5bd4e14862889a725c96eb61048dcd676ceb303d586e30f060dbafd8a571a39c4d823982117da5cc4e0f89c77388b7a08896362429b94a18a327604eb7ff227bffbc83459ade299e57b5f77b50fb045250934938efa145511166e3197373e1b5b1e52de713eb49792bedde722c6717abf", 16);
    private BigInteger p1024 = new BigInteger("a00e283b3c624e5b2b4d9fbc2653b5185d99499b00fd1bf244c6f0bb817b4d1c451b2958d62a0f8a38caef059fb5ecd25d75ed9af403f5b5bdab97a642902f824e3c13789fed95fa106ddfe0ff4a707c85e2eb77d49e68f2808bcea18ce128b178cd287c6bc00efa9a1ad2a673fe0dceace53166f75b81d6709d5f8af7c66bb7", 16);

    public String getName() {
        return "ElGamal";
    }

    private void testGP(int n, int n2, BigInteger bigInteger, BigInteger bigInteger2) throws Exception {
        byte[] byArray;
        PKCS8EncodedKeySpec pKCS8EncodedKeySpec;
        DHPrivateKey dHPrivateKey;
        X509EncodedKeySpec x509EncodedKeySpec;
        DHParameterSpec dHParameterSpec = new DHParameterSpec(bigInteger2, bigInteger, n2);
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("ElGamal", "BC");
        byte[] byArray2 = "This is a test".getBytes();
        keyPairGenerator.initialize(dHParameterSpec);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        SecureRandom secureRandom = new SecureRandom();
        this.checkKeySize(n2, keyPair);
        Cipher cipher = Cipher.getInstance("ElGamal", "BC");
        cipher.init(1, (Key)keyPair.getPublic(), secureRandom);
        if (cipher.getOutputSize(byArray2.length) != n / 8 * 2) {
            this.fail("getOutputSize wrong on encryption");
        }
        byte[] byArray3 = cipher.doFinal(byArray2);
        cipher.init(2, keyPair.getPrivate());
        if (cipher.getOutputSize(byArray3.length) != n / 8 - 1) {
            this.fail("getOutputSize wrong on decryption");
        }
        byte[] byArray4 = ((DHPublicKey)keyPair.getPublic()).getParams().getP().toByteArray();
        byte[] byArray5 = new byte[byArray4.length - 1];
        byArray5[0] = (byte)(byArray5[0] | 0x7F);
        cipher.init(1, (Key)keyPair.getPublic(), secureRandom);
        byArray3 = cipher.doFinal(byArray5);
        cipher.init(2, keyPair.getPrivate());
        byArray3 = cipher.doFinal(byArray3);
        if (!this.areEqual(byArray3, byArray5)) {
            this.fail("NoPadding test failed on decrypt expected " + new String(Hex.encode(byArray5)) + " got " + new String(Hex.encode(byArray3)));
        }
        Cipher cipher2 = Cipher.getInstance("ElGamal", "BC");
        Cipher cipher3 = Cipher.getInstance("ElGamal", "BC");
        cipher2.init(1, (Key)keyPair.getPublic(), secureRandom);
        byte[] byArray6 = cipher2.doFinal(byArray2);
        cipher3.init(2, keyPair.getPrivate());
        byte[] byArray7 = cipher3.doFinal(byArray6);
        if (!this.areEqual(byArray2, byArray7)) {
            this.fail(n + " encrypt test failed");
        }
        int n3 = cipher2.update(byArray2, 0, 2, byArray6, 0);
        n3 += cipher2.doFinal(byArray2, 2, byArray2.length - 2, byArray6, n3);
        n3 = cipher3.update(byArray6, 0, 2, byArray7, 0);
        n3 += cipher3.doFinal(byArray6, 2, byArray6.length - 2, byArray7, n3);
        if (!this.areEqual(byArray2, byArray7)) {
            this.fail(n + " encrypt with update test failed");
        }
        byte[] byArray8 = keyPair.getPublic().getEncoded();
        KeyFactory keyFactory = KeyFactory.getInstance("ElGamal", "BC");
        DHPublicKey dHPublicKey = (DHPublicKey)keyFactory.generatePublic(x509EncodedKeySpec = new X509EncodedKeySpec(byArray8));
        DHParameterSpec dHParameterSpec2 = dHPublicKey.getParams();
        if (!dHParameterSpec2.getG().equals(dHParameterSpec.getG()) || !dHParameterSpec2.getP().equals(dHParameterSpec.getP())) {
            this.fail(n + " bit public key encoding/decoding test failed on parameters");
        }
        if (!((DHPublicKey)keyPair.getPublic()).getY().equals(dHPublicKey.getY())) {
            this.fail(n + " bit public key encoding/decoding test failed on y value");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(keyPair.getPublic());
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        dHPublicKey = (DHPublicKey)objectInputStream.readObject();
        dHParameterSpec2 = dHPublicKey.getParams();
        if (!dHParameterSpec2.getG().equals(dHParameterSpec.getG()) || !dHParameterSpec2.getP().equals(dHParameterSpec.getP())) {
            this.fail(n + " bit public key serialisation test failed on parameters");
        }
        if (!((DHPublicKey)keyPair.getPublic()).getY().equals(dHPublicKey.getY())) {
            this.fail(n + " bit public key serialisation test failed on y value");
        }
        if (!(dHParameterSpec2 = (dHPrivateKey = (DHPrivateKey)keyFactory.generatePrivate(pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray = keyPair.getPrivate().getEncoded()))).getParams()).getG().equals(dHParameterSpec.getG()) || !dHParameterSpec2.getP().equals(dHParameterSpec.getP())) {
            this.fail(n + " bit private key encoding/decoding test failed on parameters");
        }
        if (!((DHPrivateKey)keyPair.getPrivate()).getX().equals(dHPrivateKey.getX())) {
            this.fail(n + " bit private key encoding/decoding test failed on y value");
        }
        byteArrayOutputStream = new ByteArrayOutputStream();
        objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(keyPair.getPrivate());
        byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        objectInputStream = new ObjectInputStream(byteArrayInputStream);
        dHPrivateKey = (DHPrivateKey)objectInputStream.readObject();
        dHParameterSpec2 = dHPrivateKey.getParams();
        if (!dHParameterSpec2.getG().equals(dHParameterSpec.getG()) || !dHParameterSpec2.getP().equals(dHParameterSpec.getP())) {
            this.fail(n + " bit private key serialisation test failed on parameters");
        }
        if (!((DHPrivateKey)keyPair.getPrivate()).getX().equals(dHPrivateKey.getX())) {
            this.fail(n + " bit private key serialisation test failed on y value");
        }
    }

    private void checkKeySize(int n, KeyPair keyPair) {
        DHPrivateKey dHPrivateKey;
        if (n != 0 && (dHPrivateKey = (DHPrivateKey)keyPair.getPrivate()).getX().bitLength() != n) {
            this.fail("limited key check failed for key size " + n);
        }
    }

    private void testRandom(int n) throws Exception {
        AlgorithmParameterGenerator algorithmParameterGenerator = AlgorithmParameterGenerator.getInstance("ElGamal", "BC");
        algorithmParameterGenerator.init(n, new SecureRandom());
        AlgorithmParameters algorithmParameters = algorithmParameterGenerator.generateParameters();
        byte[] byArray = algorithmParameters.getEncoded();
        AlgorithmParameters algorithmParameters2 = AlgorithmParameters.getInstance("ElGamal", "BC");
        algorithmParameters2.init(byArray);
        byte[] byArray2 = algorithmParameters2.getEncoded();
        if (!this.areEqual(byArray, byArray2)) {
            this.fail(this.getName() + ": encode/decode parameters failed");
        }
        DHParameterSpec dHParameterSpec = algorithmParameters.getParameterSpec(DHParameterSpec.class);
        this.testGP(n, 0, dHParameterSpec.getG(), dHParameterSpec.getP());
    }

    public void performTest() throws Exception {
        this.testGP(512, 0, this.g512, this.p512);
        this.testGP(768, 0, this.g768, this.p768);
        this.testGP(1024, 0, this.g1024, this.p1024);
        this.testGP(512, 64, this.g512, this.p512);
        this.testGP(768, 128, this.g768, this.p768);
        this.testGP(1024, 256, this.g1024, this.p1024);
        this.testRandom(256);
    }

    public static void main(String[] stringArray) {
        Security.addProvider(new BouncyCastleProvider());
        ElGamalTest.runTest(new ElGamalTest());
    }
}

