/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Security;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.jce.netscape.NetscapeCertRequest;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class NetscapeCertRequestTest
implements Test {
    static final String test1 = "MIIBRzCBsTCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEAmwdh+LJXQ8AtXczo4EIGfXjpmDwsoIRpPaXEx1CBHhpon/Dpo/o5Vw2WoWNICXj5lmqhftIpCPO9qKxx85x6k/fuyTPH8P02hkmscAYsgqOgb/1yRCNXFryuFOATqxw1tsuye5Q3lTU9JCLUUilQ6BV8n3fm2egtPPUaJEuCvcsCAwEAARYNZml4ZWQtZm9yLW5vdzANBgkqhkiG9w0BAQQFAAOBgQAImbJD6xHbJtXl6kOTbCFoMnDk7U0o6pHy9l56DYVsiluXegiY6twB4o7OWsrqTb+gVvzK65FfP+NBVVzxY8UzcjbqC51yvO/9wnpUsIBqD/Gvi1gEqvw7RHwVEhdzsvLwlL22G8CfDxHnWLww39j8uRJsmoNiKJly3BcsZkLd9g==";

    public String getName() {
        return "NetscapeCertRequest";
    }

    public TestResult perform() {
        try {
            String string = "fixed-for-now";
            byte[] byArray = Base64.decode(test1);
            ASN1InputStream aSN1InputStream = new ASN1InputStream(new ByteArrayInputStream(byArray));
            ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
            NetscapeCertRequest netscapeCertRequest = new NetscapeCertRequest(aSN1Sequence);
            if (!netscapeCertRequest.verify(string)) {
                return new SimpleTestResult(false, this.getName() + ": 1 - not verified");
            }
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(netscapeCertRequest.getKeyAlgorithm().getObjectId().getId(), "BC");
            keyPairGenerator.initialize(1024);
            KeyPair keyPair = keyPairGenerator.genKeyPair();
            netscapeCertRequest.setPublicKey(keyPair.getPublic());
            netscapeCertRequest.sign(keyPair.getPrivate());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
            dEROutputStream.writeObject(netscapeCertRequest);
            dEROutputStream.close();
            ASN1InputStream aSN1InputStream2 = new ASN1InputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            ASN1Sequence aSN1Sequence2 = (ASN1Sequence)aSN1InputStream2.readObject();
            NetscapeCertRequest netscapeCertRequest2 = new NetscapeCertRequest(aSN1Sequence2);
            if (!netscapeCertRequest2.verify(string)) {
                return new SimpleTestResult(false, this.getName() + ": 2 - not verified");
            }
            string = "try it";
            NetscapeCertRequest netscapeCertRequest3 = new NetscapeCertRequest(string, new AlgorithmIdentifier(PKCSObjectIdentifiers.sha1WithRSAEncryption, null), keyPair.getPublic());
            netscapeCertRequest3.sign(keyPair.getPrivate());
            if (netscapeCertRequest3.verify(string)) {
                return new SimpleTestResult(true, this.getName() + ": Okay");
            }
            return new SimpleTestResult(false, this.getName() + ": 3 - not verified");
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ": exception - " + exception.toString());
        }
    }

    public static void main(String[] stringArray) {
        Security.addProvider(new BouncyCastleProvider());
        NetscapeCertRequestTest netscapeCertRequestTest = new NetscapeCertRequestTest();
        TestResult testResult = netscapeCertRequestTest.perform();
        System.out.println(((Object)testResult).toString());
    }
}

