/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.rule;

import java.io.StringWriter;
import org.jboss.byteman.objectweb.asm.Label;
import org.jboss.byteman.objectweb.asm.MethodVisitor;
import org.jboss.byteman.rule.Rule;
import org.jboss.byteman.rule.binding.Bindings;
import org.jboss.byteman.rule.compiler.CompileContext;
import org.jboss.byteman.rule.exception.CompileException;
import org.jboss.byteman.rule.exception.ExecuteException;
import org.jboss.byteman.rule.exception.TypeException;
import org.jboss.byteman.rule.helper.HelperAdapter;
import org.jboss.byteman.rule.type.Type;
import org.jboss.byteman.rule.type.TypeGroup;

public abstract class RuleElement {
    protected Rule rule;

    protected RuleElement(Rule rule) {
        this.rule = rule;
    }

    protected TypeGroup getTypeGroup() {
        return this.rule.getTypeGroup();
    }

    protected Bindings getBindings() {
        return this.rule.getBindings();
    }

    public abstract Type typeCheck(Type var1) throws TypeException;

    public abstract Object interpret(HelperAdapter var1) throws ExecuteException;

    public abstract void compile(MethodVisitor var1, CompileContext var2) throws CompileException;

    protected void compileTypeConversion(Type fromType, Type toType, MethodVisitor mv, CompileContext compileContext) throws CompileException {
        if (fromType.equals(toType)) {
            return;
        }
        if (toType.isNumeric()) {
            this.compileNumericConversion(fromType, toType, mv, compileContext);
        } else if (toType.isString()) {
            this.compileStringConversion(fromType, toType, mv, compileContext);
        } else if (toType.isBoolean()) {
            this.compileBooleanConversion(fromType, toType, mv, compileContext);
        } else {
            this.compileObjectConversion(fromType, toType, mv, compileContext);
        }
    }

    protected void compileNumericConversion(Type fromType, Type toType, MethodVisitor mv, CompileContext compileContext) throws CompileException {
        boolean unbox = fromType.isObject();
        boolean box = toType.isObject();
        if (unbox) {
            if (!fromType.isNumeric()) {
                this.compileObjectConversion(fromType, Type.NUMBER, mv, compileContext);
            }
            if (box) {
                Type midType = Type.boxType(toType);
                this.compileUnbox(fromType, midType, mv, compileContext);
                this.compileBox(midType, mv, compileContext);
            } else {
                this.compileUnbox(fromType, toType, mv, compileContext);
            }
        } else if (box) {
            Type midType = Type.boxType(toType);
            if (fromType != midType) {
                this.compilePrimitiveConversion(fromType, midType, mv, compileContext);
            }
            this.compileBox(toType, mv, compileContext);
        } else {
            this.compilePrimitiveConversion(fromType, toType, mv, compileContext);
        }
    }

    protected void compileUnbox(Type fromType, Type toType, MethodVisitor mv, CompileContext compileContext) throws CompileException {
        if (fromType == Type.BOOLEAN) {
            assert (toType == Type.Z);
            mv.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z");
        } else if (fromType == Type.CHARACTER) {
            mv.visitMethodInsn(182, "java/lang/Character", "charValue", "()C");
            this.compilePrimitiveConversion(Type.C, toType, mv, compileContext);
        } else if (toType == Type.B) {
            mv.visitMethodInsn(182, "java/lang/Number", "byteValue", "()B");
        } else if (toType == Type.S) {
            mv.visitMethodInsn(182, "java/lang/Number", "shortValue", "()S");
        } else if (toType == Type.C) {
            mv.visitMethodInsn(182, "java/lang/Number", "intValue", "()I");
            mv.visitIntInsn(120, 16);
            mv.visitIntInsn(123, 16);
        } else if (toType == Type.I) {
            mv.visitMethodInsn(182, "java/lang/Number", "intValue", "()I");
        } else if (toType == Type.J) {
            mv.visitMethodInsn(182, "java/lang/Number", "longValue", "()J");
            compileContext.addStackCount(1);
        } else if (toType == Type.F) {
            mv.visitMethodInsn(182, "java/lang/Number", "floatValue", "()F");
        } else {
            assert (toType == Type.D);
            compileContext.addStackCount(1);
            mv.visitMethodInsn(182, "java/lang/Number", "doubleValue", "()D");
        }
    }

    protected void compileBox(Type toType, MethodVisitor mv, CompileContext compileContext) throws CompileException {
        if (toType == Type.BOOLEAN) {
            mv.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;");
        } else if (toType == Type.BYTE) {
            mv.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;");
        } else if (toType == Type.SHORT) {
            mv.visitMethodInsn(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;");
        } else if (toType == Type.CHARACTER) {
            mv.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;");
        } else if (toType == Type.INTEGER) {
            mv.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
        } else if (toType == Type.LONG) {
            mv.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
            compileContext.addStackCount(-1);
        } else if (toType == Type.FLOAT) {
            mv.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;");
        } else if (toType == Type.DOUBLE) {
            mv.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;");
            compileContext.addStackCount(-1);
        }
    }

    protected void compileStringConversion(Type fromType, Type toType, MethodVisitor mv, CompileContext compileContext) throws CompileException {
        assert (toType == Type.STRING);
        if (fromType.isObject() || fromType.isArray() || fromType.isNumeric() && !fromType.isPrimitive()) {
            Label elseLabel = new Label();
            Label endLabel = new Label();
            mv.visitInsn(89);
            mv.visitJumpInsn(199, elseLabel);
            mv.visitInsn(87);
            mv.visitInsn(1);
            mv.visitJumpInsn(167, endLabel);
            mv.visitLabel(elseLabel);
            mv.visitMethodInsn(182, "java/lang/Object", "toString", "()Ljava/lang/String;");
            mv.visitLabel(endLabel);
        } else if (fromType == Type.Z) {
            mv.visitMethodInsn(184, "java/lang/Boolean", "toString", "(Z)Ljava/lang/String;");
        } else if (fromType == Type.B) {
            mv.visitMethodInsn(184, "java/lang/Byte", "toString", "(B)Ljava/lang/String;");
        } else if (fromType == Type.S) {
            mv.visitMethodInsn(184, "java/lang/Short", "toString", "(S)Ljava/lang/String;");
        } else if (fromType == Type.C) {
            mv.visitMethodInsn(184, "java/lang/Character", "toString", "(C)Ljava/lang/String;");
        } else if (fromType == Type.I) {
            mv.visitMethodInsn(184, "java/lang/Integer", "toString", "(I)Ljava/lang/String;");
        } else if (fromType == Type.J) {
            mv.visitMethodInsn(184, "java/lang/Long", "toString", "(J)Ljava/lang/String;");
            compileContext.addStackCount(-1);
        } else if (fromType == Type.F) {
            mv.visitMethodInsn(184, "java/lang/Float", "toString", "(F)Ljava/lang/String;");
        } else if (fromType == Type.D) {
            mv.visitMethodInsn(184, "java/lang/Double", "toString", "(D)Ljava/lang/String;");
            compileContext.addStackCount(-1);
        }
    }

    protected void compilePrimitiveConversion(Type fromType, Type toType, MethodVisitor mv, CompileContext compileContext) throws CompileException {
        if (fromType == Type.B || fromType == Type.S || fromType == Type.I) {
            if (toType == Type.B) {
                mv.visitInsn(145);
            } else if (toType == Type.S) {
                mv.visitInsn(147);
            } else if (toType == Type.C) {
                mv.visitInsn(146);
            } else if (toType != Type.I) {
                if (toType == Type.J) {
                    mv.visitInsn(133);
                    compileContext.addStackCount(1);
                } else if (toType == Type.F) {
                    mv.visitInsn(134);
                } else if (toType == Type.D) {
                    mv.visitInsn(135);
                    compileContext.addStackCount(1);
                }
            }
        } else if (fromType == Type.C) {
            if (toType == Type.B) {
                mv.visitInsn(145);
            } else if (toType == Type.S) {
                mv.visitInsn(147);
            } else if (toType != Type.C && toType != Type.I) {
                if (toType == Type.J) {
                    mv.visitInsn(133);
                    compileContext.addStackCount(1);
                } else if (toType == Type.F) {
                    mv.visitInsn(134);
                } else if (toType == Type.D) {
                    mv.visitInsn(135);
                    compileContext.addStackCount(1);
                }
            }
        } else if (fromType == Type.J) {
            if (toType == Type.B || toType == Type.S || toType == Type.I || toType == Type.C) {
                mv.visitInsn(136);
                compileContext.addStackCount(-1);
            } else if (toType != Type.J) {
                if (toType == Type.F) {
                    mv.visitInsn(137);
                    compileContext.addStackCount(-1);
                } else if (toType == Type.D) {
                    mv.visitInsn(138);
                }
            }
        } else if (fromType == Type.F) {
            if (toType == Type.B) {
                mv.visitInsn(139);
                mv.visitInsn(145);
            } else if (toType == Type.S) {
                mv.visitInsn(139);
                mv.visitInsn(147);
            } else if (toType == Type.C) {
                mv.visitInsn(139);
                mv.visitInsn(146);
            } else if (toType == Type.I) {
                mv.visitInsn(139);
            } else if (toType == Type.J) {
                mv.visitInsn(140);
                compileContext.addStackCount(1);
            } else if (toType != Type.F && toType == Type.D) {
                mv.visitInsn(141);
                compileContext.addStackCount(1);
            }
        } else if (fromType == Type.D) {
            if (toType == Type.B) {
                mv.visitInsn(142);
                mv.visitInsn(145);
                compileContext.addStackCount(-1);
            } else if (toType == Type.S) {
                mv.visitInsn(142);
                mv.visitInsn(147);
                compileContext.addStackCount(-1);
            } else if (toType == Type.C) {
                mv.visitInsn(142);
                mv.visitInsn(146);
                compileContext.addStackCount(-1);
            } else if (toType == Type.I) {
                mv.visitInsn(142);
                compileContext.addStackCount(-1);
            } else if (toType == Type.J) {
                mv.visitInsn(143);
            } else if (toType == Type.F) {
                mv.visitInsn(144);
                compileContext.addStackCount(-1);
            } else if (toType == Type.D) {
                // empty if block
            }
        }
    }

    protected void compileBooleanConversion(Type fromType, Type toType, MethodVisitor mv, CompileContext compileContext) throws CompileException {
        if (toType == Type.Z) {
            assert (fromType == Type.BOOLEAN);
            this.compileUnbox(fromType, toType, mv, compileContext);
        } else {
            assert (toType == Type.BOOLEAN);
            assert (fromType == Type.Z);
            this.compileBox(toType, mv, compileContext);
        }
    }

    protected void compileObjectConversion(Type fromType, Type toType, MethodVisitor mv, CompileContext compileContext) throws CompileException {
        if (fromType.isPrimitive()) {
            Type boxType = Type.boxType(fromType);
            this.compileBox(boxType, mv, compileContext);
            fromType = boxType;
        }
        if (toType.isAssignableFrom(fromType)) {
            if (toType == Type.STRING && fromType != Type.STRING) {
                this.compileStringConversion(fromType, toType, mv, compileContext);
            }
        } else {
            assert (fromType.isAssignableFrom(toType));
            mv.visitTypeInsn(192, toType.getInternalName(false, true));
        }
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        this.writeTo(stringWriter);
        return stringWriter.toString();
    }

    public abstract void writeTo(StringWriter var1);
}

