/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.rule.expression;

import org.jboss.byteman.objectweb.asm.Label;
import org.jboss.byteman.objectweb.asm.MethodVisitor;
import org.jboss.byteman.rule.Rule;
import org.jboss.byteman.rule.compiler.CompileContext;
import org.jboss.byteman.rule.exception.CompileException;
import org.jboss.byteman.rule.exception.ExecuteException;
import org.jboss.byteman.rule.exception.TypeException;
import org.jboss.byteman.rule.expression.Expression;
import org.jboss.byteman.rule.expression.TernaryOperExpression;
import org.jboss.byteman.rule.grammar.ParseNode;
import org.jboss.byteman.rule.helper.HelperAdapter;
import org.jboss.byteman.rule.type.Type;

public class ConditionalEvalExpression
extends TernaryOperExpression {
    public ConditionalEvalExpression(Rule rule, Type type, ParseNode token, Expression cond, Expression if_expr, Expression else_expr) {
        super(rule, 18432, type, token, cond, if_expr, else_expr);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Type typeCheck(Type expected) throws TypeException {
        Type condType = this.getOperand(0).typeCheck(Type.Z);
        Type type1 = this.getOperand(1).typeCheck(expected);
        Type type2 = this.getOperand(2).typeCheck(expected);
        if (type2 != type1) {
            if (type1.isNumeric() && type2.isNumeric()) {
                this.type = Type.promote(type1, type2);
            } else if (type2.isAssignableFrom(type1)) {
                this.type = type2;
            } else {
                if (!type1.isAssignableFrom(type2)) throw new TypeException("ConditionalEvalExpression.typeCheck : incompatible argument types " + type1.getName() + " and " + type2.getName() + this.getPos());
                this.type = type1;
            }
        } else {
            this.type = type1;
        }
        if (!Type.dereference(expected).isDefined() || expected.isAssignableFrom(this.type)) return this.type;
        throw new TypeException("ConditionalEvalExpression.typeCheck : invalid expected result type " + expected.getName() + this.getPos());
    }

    @Override
    public Object interpret(HelperAdapter helper) throws ExecuteException {
        Boolean executeFirstBranch = (Boolean)this.getOperand(0).interpret(helper);
        if (executeFirstBranch.booleanValue()) {
            return this.getOperand(1).interpret(helper);
        }
        return this.getOperand(2).interpret(helper);
    }

    @Override
    public void compile(MethodVisitor mv, CompileContext compileContext) throws CompileException {
        compileContext.notifySourceLine(this.line);
        Expression oper0 = this.getOperand(0);
        Expression oper1 = this.getOperand(1);
        Expression oper2 = this.getOperand(2);
        int currentStack = compileContext.getStackCount();
        int expected = this.type.getNBytes() > 4 ? 2 : 1;
        oper0.compile(mv, compileContext);
        if (oper0.getType() == Type.BOOLEAN) {
            this.compileBooleanConversion(Type.BOOLEAN, Type.Z, mv, compileContext);
        }
        Label elseLabel = new Label();
        Label endLabel = new Label();
        mv.visitJumpInsn(153, elseLabel);
        compileContext.addStackCount(-1);
        oper1.compile(mv, compileContext);
        this.compileTypeConversion(oper1.getType(), this.type, mv, compileContext);
        mv.visitJumpInsn(167, endLabel);
        if (compileContext.getStackCount() != currentStack + expected) {
            throw new CompileException("ConditionalEvalExpression.compile : invalid true branch stack height " + compileContext.getStackCount() + " expecting " + currentStack + expected);
        }
        compileContext.addStackCount(-expected);
        mv.visitLabel(elseLabel);
        oper2.compile(mv, compileContext);
        this.compileTypeConversion(oper2.getType(), this.type, mv, compileContext);
        mv.visitLabel(endLabel);
        if (compileContext.getStackCount() != currentStack + expected) {
            throw new CompileException("ConditionalEvalExpression.compile : invalid false branch stack height " + compileContext.getStackCount() + " expecting " + currentStack + expected);
        }
    }
}

