/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.synchronization;

import java.util.LinkedList;
import java.util.List;

public class Joiner {
    private List<Thread> children;
    private int max;
    private Thread parent;

    public Joiner(int max) {
        this.max = max;
        this.children = new LinkedList<Thread>();
        this.parent = null;
    }

    public int getMax() {
        return this.max;
    }

    public synchronized Status addChild(Thread thread) {
        if (this.children.contains(thread)) {
            return Status.DUPLICATE;
        }
        int size = this.children.size();
        if (size == this.max) {
            return Status.EXCESS;
        }
        this.children.add(thread);
        if (++size == this.max) {
            if (this.parent == null) {
                return Status.FILLED;
            }
            this.notifyAll();
            return Status.DONE;
        }
        return Status.ADDED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean joinChildren(Thread thread) {
        Joiner joiner = this;
        synchronized (joiner) {
            if (this.parent != null) {
                return false;
            }
            this.parent = thread;
            while (this.children.size() < this.max) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {}
            }
        }
        for (int i = 0; i < this.max; ++i) {
            Thread child = this.children.get(i);
            try {
                child.join();
                continue;
            }
            catch (InterruptedException e) {
                break;
            }
        }
        return true;
    }

    public static enum Status {
        DUPLICATE,
        EXCESS,
        ADDED,
        FILLED,
        DONE;

    }
}

