/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.Serializable;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.SocketAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttr;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.helpers.Booleans;
import org.apache.logging.log4j.core.layout.AbstractStringLayout;
import org.apache.logging.log4j.core.layout.LoggerFields;
import org.apache.logging.log4j.core.layout.RFC5424Layout;
import org.apache.logging.log4j.core.layout.SyslogLayout;
import org.apache.logging.log4j.core.net.AbstractSocketManager;
import org.apache.logging.log4j.core.net.Advertiser;
import org.apache.logging.log4j.core.net.Protocol;
import org.apache.logging.log4j.util.EnglishEnums;

@Plugin(name="Syslog", category="Core", elementType="appender", printObject=true)
public class SyslogAppender<T extends Serializable>
extends SocketAppender<T> {
    private static final String BSD = "bsd";
    private static final String RFC5424 = "RFC5424";

    protected SyslogAppender(String name, Layout<T> layout, Filter filter, boolean handleException, boolean immediateFlush, AbstractSocketManager manager, Advertiser advertiser) {
        super(name, layout, filter, manager, handleException, immediateFlush, advertiser);
    }

    @PluginFactory
    public static <S extends Serializable> SyslogAppender<S> createAppender(@PluginAttr(value="host") String host, @PluginAttr(value="port") String portNum, @PluginAttr(value="protocol") String protocol, @PluginAttr(value="reconnectionDelay") String delay, @PluginAttr(value="immediateFail") String immediateFail, @PluginAttr(value="name") String name, @PluginAttr(value="immediateFlush") String immediateFlush, @PluginAttr(value="suppressExceptions") String suppress, @PluginAttr(value="facility") String facility, @PluginAttr(value="id") String id, @PluginAttr(value="enterpriseNumber") String ein, @PluginAttr(value="includeMDC") String includeMDC, @PluginAttr(value="mdcId") String mdcId, @PluginAttr(value="mdcPrefix") String mdcPrefix, @PluginAttr(value="eventPrefix") String eventPrefix, @PluginAttr(value="newLine") String includeNL, @PluginAttr(value="newLineEscape") String escapeNL, @PluginAttr(value="appName") String appName, @PluginAttr(value="messageId") String msgId, @PluginAttr(value="mdcExcludes") String excludes, @PluginAttr(value="mdcIncludes") String includes, @PluginAttr(value="mdcRequired") String required, @PluginAttr(value="format") String format, @PluginElement(value="filters") Filter filter, @PluginConfiguration Configuration config, @PluginAttr(value="charset") String charsetName, @PluginAttr(value="exceptionPattern") String exceptionPattern, @PluginElement(value="LoggerFields") LoggerFields loggerFields, @PluginAttr(value="advertise") String advertise) {
        SyslogLayout layout;
        boolean isFlush = Booleans.parseBoolean(immediateFlush, true);
        boolean handleExceptions = Booleans.parseBoolean(suppress, true);
        int reconnectDelay = AbstractAppender.parseInt(delay, 0);
        boolean fail = Booleans.parseBoolean(immediateFail, true);
        int port = AbstractAppender.parseInt(portNum, 0);
        boolean isAdvertise = Boolean.parseBoolean(advertise);
        AbstractStringLayout abstractStringLayout = layout = RFC5424.equalsIgnoreCase(format) ? RFC5424Layout.createLayout(facility, id, ein, includeMDC, mdcId, mdcPrefix, eventPrefix, includeNL, escapeNL, appName, msgId, excludes, includes, required, exceptionPattern, loggerFields, config) : SyslogLayout.createLayout(facility, includeNL, escapeNL, charsetName);
        if (name == null) {
            LOGGER.error("No name provided for SyslogAppender");
            return null;
        }
        String prot = protocol != null ? protocol : Protocol.UDP.name();
        Protocol p = (Protocol)EnglishEnums.valueOf(Protocol.class, (String)protocol);
        AbstractSocketManager manager = SyslogAppender.createSocketManager(p, host, port, reconnectDelay, fail, layout);
        if (manager == null) {
            return null;
        }
        return new SyslogAppender<String>(name, layout, filter, handleExceptions, isFlush, manager, isAdvertise ? config.getAdvertiser() : null);
    }
}

