/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.db.nosql.mongo;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.Mongo;
import com.mongodb.MongoException;
import com.mongodb.WriteConcern;
import com.mongodb.WriteResult;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.appender.db.nosql.NoSQLConnection;
import org.apache.logging.log4j.core.appender.db.nosql.NoSQLObject;
import org.apache.logging.log4j.core.appender.db.nosql.mongo.MongoDBObject;
import org.apache.logging.log4j.status.StatusLogger;

public final class MongoDBConnection
implements NoSQLConnection<BasicDBObject, MongoDBObject> {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final DBCollection collection;
    private final Mongo mongo;
    private final WriteConcern writeConcern;

    public MongoDBConnection(DB database, WriteConcern writeConcern, String collectionName) {
        this.mongo = database.getMongo();
        this.collection = database.getCollection(collectionName);
        this.writeConcern = writeConcern;
    }

    @Override
    public MongoDBObject createObject() {
        return new MongoDBObject();
    }

    public MongoDBObject[] createList(int length) {
        return new MongoDBObject[length];
    }

    @Override
    public void insertObject(NoSQLObject<BasicDBObject> object) {
        try {
            WriteResult result = this.collection.insert((DBObject)object.unwrap(), this.writeConcern);
            if (result.getN() < 1) {
                LOGGER.error("Failed to write log event to MongoDB due to invalid result [{}].", new Object[]{result.getN()});
            }
        }
        catch (MongoException e) {
            LOGGER.error("Failed to write log event to MongoDB due to error.", (Throwable)e);
        }
    }

    @Override
    public void close() {
        this.mongo.close();
    }

    @Override
    public boolean isClosed() {
        return !this.mongo.getConnector().isOpen();
    }
}

