/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rewrite;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.rewrite.RewritePolicy;
import org.apache.logging.log4j.core.config.AppenderControl;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttr;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.helpers.Booleans;

@Plugin(name="Rewrite", category="Core", elementType="appender", printObject=true)
public final class RewriteAppender<T extends Serializable>
extends AbstractAppender<T> {
    private final Configuration config;
    private final ConcurrentMap<String, AppenderControl> appenders = new ConcurrentHashMap<String, AppenderControl>();
    private final RewritePolicy rewritePolicy;
    private final AppenderRef[] appenderRefs;

    private RewriteAppender(String name, Filter filter, boolean handleException, AppenderRef[] appenderRefs, RewritePolicy rewritePolicy, Configuration config) {
        super(name, filter, null, handleException);
        this.config = config;
        this.rewritePolicy = rewritePolicy;
        this.appenderRefs = appenderRefs;
    }

    @Override
    public void start() {
        Map<String, Appender<?>> map = this.config.getAppenders();
        for (AppenderRef ref : this.appenderRefs) {
            String name = ref.getRef();
            Appender<?> appender = map.get(name);
            if (appender != null) {
                Filter filter = appender instanceof AbstractAppender ? ((AbstractAppender)appender).getFilter() : null;
                this.appenders.put(name, new AppenderControl(appender, ref.getLevel(), filter));
                continue;
            }
            LOGGER.error("Appender " + ref + " cannot be located. Reference ignored");
        }
        super.start();
    }

    @Override
    public void stop() {
        super.stop();
    }

    @Override
    public void append(LogEvent event) {
        if (this.rewritePolicy != null) {
            event = this.rewritePolicy.rewrite(event);
        }
        for (AppenderControl control : this.appenders.values()) {
            control.callAppender(event);
        }
    }

    @PluginFactory
    public static <S extends Serializable> RewriteAppender<S> createAppender(@PluginAttr(value="name") String name, @PluginAttr(value="suppressExceptions") String suppress, @PluginElement(value="appender-ref") AppenderRef[] appenderRefs, @PluginConfiguration Configuration config, @PluginElement(value="rewritePolicy") RewritePolicy rewritePolicy, @PluginElement(value="filter") Filter filter) {
        boolean handleExceptions = Booleans.parseBoolean(suppress, true);
        if (name == null) {
            LOGGER.error("No name provided for RewriteAppender");
            return null;
        }
        if (appenderRefs == null) {
            LOGGER.error("No appender references defined for RewriteAppender");
            return null;
        }
        return new RewriteAppender(name, filter, handleExceptions, appenderRefs, rewritePolicy, config);
    }
}

