/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.helpers.Constants;
import org.apache.logging.log4j.core.impl.ThrowableFormatOptions;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;

@Plugin(name="ThrowablePatternConverter", category="Converter")
@ConverterKeys(value={"ex", "throwable", "exception"})
public class ThrowablePatternConverter
extends LogEventPatternConverter {
    protected final ThrowableFormatOptions options;

    protected ThrowablePatternConverter(String name, String style, String[] options) {
        super(name, style);
        this.options = ThrowableFormatOptions.newInstance(options);
    }

    public static ThrowablePatternConverter newInstance(String[] options) {
        return new ThrowablePatternConverter("Throwable", "throwable", options);
    }

    @Override
    public void format(LogEvent event, StringBuilder toAppendTo) {
        Throwable t = event.getThrown();
        if (t != null && this.options.anyLines()) {
            StringWriter w = new StringWriter();
            t.printStackTrace(new PrintWriter(w));
            int len = toAppendTo.length();
            if (len > 0 && !Character.isWhitespace(toAppendTo.charAt(len - 1))) {
                toAppendTo.append(" ");
            }
            if (!this.options.allLines() || !Constants.LINE_SEP.equals(this.options.getSeparator())) {
                StringBuilder sb = new StringBuilder();
                String[] array = w.toString().split(Constants.LINE_SEP);
                int limit = this.options.minLines(array.length) - 1;
                for (int i = 0; i <= limit; ++i) {
                    sb.append(array[i]);
                    if (i >= limit) continue;
                    sb.append(this.options.getSeparator());
                }
                toAppendTo.append(sb.toString());
            } else {
                toAppendTo.append(w.toString());
            }
        }
    }

    @Override
    public boolean handlesThrowable() {
        return true;
    }
}

