#!/bin/bash

if [ "$#" -ne 1 ]
then
  echo "Usage: $0 [milestone]"
  exit 1
fi
BASEDIR=$(dirname $(readlink -f "$0"))
MILESTONE=$1
TAG=jb-edg-6-rhel-6
MAIN_PKG=com.jboss.datagrid-jboss-datagrid-packaging
PKGS="org.jgroups-jgroups org.infinispan-infinispan $MAIN_PKG"

function download() {
    LATEST=`brew latest-pkg $TAG-build $MAIN_PKG|tail -1| cut -f 1 -d' '`
    VERSION=`echo $LATEST | sed -nre "s/.*([0-9]+\.[0-9]+\.[0-9]+).*$/\1/p"`
    RELEASE="$VERSION.$MILESTONE"

    echo "* Downloading JBoss Data Grid $VERSION ($LATEST) to generate $RELEASE"

    mkdir download packages
    cd download
    for i in $PKGS; do
           echo "* $i"
           brew download-build --latestfrom=$TAG-candidate --type=maven $i 2> /dev/null > /dev/null
    done
    cd ..
    find download -name '*.zip' -exec mv {} packages \;
    rm -rf download
    mkdir tmp
    for i in packages/jboss-datagrid-packaging-*; do
        unzip -q -d tmp $i
    done
    cd tmp
    for i in *; do
        zip -9rpmq ../$i.zip $i
    done
    cd ..
    rm -rf tmp
}

function download_natives() {
    echo "* infinispan-cpp-client (Windows)"
    brew download-build --latestfrom=jb-jdg-6-win-candidate --type=win infinispan-cpp-client 2> /dev/null > /dev/null
    unzip -q infinispan-*-WIN-x86_64.zip
    mv infinispan-*-WIN-x86_64 jboss-datagrid-$VERSION-hotrod-cpp-client-WIN-x86_64
    zip -9rpmq jboss-datagrid-$RELEASE-hotrod-cpp-client-WIN-x86_64.zip jboss-datagrid-$VERSION-hotrod-cpp-client-WIN-x86_64
    unzip -q infinispan-*-WIN-i686.zip
    mv infinispan-*-WIN-i686 jboss-datagrid-$VERSION-hotrod-cpp-client-WIN-i686
    zip -9rpmq jboss-datagrid-$RELEASE-hotrod-cpp-client-WIN-i686.zip jboss-datagrid-$VERSION-hotrod-cpp-client-WIN-i686
    mv infinispan-hotrod-dotnet-$VERSION-win64.msi jboss-datagrid-$RELEASE-hotrod-dotnet-client-WIN-x86_64.msi
    
    echo "* infinispan-cpp-client (RHEL6)"
    brew download-build --latestfrom=jb-edg-6-rhel-6-candidate infinispan-cpp-client
    for i in *.el6.x86_64.rpm *.el6.noarch.rpm; do
        rpm2cpio $i | cpio -idm
    done
    mv usr jboss-datagrid-$VERSION-hotrod-cpp-client-RHEL6-x86_64
    pushd jboss-datagrid-$VERSION-hotrod-cpp-client-RHEL6-x86_64
    mv share/doc/infinispan-hotrod-cpp/* .
    rm -rf share
    popd
    zip -9rpmq jboss-datagrid-$RELEASE-hotrod-cpp-client-RHEL6-x86_64.zip jboss-datagrid-$VERSION-hotrod-cpp-client-RHEL6-x86_64
    echo "* infinispan-cpp-client (RHEL5)"
    brew download-build --latestfrom=jb-jdg-6-rhel-5-candidate infinispan-cpp-client
    for i in *.el5.x86_64.rpm *.el5.noarch.rpm; do
        rpm2cpio $i | cpio -idm
    done
    mv usr jboss-datagrid-$VERSION-hotrod-cpp-client-RHEL5-x86_64
    pushd jboss-datagrid-$VERSION-hotrod-cpp-client-RHEL5-x86_64
    mv share/doc/infinispan-hotrod-cpp/* .
    rm -rf share
    popd
    
    zip -9rpmq jboss-datagrid-$RELEASE-hotrod-cpp-client-RHEL5-x86_64.zip jboss-datagrid-$VERSION-hotrod-cpp-client-RHEL5-x86_64
    
    rm -f infinispan-cpp-*.rpm
}

function sources() {
    echo "* Packaging sources..."
    # Sources
    mkdir sources
    rm -f packages/infinispan*-scm-sources.zip
    find packages -name '*-sources.zip' -exec echo "Unpacking sources: {}" \; -exec unzip -q -d sources {} \;
    find packages -name '*-src.zip' -exec echo "Unpacking sources: {}" \; -exec unzip -q -d sources {} \;
    mv sources/JGroups sources/jgroups

    # Remove useless cruft
    find sources -name '.git*' -exec rm -rf {} \; 2> /dev/null

    mv sources jboss-datagrid-$VERSION-sources
    zip -9rpqm jboss-datagrid-$RELEASE-sources.zip jboss-datagrid-$VERSION-sources
    rm -f packages/*-sources.zip
}

function checksums() {
    echo "* Checksumming..."
    for i in *.zip; do 
        md5sum "$i" > "$i.md5"
        sha1sum "$i" > "$i.sha1"
    done
}

function server() {
    echo "* Repackaging server..."
    unzip -q packages/infinispan-server-*-bin.zip
    mv infinispan-server-* jboss-datagrid-$VERSION-server
    zip -9rpmq jboss-datagrid-$RELEASE-server.zip jboss-datagrid-$VERSION-server
    rm -f packages/infinispan-server-*-bin.zip
    echo "* Repackaging remote client..."
    unzip -q packages/infinispan-server-*-remote-client.zip
    mv infinispan-server-*-remote-client jboss-datagrid-$VERSION-remote-client
    zip -9rpmq jboss-datagrid-$RELEASE-remote-client.zip jboss-datagrid-$VERSION-remote-client
}

function mvnrepo() {
    echo "* Generating Maven Repository..."
    unzip -q jboss-datagrid-$VERSION-maven-repository.zip
    pushd jboss-datagrid-$VERSION-maven-repository
    $BASEDIR/repo.sh
    popd
    zip -9rpmq jboss-datagrid-$RELEASE-maven-repository.zip jboss-datagrid-$VERSION-maven-repository
    rm jboss-datagrid-$VERSION-maven-repository.zip
}

function cleanup() {
    echo "* Renaming and cleaning up..."
    $BASEDIR/rename.pl "s/jboss-datagrid-$VERSION-/jboss-datagrid-$RELEASE-/" jboss-datagrid-$VERSION-*.zip
    rm -f jdg-packaging.zip infinispan-hotrod-cpp-* packages
}

# Check Kerberos credentials cache
klist -s
if [ $? -eq 1 ]; then
    kinit
fi

download

download_natives

sources

server

mvnrepo

cleanup

checksums

