#!/usr/bin/python

import argparse

from com.redhat.release.jdg.build.BrewBuilder import *
from com.redhat.release.jdg.configuration.JDGReleaseConfiguration import *
from com.redhat.release.jdg.git.GitRepositoryUpdater import *
from com.redhat.release.jdg.kerberos.KerberosAuthenticator import *
from com.redhat.release.jdg.version.VersionUpdater import *
from com.redhat.release.jdg.build.LocalBuilder import *

def create_release_directory(release_path):
    logging.info("Creating release directory %s", release_path)
    os.system("mkdir -p " + release_path)
    os.chdir(release_path)


# ./release.py --release-name 'JDG_9.9.0.DR1-redhat-1' --upstream-branch-name 'jdg-9.9.x' --working-dir 'test' --releasing-username 'slaskawi' --keytab-file '../krb5.keytab'
def main(argv):
    logging.basicConfig(level=logging.DEBUG)

    parser = argparse.ArgumentParser(description='This script performs JDG release. v. pre pre pre Alpha')
    parser.add_argument('--release-name', dest="release_name", required=True,
                        help='Full name of the release e.g. JDG_6.2.0.DR1-redhat-1')
    parser.add_argument('--upstream-branch-name', dest="upstream_branch_name", required=True,
                        help='Name of the upstream productized branch e.g. jdg-6.4.x')
    parser.add_argument('--working-dir', dest="working_dir", required=True,
                        help='Relative release working directory e.g. release')
    parser.add_argument('--releasing-username', dest="releasing_user", required=True,
                        help='User who does this release e.g. slaskawi')
    parser.add_argument('--keytab-file', dest="keytab_file",
                        help='Kerberos authentication file, use ktutil to create it')
    parser.add_argument('--dry-run', dest="dry_run", help='Dry run? Default True', default=True)

    args = parser.parse_args()

    release_configuration = JDGReleaseConfiguration(args.release_name, args.upstream_branch_name, args.working_dir,
                                                    args.releasing_user, args.keytab_file, args.dry_run)
    version_updater = VersionUpdater(release_configuration)
    git_repository_updater = GitRepositoryUpdater(release_configuration)
    distribution_builder = LocalBuilder(release_configuration)
    brew_builder = BrewBuilder(release_configuration)
    kerberos_authenticator = KerberosAuthenticator(release_configuration)

    kerberos_authenticator.authenticate()

    create_release_directory(release_configuration.get_release_directory())

    git_repository_updater.initialize_repositories()
    git_repository_updater.create_base_tag()
    git_repository_updater.prepare_productized_repo_for_release()
    version_updater.update_version()
    git_repository_updater.commit_versions()
    git_repository_updater.tag_versions()
    distribution_builder.build_locally_jdg()
    distribution_builder.prepare_dependency_information()
    distribution_builder.build_locally_packaging()
    git_repository_updater.push_to_productized_repos()
    brew_builder.upload_dependency_information()
    brew_builder.build_in_brew()
    brew_builder.rebuild_maven_repo()

    success = '''
        __ ____  _____    _____
     __|  |    \|   __|  |_   _|___ ___ _____
    |  |  |  |  |  |  |    | | | -_| .'|     |
    |_____|____/|_____|    |_| |___|__,|_|_|_|

    '''
    logging.info(success)


if __name__ == "__main__":
    main(sys.argv[1:])
