__author__ = 'slaskawi@redhat.com'

import subprocess
import logging
import os

# http://serverfault.com/questions/138572/exporting-user-keytabs-in-mit-kerberos
# Kerberos + forwarding tickets
class KerberosAuthenticator:
    def __init__(self, configuration):
        self._configuration = configuration

    def authenticate(self):
        if self._configuration.get_keytab_file() is not None:
            logging.info("Destroying old ticket (if exists)")
            os.system("kdestroy")
            logging.info("Authenticating using krb file: " + self._configuration.get_keytab_file())
            subprocess.check_call(["kinit",  "-f", self._configuration.get_releasing_username(), "-k", "-t", self._configuration.get_keytab_file()])
