package org.infinispan.cdi.test.interceptor.config;

import org.infinispan.cdi.ConfigureCache;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;

/**
 * @author Kevin Pollet <kevin.pollet@serli.com> (C) 2011 SERLI
 */
public class Config {

   /**
    * <p>Associates the "custom" cache with the qualifier {@link Custom}.</p> <p/> <p>The default configuration will be
    * used.</p>
    */
   @Custom
   @ConfigureCache("custom")
   @Produces
   @SuppressWarnings("unused")
   public Configuration customConfiguration;

   /**
    * <p>Associates the "small" cache with the qualifier {@link Small}.</p> <p/> <p>The default configuration will be
    * used.</p>
    */
   @Small
   @ConfigureCache("small")
   @Produces
   @SuppressWarnings("unused")
   public Configuration smallConfiguration;

   /**
    * Associates the "small" cache with the small cache manager.
    */
   @Small
   @Produces
   @ApplicationScoped
   @SuppressWarnings("unused")
   EmbeddedCacheManager smallCacheManager() {
      GlobalConfiguration globalConfigurationBuilder = new GlobalConfigurationBuilder()
            .globalJmxStatistics()
            .allowDuplicateDomains(true)
            .build();
      ConfigurationBuilder builder = new ConfigurationBuilder();
      builder.eviction().maxEntries(4);

      return new DefaultCacheManager(globalConfigurationBuilder, builder.build());
   }
}
