package org.apache.camel.component.infinispan.spring;

import org.apache.camel.EndpointInject;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.infinispan.InfinispanConstants;
import static org.apache.camel.component.infinispan.InfinispanConstants.KEY;
import static org.apache.camel.component.infinispan.InfinispanConstants.VALUE;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.test.spring.CamelSpringTestSupport;
import org.junit.Test;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class InfinispanLocalConsumerCustomListenerSpringIT extends CamelSpringTestSupport {
    
    @EndpointInject(uri = "mock:result")
    private MockEndpoint mockResult;

    @Override
    protected AbstractApplicationContext createApplicationContext() {
        return new ClassPathXmlApplicationContext("custom-listener-spring.xml");
    }
    
    @Test
    public void createEventConsumed() throws InterruptedException {
        //One for the existing entry and one for the new entry.
        mockResult.expectedMessageCount(2);

        Exchange request = template.request("direct:put",
                    new Processor() {
                        @Override
                        public void process(Exchange exchange) throws Exception {
                            Message in = exchange.getIn();
                            in.setHeader(KEY, "newKey");
                            in.setHeader(VALUE, "newValue");
                        }
                    });
        assertNull(request.getException());
        
        mockResult.message(0).outHeader(InfinispanConstants.IS_PRE).isEqualTo(true);
        mockResult.message(0).outHeader(InfinispanConstants.KEY).isEqualTo("newKey");
        mockResult.message(1).outHeader(InfinispanConstants.IS_PRE).isEqualTo(false);

        mockResult.assertIsSatisfied();
    }
}
