package com.redhat.installer.util;

import org.jboss.as.cli.CommandLineException;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.AbstractUIProcessHandler;
import com.redhat.installer.postinstall.ProcessPanelHelper;
import com.redhat.installer.postinstall.ServerCommands;

public class ServerCommandsHelper {
    private static AutomatedInstallData idata;
    //TODO: probably need to test this value being 0 for bugs
    public static String DEFAULT_TIMEOUT = "0";
    public static String DEFAULT_ATTEMPTS = "5";
    public static int DEFAULT_TIME_TO_SLEEP = 0;
    public static int DEFAULT_CONN_ATTEMPTS = 5;

    public static void connectContext(AbstractUIProcessHandler mHandler,
            ServerCommands serverCommands, int timeToSleep, int attemptLimit)
            throws InterruptedException {
        idata = AutomatedInstallData.getInstance();

        int attempts = 0;
        String connectSuccess = idata.langpack
                .getString("postinstall.processpanel.management.connectSuccess");
        String connectFail = idata.langpack
                .getString("postinstall.processpanel.management.connectFail");
        String connectAttempt = idata.langpack
                .getString("postinstall.processpanel.management.connecting");

        while (attempts < attemptLimit) {
            if (mHandler != null)
                ProcessPanelHelper.printToPanel(mHandler, String.format(connectAttempt, attempts + 1,
                        attemptLimit), false);
            try {
                // sleep first, to give the server some time
                Thread.sleep(timeToSleep * 1000);
                serverCommands.connectContext();
            } catch (CommandLineException e) {
                // We did not successfully connect, so try again after waiting,
                // but only
                // if we have attempts left.
                attempts++;
                if (attempts >= attemptLimit) {
                    if (mHandler != null)
                        ProcessPanelHelper.printToPanel(mHandler, 
                                String.format(connectFail, attempts), false);
                    // e.printStackTrace();
                    return;
                }
                continue;
            }
            // If there is no exception, we've connected to the management
            // interface.
            if (mHandler != null)
                ProcessPanelHelper.printToPanel(mHandler, connectSuccess, false);
            // TODO: paramaterize the /jboss-eap-6.1/bin/ part of the location
            // of the jboss-cli-logging.properties.
            // We have successfully connected to the management interface.
            break;
        }
    }

	public static void connectContext(AbstractUIProcessHandler mHandler, ServerCommands serverCommands) throws InterruptedException {
        idata = AutomatedInstallData.getInstance();
		int timeToSleep = Integer.parseInt(DEFAULT_TIMEOUT);
		int attemptLimit = Integer.parseInt(DEFAULT_ATTEMPTS);

        connectContext(mHandler, serverCommands, timeToSleep, attemptLimit);
	}


}
