package com.redhat.installer.validator;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.DataValidator;
import com.redhat.installer.util.ValidatorConstants;


/** Verify that you can layer this product on the given EAP Installation
 * Requirements as per: https://docspace.corp.redhat.com/docs/DOC-146624
 * ==============
 * Pre-Requisite
 * =============
 * 1) Ensure the the EAPExistsValidation has passed
 *    => This will set ValidatorConstants.existingLayers && ValidatorConstants.existingProduct
 *    
 * @author thauser
 */
public class IsSupportedPlatformValidator implements DataValidator 
{
	String error;
	public Status validateData(AutomatedInstallData idata) 
	{
		String existingProduct = idata.getVariable(ValidatorConstants.existingProduct);
		String existingLayers = idata.getVariable(ValidatorConstants.existingLayers);
		String newLayers = idata.getVariable(ValidatorConstants.newLayers); 					//[new.layers.conf]
		String productReadableName = idata.getVariable(ValidatorConstants.productReadableName); //[new.product.conf]
		/* For Testing
		System.out.println("Existing Product    :: " + existingProduct);
		System.out.println("Existing Layers     :: " + existingLayers);
		System.out.println("New Layers          :: " + newLayers);
		System.out.println("ProductReadableName :: " + productReadableName);
		*/
		

		
	    /** Check to see what layer you are adding */ //TODO: Add ability to check for multiple layer installations
		boolean isSoaInstall   = newLayers.equals(ValidatorConstants.soa);
		boolean isEdsInstall   = newLayers.equals(ValidatorConstants.dv);
		boolean isBrmsInstall  = newLayers.equals(ValidatorConstants.brms);
		boolean isBpmsInstall  = newLayers.equals(ValidatorConstants.bpms);
		boolean isSrampInstall = newLayers.equals(ValidatorConstants.sramp);
	
		/** Product.conf contains EAP */
		if (existingProduct.equals(ValidatorConstants.eap))
		{ 	     
			/** EAP */
			if (existingLayers.trim().isEmpty()) 
			{     
				return Status.OK;
			} 
			/** EAP + DV */
			else if (existingLayers.equals(ValidatorConstants.dv))  
			{
				/** Only BRMS can be installed ontop of EAP + DV */
				if (!isBrmsInstall) 
				{
					setError(productReadableName + " cannot be layered with EAP and DV.");
					return Status.ERROR;
				} 
				else
				{
					return Status.OK;
				}
			} 
			/** Unsupported Configuration */
			else 
			{
				setError("The installation has an unsupported layers configuration. Check the layers.conf file.");
				return Status.ERROR;
			}
		} 
		
		/** Product.conf contains FSW */
		else if (existingProduct.equals(ValidatorConstants.soa))
		{	   
			/** EAP + FSW */
			if (existingLayers.equals(ValidatorConstants.soa))
			{		    
				if (!isSoaInstall)
				{
					return Status.OK; 
				}
				else
				{
					setError(productReadableName + " cannot be layered with EAP and FSW.");
					return Status.ERROR;
				}
			} 
			/** EAP + FSW + DV */
			else if (existingLayers.equals(ValidatorConstants.soaEds))
			{ 
				/** Only BRMS can be installed ontop of this configuration */
				if (isBrmsInstall) 
				{ 
					return Status.OK; 
				}
				setError(productReadableName + " cannot be layered with EAP, FSW, and DV.");
				return Status.ERROR;
				
			} 
			/** EAP + FSW + BRMS [Nothing can install on-top of this] */
			else if (existingLayers.equals(ValidatorConstants.soaBrms))
			{
				setError(productReadableName + " cannot be layered with EAP, FSW, and BRMS");
				return Status.ERROR;
			}
			
			/** EAP + FSW + DV + BRMS  [Nothing can install on-top of this] */
			else if (existingLayers.equals(ValidatorConstants.soaBrmsEds))
			{
				setError(productReadableName + " cannot be layered with EAP, FSW, DV, and BRMS.");
				return Status.ERROR;	
			} 
			
			/** EAP + FSW + BPMS  [Nothing can install on-top of this] */
			else if (existingLayers.equals(ValidatorConstants.soaBpms))
			{
				setError(productReadableName + " cannot be layered with EAP, FSW, and BPMS");
				return Status.ERROR;
			} 
			
			/** EAP + FSW + S-RAMP */
			else if (existingLayers.equals(ValidatorConstants.soaSramp))
			{
				if (isEdsInstall || isBrmsInstall || isBpmsInstall)
				{
					return Status.OK; 
				}
				else
				{
					setError(productReadableName + " cannot be layered with EAP, FSW, and S-RAMP");
					return Status.ERROR;
				}
			}
			/** EAP + FSW + S-RAMP + DV */
			else if (existingLayers.equals(ValidatorConstants.soaSrampEds))
			{
				if (isBrmsInstall || isBpmsInstall)
				{
					return Status.OK; 
				}
				else
				{
					setError(productReadableName + " cannot be layered with EAP, FSW, S-RAMP, and DV");
					return Status.ERROR;
				}
			}
			/** EAP + FSW + S-RAMP + BRMS */
			else if (existingLayers.equals(ValidatorConstants.soaSrampBrms))
			{
				setError(productReadableName + " cannot be layered with EAP, FSW, S-RAMP, and BRMS");
				return Status.ERROR;
			}
			/** EAP + FSW + S-RAMP + DV + BRMS */
			else if (existingLayers.equals(ValidatorConstants.soaSrampBrmsEds))
			{
				setError(productReadableName + " cannot be layered with EAP, FSW, S-RAMP, DV, and BRMS");
				return Status.ERROR;
			}
			/** EAP + FSW + S-RAMP + BPMS */
			else if (existingLayers.equals(ValidatorConstants.soaSrampBpms))
			{
				setError(productReadableName + " cannot be layered with EAP, FSW, S-RAMP, and BPMS");
				return Status.ERROR;
			}
			
			else 
			{
				setError("The installation has an unsupported layers configuration. Check the layers.conf file.");
				return Status.ERROR;
			}
		}
		/** Product.conf contains BRMS */
		else if (existingProduct.equals(ValidatorConstants.brms))
		{ 	
			/** EAP + BRMS */
			if (existingLayers.equals(ValidatorConstants.brms)) 
			{
				if (!isSrampInstall) 
				{
					setError(productReadableName + " cannot be layered with EAP and BRMS.");
					return Status.ERROR;
				} 
				else 
				{
					return Status.OK; // soa, and eds are allowed. TODO: what about other combos? hm
				}
			} 
			/** EAP + DV + BRMS */
			else if (existingLayers.equals(ValidatorConstants.brmsEds))
			{
				setError(productReadableName + " cannot be layered with EAP, DV, and BRMS");
				return Status.ERROR;
			} 
			/** EAP + BRMS + S-RAMP **/
			else if (existingLayers.equals(ValidatorConstants.srampBrms))
			{
				setError(productReadableName + " cannot be layered with EAP, BRMS, and SRAMP");
				return Status.ERROR;
			} 
			else if (existingLayers.equals(ValidatorConstants.srampBrmsEds))
			{
				setError(productReadableName + " cannot be layered with EAP, BRMS, DV, and SRAMP");
				return Status.ERROR;
			}
			else 
			{
				setError("The installation has an unsupported layers configuration. Check the layers.conf file.");
				return Status.ERROR;
			}
		} 
		/** Product.conf contains BPMS */
		else if (existingProduct.equals(ValidatorConstants.bpms))
		{
			/** EAP + BPMS */
			if (existingLayers.equals(ValidatorConstants.bpms))
			{
				if (isSrampInstall || isEdsInstall)
				{
					return Status.OK;
				} 
				else 
				{
					setError(productReadableName + " cannot be layered with EAP and BPMS");
					return Status.ERROR;
				}
			} 
			/** EAP + BPMS + S-RAMP */
			else if (existingLayers.equals(ValidatorConstants.srampBpms))
			{
				setError(productReadableName + " cannot be layered with EAP, BPMS, and SRAMP");
				return Status.ERROR;
			} 
			/** EAP + BPMS + DV */
			else if (existingLayers.equals(ValidatorConstants.bpmsEds))
			{
				if (!isSrampInstall)
				{
					setError(productReadableName + " cannot be layered with EAP, BPMS, and DV");
					return Status.ERROR;
				}
				else
				{
					return Status.OK;
				}
			} 
			/** EAP + BPMS + DV + S-RAMP*/
			else if (existingLayers.equals(ValidatorConstants.srampBpmsEds))
			{
				setError(productReadableName + " cannot be layered with EAP, BPMS, DV, and SRAMP");
				return Status.ERROR;
			} 
			else
			{
				setError("The installation has an unsupported layers configuration. Check the layers.conf file.");
				return Status.ERROR;
			}
		} 
		/** Product.conf contains SRAMP */
		else if (existingProduct.equals(ValidatorConstants.sramp))
		{
			/** EAP + S-RAMP */
			if (existingLayers.equals(ValidatorConstants.sramp))
			{
				setError(productReadableName + " cannot be layered with EAP and S-RAMP");
				return Status.ERROR;
			}
			else
			{
				setError("The installation has an unsupported layers configuration. Check the layers.conf file.");
				return Status.ERROR;
			}
		} 
		else 
		{
			setError("The installation has an unsupported product configuration. Check the product.conf file.");
			return Status.ERROR;
		}
	}

	private void setError(String string) {
		error = string;
	}

	public String getErrorMessageId() {
		// TODO Auto-generated method stub
		return error;
	}

	public String getWarningMessageId() {
		// TODO Auto-generated method stub
		return null;
	}

	public boolean getDefaultAnswer() {
		// TODO Auto-generated method stub
		return false;
	}

}
