/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import org.h2.engine.Mode;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.Function;
import org.h2.expression.ValueExpression;
import org.h2.message.DbException;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.util.MathUtils;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueInt;
import org.h2.value.ValueNull;
import org.h2.value.ValueString;

public class Operation
extends Expression {
    public static final int CONCAT = 0;
    public static final int PLUS = 1;
    public static final int MINUS = 2;
    public static final int MULTIPLY = 3;
    public static final int DIVIDE = 4;
    public static final int NEGATE = 5;
    public static final int MODULUS = 6;
    private int opType;
    private Expression left;
    private Expression right;
    private int dataType;
    private boolean convertRight = true;

    public Operation(int n, Expression expression, Expression expression2) {
        this.opType = n;
        this.left = expression;
        this.right = expression2;
    }

    public String getSQL() {
        String string = this.opType == 5 ? "- " + this.left.getSQL() : this.left.getSQL() + " " + this.getOperationToken() + " " + this.right.getSQL();
        return "(" + string + ")";
    }

    private String getOperationToken() {
        switch (this.opType) {
            case 5: {
                return "-";
            }
            case 0: {
                return "||";
            }
            case 1: {
                return "+";
            }
            case 2: {
                return "-";
            }
            case 3: {
                return "*";
            }
            case 4: {
                return "/";
            }
            case 6: {
                return "%";
            }
        }
        throw DbException.throwInternalError("opType=" + this.opType);
    }

    public Value getValue(Session session) {
        Value value;
        Value value2 = this.left.getValue(session).convertTo(this.dataType);
        if (this.right == null) {
            value = null;
        } else {
            value = this.right.getValue(session);
            if (this.convertRight) {
                value = value.convertTo(this.dataType);
            }
        }
        switch (this.opType) {
            case 5: {
                return value2 == ValueNull.INSTANCE ? value2 : value2.negate();
            }
            case 0: {
                Mode mode = session.getDatabase().getMode();
                if (value2 == ValueNull.INSTANCE) {
                    if (mode.nullConcatIsNull) {
                        return ValueNull.INSTANCE;
                    }
                    return value;
                }
                if (value == ValueNull.INSTANCE) {
                    if (mode.nullConcatIsNull) {
                        return ValueNull.INSTANCE;
                    }
                    return value2;
                }
                String string = value2.getString();
                String string2 = value.getString();
                StringBuilder stringBuilder = new StringBuilder(string.length() + string2.length());
                stringBuilder.append(string).append(string2);
                return ValueString.get(stringBuilder.toString());
            }
            case 1: {
                if (value2 == ValueNull.INSTANCE || value == ValueNull.INSTANCE) {
                    return ValueNull.INSTANCE;
                }
                return value2.add(value);
            }
            case 2: {
                if (value2 == ValueNull.INSTANCE || value == ValueNull.INSTANCE) {
                    return ValueNull.INSTANCE;
                }
                return value2.subtract(value);
            }
            case 3: {
                if (value2 == ValueNull.INSTANCE || value == ValueNull.INSTANCE) {
                    return ValueNull.INSTANCE;
                }
                return value2.multiply(value);
            }
            case 4: {
                if (value2 == ValueNull.INSTANCE || value == ValueNull.INSTANCE) {
                    return ValueNull.INSTANCE;
                }
                return value2.divide(value);
            }
            case 6: {
                if (value2 == ValueNull.INSTANCE || value == ValueNull.INSTANCE) {
                    return ValueNull.INSTANCE;
                }
                return value2.modulus(value);
            }
        }
        throw DbException.throwInternalError("type=" + this.opType);
    }

    public void mapColumns(ColumnResolver columnResolver, int n) {
        this.left.mapColumns(columnResolver, n);
        if (this.right != null) {
            this.right.mapColumns(columnResolver, n);
        }
    }

    public Expression optimize(Session session) {
        this.left = this.left.optimize(session);
        switch (this.opType) {
            case 5: {
                this.dataType = this.left.getType();
                if (this.dataType != -1) break;
                this.dataType = 6;
                break;
            }
            case 0: {
                this.right = this.right.optimize(session);
                this.dataType = 13;
                if (!this.left.isConstant() || !this.right.isConstant()) break;
                return ValueExpression.get(this.getValue(session));
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                this.right = this.right.optimize(session);
                int n = this.left.getType();
                int n2 = this.right.getType();
                if (n == 0 && n2 == 0 || n == -1 && n2 == -1) {
                    if (this.opType == 1 && session.getDatabase().getMode().allowPlusForStringConcat) {
                        this.dataType = 13;
                        this.opType = 0;
                        break;
                    }
                    this.dataType = 6;
                    break;
                }
                if (n == 10 || n == 11 || n == 9 || n2 == 10 || n2 == 11 || n2 == 9) {
                    if (this.opType == 1) {
                        if (n2 != Value.getHigherOrder(n, n2)) {
                            this.swap();
                            int n3 = n;
                            n = n2;
                            n2 = n3;
                        }
                        if (n == 4) {
                            Function function = Function.getFunction(session.getDatabase(), "DATEADD");
                            function.setParameter(0, ValueExpression.get(ValueString.get("DAY")));
                            function.setParameter(1, this.left);
                            function.setParameter(2, this.right);
                            function.doneWithParameters();
                            return function.optimize(session);
                        }
                        if (n == 6 || n == 8 || n == 7) {
                            Function function = Function.getFunction(session.getDatabase(), "DATEADD");
                            function.setParameter(0, ValueExpression.get(ValueString.get("SECOND")));
                            this.left = new Operation(3, ValueExpression.get(ValueInt.get(86400)), this.left);
                            function.setParameter(1, this.left);
                            function.setParameter(2, this.right);
                            function.doneWithParameters();
                            return function.optimize(session);
                        }
                        if (n == 9 && n2 == 9) {
                            this.dataType = 9;
                            return this;
                        }
                        if (n == 9) {
                            this.dataType = 11;
                            return this;
                        }
                    } else if (this.opType == 2) {
                        if ((n == 10 || n == 11) && n2 == 4) {
                            Function function = Function.getFunction(session.getDatabase(), "DATEADD");
                            function.setParameter(0, ValueExpression.get(ValueString.get("DAY")));
                            this.right = new Operation(5, this.right, null);
                            this.right = this.right.optimize(session);
                            function.setParameter(1, this.right);
                            function.setParameter(2, this.left);
                            function.doneWithParameters();
                            return function.optimize(session);
                        }
                        if (!(n != 10 && n != 11 || n2 != 6 && n2 != 8 && n2 != 7)) {
                            Function function = Function.getFunction(session.getDatabase(), "DATEADD");
                            function.setParameter(0, ValueExpression.get(ValueString.get("SECOND")));
                            this.right = new Operation(3, ValueExpression.get(ValueInt.get(86400)), this.right);
                            this.right = new Operation(5, this.right, null);
                            this.right = this.right.optimize(session);
                            function.setParameter(1, this.right);
                            function.setParameter(2, this.left);
                            function.doneWithParameters();
                            return function.optimize(session);
                        }
                        if (n == 10 || n == 11) {
                            if (n2 == 9) {
                                this.dataType = 11;
                                return this;
                            }
                            if (n2 == 10 || n2 == 11) {
                                Function function = Function.getFunction(session.getDatabase(), "DATEDIFF");
                                function.setParameter(0, ValueExpression.get(ValueString.get("DAY")));
                                function.setParameter(1, this.right);
                                function.setParameter(2, this.left);
                                function.doneWithParameters();
                                return function.optimize(session);
                            }
                        } else if (n == 9 && n2 == 9) {
                            this.dataType = 9;
                            return this;
                        }
                    } else if (this.opType == 3) {
                        if (n == 9) {
                            this.dataType = 9;
                            this.convertRight = false;
                            return this;
                        }
                        if (n2 == 9) {
                            this.swap();
                            this.dataType = 9;
                            this.convertRight = false;
                            return this;
                        }
                    } else if (this.opType == 4 && n == 9) {
                        this.dataType = 9;
                        this.convertRight = false;
                        return this;
                    }
                    throw DbException.getUnsupportedException(DataType.getDataType((int)n).name + " " + this.getOperationToken() + " " + DataType.getDataType((int)n2).name);
                }
                this.dataType = Value.getHigherOrder(n, n2);
                if (!DataType.isStringType(this.dataType) || !session.getDatabase().getMode().allowPlusForStringConcat) break;
                this.opType = 0;
                break;
            }
            default: {
                DbException.throwInternalError("type=" + this.opType);
            }
        }
        if (this.left.isConstant() && (this.right == null || this.right.isConstant())) {
            return ValueExpression.get(this.getValue(session));
        }
        return this;
    }

    private void swap() {
        Expression expression = this.left;
        this.left = this.right;
        this.right = expression;
    }

    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        this.left.setEvaluatable(tableFilter, bl);
        if (this.right != null) {
            this.right.setEvaluatable(tableFilter, bl);
        }
    }

    public int getType() {
        return this.dataType;
    }

    public long getPrecision() {
        if (this.right != null) {
            switch (this.opType) {
                case 0: {
                    return this.left.getPrecision() + this.right.getPrecision();
                }
            }
            return Math.max(this.left.getPrecision(), this.right.getPrecision());
        }
        return this.left.getPrecision();
    }

    public int getDisplaySize() {
        if (this.right != null) {
            switch (this.opType) {
                case 0: {
                    return MathUtils.convertLongToInt((long)this.left.getDisplaySize() + (long)this.right.getDisplaySize());
                }
            }
            return Math.max(this.left.getDisplaySize(), this.right.getDisplaySize());
        }
        return this.left.getDisplaySize();
    }

    public int getScale() {
        if (this.right != null) {
            return Math.max(this.left.getScale(), this.right.getScale());
        }
        return this.left.getScale();
    }

    public void updateAggregate(Session session) {
        this.left.updateAggregate(session);
        if (this.right != null) {
            this.right.updateAggregate(session);
        }
    }

    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        return this.left.isEverything(expressionVisitor) && (this.right == null || this.right.isEverything(expressionVisitor));
    }

    public int getCost() {
        return this.left.getCost() + 1 + (this.right == null ? 0 : this.right.getCost());
    }
}

