/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.console.client.teiid.runtime;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.inject.Inject;
import com.google.web.bindery.event.shared.Event;
import com.google.web.bindery.event.shared.EventBus;
import com.gwtplatform.mvp.client.Presenter;
import com.gwtplatform.mvp.client.View;
import com.gwtplatform.mvp.client.annotations.NameToken;
import com.gwtplatform.mvp.client.annotations.ProxyCodeSplit;
import com.gwtplatform.mvp.client.proxy.Place;
import com.gwtplatform.mvp.client.proxy.Proxy;
import java.util.List;
import org.jboss.as.console.client.Console;
import org.jboss.as.console.client.domain.model.ServerInstance;
import org.jboss.as.console.client.domain.model.SimpleCallback;
import org.jboss.as.console.client.shared.BeanFactory;
import org.jboss.as.console.client.shared.runtime.RuntimeBaseAddress;
import org.jboss.as.console.client.shared.state.GlobalServerSelection;
import org.jboss.as.console.client.shared.subsys.RevealStrategy;
import org.jboss.as.console.client.teiid.model.CacheStatistics;
import org.jboss.as.console.client.teiid.model.DataModelFactory;
import org.jboss.as.console.client.teiid.model.MaterializedView;
import org.jboss.as.console.client.teiid.model.Model;
import org.jboss.as.console.client.teiid.model.Request;
import org.jboss.as.console.client.teiid.model.Session;
import org.jboss.as.console.client.teiid.model.VDB;
import org.jboss.as.console.client.teiid.model.ValidityError;
import org.jboss.as.console.client.widgets.forms.ApplicationMetaData;
import org.jboss.as.console.client.widgets.forms.EntityAdapter;
import org.jboss.as.console.spi.AccessControl;
import org.jboss.as.console.spi.RuntimeExtension;
import org.jboss.dmr.client.ModelNode;
import org.jboss.dmr.client.dispatch.Action;
import org.jboss.dmr.client.dispatch.DispatchAsync;
import org.jboss.dmr.client.dispatch.impl.DMRAction;
import org.jboss.dmr.client.dispatch.impl.DMRResponse;

public class VDBPresenter
extends Presenter<MyView, MyProxy>
implements GlobalServerSelection.ServerSelectionListener {
    private DispatchAsync dispatcher;
    private RevealStrategy revealStrategy;
    private ServerInstance serverSelection;
    private DataModelFactory factory;
    private EntityAdapter<VDB> vdbAdaptor;
    private EntityAdapter<Request> requestAdaptor;
    private EntityAdapter<Session> sessionAdaptor;
    private EntityAdapter<MaterializedView> matViewAdaptor;
    private EntityAdapter<CacheStatistics> cacheAdaptor;

    @Inject
    public VDBPresenter(EventBus eventBus, MyView view, MyProxy proxy, DispatchAsync dispatcher, ApplicationMetaData metaData, RevealStrategy revealStrategy, BeanFactory factory) {
        super(eventBus, (View)view, (Proxy)proxy);
        this.dispatcher = dispatcher;
        this.revealStrategy = revealStrategy;
        this.factory = (DataModelFactory)factory;
        this.vdbAdaptor = new EntityAdapter(VDB.class, metaData);
        this.requestAdaptor = new EntityAdapter(Request.class, metaData);
        this.sessionAdaptor = new EntityAdapter(Session.class, metaData);
        this.matViewAdaptor = new EntityAdapter(MaterializedView.class, metaData);
        this.cacheAdaptor = new EntityAdapter(CacheStatistics.class, metaData);
    }

    protected void onBind() {
        super.onBind();
        ((MyView)this.getView()).setPresenter(this);
        ((MyView)this.getView()).setDataModelFactory(this.factory);
        this.getEventBus().addHandler((Event.Type)GlobalServerSelection.TYPE, (Object)this);
    }

    protected void onReset() {
        super.onReset();
        if (this.isVisible()) {
            this.refresh(true);
        }
    }

    protected void onReveal() {
        super.onReveal();
    }

    public void onServerSelection(ServerInstance server) {
        this.serverSelection = server;
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                VDBPresenter.this.refresh(true);
            }
        });
    }

    protected void revealInParent() {
        this.revealStrategy.revealInRuntimeParent((Presenter)this);
    }

    public void refresh(boolean paging) {
        if (!this.isServerActive()) {
            Console.warning((String)Console.CONSTANTS.common_err_server_not_active());
            ((MyView)this.getView()).setDeployedVDBs(null);
            return;
        }
        ModelNode address = RuntimeBaseAddress.get();
        address.add("subsystem", "teiid");
        ModelNode operation = new ModelNode();
        operation.get("operation").set("list-vdbs");
        operation.get("address").set(address);
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new SimpleCallback<DMRResponse>(){

            public void onSuccess(DMRResponse result) {
                ModelNode response = result.get();
                if (response.get("result").isDefined()) {
                    List vdbs = VDBPresenter.this.vdbAdaptor.fromDMRList(response.get("result").asList());
                    for (VDB vdb : vdbs) {
                        boolean valid = true;
                        for (Model m : vdb.getModels()) {
                            if (m.getValidityErrors().isEmpty()) continue;
                            for (ValidityError ve : m.getValidityErrors()) {
                                if (!ve.getSeverity().equals("ERROR")) continue;
                                valid = false;
                            }
                        }
                        vdb.setValid(valid);
                    }
                    ((MyView)VDBPresenter.this.getView()).setDeployedVDBs(vdbs);
                }
            }
        });
    }

    public void removeRoleName(final String vdbName, final int version, String dataRole, final String mappedRole) {
        if (!this.isServerActive()) {
            Console.warning((String)Console.CONSTANTS.common_err_server_not_active());
            return;
        }
        ModelNode address = RuntimeBaseAddress.get();
        address.add("subsystem", "teiid");
        ModelNode operation = new ModelNode();
        operation.get("operation").set("remove-data-role");
        operation.get("address").set(address);
        operation.get("vdb-name").set(new ModelNode().set(vdbName));
        operation.get("vdb-version").set(new ModelNode().set(version));
        operation.get("data-role").set(new ModelNode().set(dataRole));
        operation.get("mapped-role").set(new ModelNode().set(mappedRole));
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new SimpleCallback<DMRResponse>(){

            public void onSuccess(DMRResponse result) {
                Console.info((String)(mappedRole + " role removed from VDB " + vdbName + "." + version));
            }
        });
    }

    public void addRoleName(final String vdbName, final int version, String dataRole, final String mappedRole) {
        if (!this.isServerActive()) {
            Console.warning((String)Console.CONSTANTS.common_err_server_not_active());
            return;
        }
        ModelNode address = RuntimeBaseAddress.get();
        address.add("subsystem", "teiid");
        ModelNode operation = new ModelNode();
        operation.get("operation").set("add-data-role");
        operation.get("address").set(address);
        operation.get("vdb-name").set(new ModelNode().set(vdbName));
        operation.get("vdb-version").set(new ModelNode().set(version));
        operation.get("data-role").set(new ModelNode().set(dataRole));
        operation.get("mapped-role").set(new ModelNode().set(mappedRole));
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new SimpleCallback<DMRResponse>(){

            public void onSuccess(DMRResponse result) {
                Console.info((String)(mappedRole + " role added to VDB " + vdbName + "." + version));
            }
        });
    }

    public void getRequests(String vdbName, int version, boolean includeSourceQueries) {
        if (!this.isServerActive()) {
            ((MyView)this.getView()).setVDBRequests(null);
        }
        ModelNode address = RuntimeBaseAddress.get();
        address.add("subsystem", "teiid");
        ModelNode operation = new ModelNode();
        operation.get("operation").set("list-requests-per-vdb");
        operation.get("address").set(address);
        operation.get("vdb-name").set(new ModelNode().set(vdbName));
        operation.get("vdb-version").set(new ModelNode().set(version));
        operation.get("include-source").set(new ModelNode().set(includeSourceQueries));
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new SimpleCallback<DMRResponse>(){

            public void onSuccess(DMRResponse result) {
                ModelNode response = result.get();
                if (response.get("result").isDefined()) {
                    List requests = VDBPresenter.this.requestAdaptor.fromDMRList(response.get("result").asList());
                    ((MyView)VDBPresenter.this.getView()).setVDBRequests(requests);
                } else {
                    ((MyView)VDBPresenter.this.getView()).setVDBRequests(null);
                }
            }
        });
    }

    public void getQueryPlan(Request request) {
        if (!this.isServerActive()) {
            ((MyView)this.getView()).setQueryPlan("No Server Found");
        }
        ModelNode address = RuntimeBaseAddress.get();
        address.add("subsystem", "teiid");
        ModelNode operation = new ModelNode();
        operation.get("operation").set("get-query-plan");
        operation.get("address").set(address);
        operation.get("session").set(new ModelNode().set(request.getSessionId()));
        operation.get("execution-id").set(new ModelNode().set(request.getExecutionId()));
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new SimpleCallback<DMRResponse>(){

            public void onSuccess(DMRResponse result) {
                ModelNode response = result.get();
                String plan = null;
                if (response.get("result").isDefined()) {
                    plan = response.get("result").asString();
                }
                if (plan != null && !plan.trim().isEmpty()) {
                    ((MyView)VDBPresenter.this.getView()).setQueryPlan(plan);
                } else {
                    ((MyView)VDBPresenter.this.getView()).setQueryPlan("<node name=\"query\"><property name=\"noplan\">No Plan found, query might have finished executing!</property></node>");
                }
            }
        });
    }

    public void cancelRequest(final Request request) {
        if (!this.isServerActive()) {
            ((MyView)this.getView()).cancelSubmitted(request);
        }
        ModelNode address = RuntimeBaseAddress.get();
        address.add("subsystem", "teiid");
        ModelNode operation = new ModelNode();
        operation.get("operation").set("cancel-request");
        operation.get("address").set(address);
        operation.get("session").set(new ModelNode().set(request.getSessionId()));
        operation.get("execution-id").set(new ModelNode().set(request.getExecutionId()));
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new SimpleCallback<DMRResponse>(){

            public void onSuccess(DMRResponse result) {
                ModelNode response = result.get();
                if (response.get("result").isDefined()) {
                    ((MyView)VDBPresenter.this.getView()).cancelSubmitted(request);
                    Console.info((String)("Query Cancel Submitted. Session Id:" + request.getSessionId() + ", Execution Id:" + request.getExecutionId()));
                } else {
                    ((MyView)VDBPresenter.this.getView()).cancelSubmitted(null);
                }
            }
        });
    }

    public void getSchema(String vdbName, int version, String modelName) {
        if (!this.isServerActive()) {
            ((MyView)this.getView()).setModelSchema("No Active Server Found");
        }
        ModelNode address = RuntimeBaseAddress.get();
        address.add("subsystem", "teiid");
        ModelNode operation = new ModelNode();
        operation.get("operation").set("get-schema");
        operation.get("address").set(address);
        operation.get("vdb-name").set(new ModelNode().set(vdbName));
        operation.get("vdb-version").set(new ModelNode().set(version));
        operation.get("model-name").set(new ModelNode().set(modelName));
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new SimpleCallback<DMRResponse>(){

            public void onSuccess(DMRResponse result) {
                ModelNode response = result.get();
                if (response.get("result").isDefined()) {
                    ((MyView)VDBPresenter.this.getView()).setModelSchema(response.get("result").asString());
                } else {
                    ((MyView)VDBPresenter.this.getView()).setModelSchema(null);
                }
            }
        });
    }

    public void getSessions(final String vdbName, final int version) {
        if (!this.isServerActive()) {
            ((MyView)this.getView()).setVDBRequests(null);
        }
        ModelNode address = RuntimeBaseAddress.get();
        address.add("subsystem", "teiid");
        ModelNode operation = new ModelNode();
        operation.get("operation").set("list-sessions");
        operation.get("address").set(address);
        operation.get("vdb-name").set(new ModelNode().set(vdbName));
        operation.get("vdb-version").set(new ModelNode().set(version));
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new SimpleCallback<DMRResponse>(){

            public void onSuccess(DMRResponse result) {
                ModelNode response = result.get();
                if (response.get("result").isDefined()) {
                    List sessions = VDBPresenter.this.sessionAdaptor.fromDMRList(response.get("result").asList());
                    ((MyView)VDBPresenter.this.getView()).setVDBSessions(vdbName, version, sessions);
                } else {
                    ((MyView)VDBPresenter.this.getView()).setVDBRequests(null);
                }
            }
        });
    }

    public void terminateSession(final Session session) {
        if (!this.isServerActive()) {
            ((MyView)this.getView()).terminateSessionSubmitted(session);
        }
        ModelNode address = RuntimeBaseAddress.get();
        address.add("subsystem", "teiid");
        ModelNode operation = new ModelNode();
        operation.get("operation").set("terminate-session");
        operation.get("address").set(address);
        operation.get("session").set(new ModelNode().set(session.getSessionId()));
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new SimpleCallback<DMRResponse>(){

            public void onSuccess(DMRResponse result) {
                ModelNode response = result.get();
                if (response.get("result").isDefined()) {
                    ((MyView)VDBPresenter.this.getView()).terminateSessionSubmitted(session);
                    Console.info((String)("Terminate Session Submitted. Session Id:" + session.getSessionId()));
                } else {
                    ((MyView)VDBPresenter.this.getView()).terminateSessionSubmitted(null);
                }
            }
        });
    }

    public <T> void executeQuery(String vdbName, int version, String sql, final String clazz) {
        if (!this.isServerActive()) {
            ((MyView)this.getView()).setQueryResults(null, clazz);
        }
        ModelNode address = RuntimeBaseAddress.get();
        address.add("subsystem", "teiid");
        ModelNode operation = new ModelNode();
        operation.get("operation").set("execute-query");
        operation.get("address").set(address);
        operation.get("vdb-name").set(new ModelNode().set(vdbName));
        operation.get("vdb-version").set(new ModelNode().set(version));
        operation.get("sql-query").set(new ModelNode().set(sql));
        operation.get("timeout-in-milli").set(new ModelNode().set(-1));
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new SimpleCallback<DMRResponse>(){

            public void onSuccess(DMRResponse result) {
                ModelNode response = result.get();
                if (response.get("result").isDefined()) {
                    if (VDBPresenter.this.getEntityAdapter(clazz) != null) {
                        ((MyView)VDBPresenter.this.getView()).setQueryResults(VDBPresenter.this.matViewAdaptor.fromDMRList(response.get("result").asList()), clazz);
                    } else {
                        ((MyView)VDBPresenter.this.getView()).setQueryResults(null, clazz);
                    }
                } else {
                    ((MyView)VDBPresenter.this.getView()).setQueryResults(null, clazz);
                }
            }
        });
    }

    private <T> EntityAdapter<T> getEntityAdapter(String clazz) {
        if (clazz.equals(MaterializedView.class.getName())) {
            return this.matViewAdaptor;
        }
        return null;
    }

    public void clearCache(final String vdbName, final int version, final String cacheType) {
        if (!this.isServerActive()) {
            return;
        }
        ModelNode address = RuntimeBaseAddress.get();
        address.add("subsystem", "teiid");
        ModelNode operation = new ModelNode();
        operation.get("operation").set("clear-cache");
        operation.get("address").set(address);
        operation.get("cache-type").set(new ModelNode().set(cacheType));
        operation.get("vdb-name").set(new ModelNode().set(vdbName));
        operation.get("vdb-version").set(new ModelNode().set(version));
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new SimpleCallback<DMRResponse>(){

            public void onSuccess(DMRResponse result) {
                Console.info((String)("Cache " + cacheType + " on VDB = " + vdbName + "." + version + " has been cleared"));
            }
        });
    }

    public void changeConnectionType(final String vdbName, final int version, final String connType) {
        if (!this.isServerActive()) {
            return;
        }
        ModelNode address = RuntimeBaseAddress.get();
        address.add("subsystem", "teiid");
        ModelNode operation = new ModelNode();
        operation.get("operation").set("change-vdb-connection-type");
        operation.get("address").set(address);
        operation.get("connection-type").set(new ModelNode().set(connType));
        operation.get("vdb-name").set(new ModelNode().set(vdbName));
        operation.get("vdb-version").set(new ModelNode().set(version));
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new SimpleCallback<DMRResponse>(){

            public void onSuccess(DMRResponse result) {
                ((MyView)VDBPresenter.this.getView()).connectionTypeChanged(vdbName, version);
                Console.info((String)("Changing Connection type to " + connType + " on VDB = " + vdbName + "." + version + " has been cleared"));
            }
        });
    }

    public void assignDataSource(final String vdbName, final int version, final String modelName, String sourceName, String translatorName, final String dataSourceName) {
        if (!this.isServerActive()) {
            return;
        }
        ModelNode address = RuntimeBaseAddress.get();
        address.add("subsystem", "teiid");
        ModelNode operation = new ModelNode();
        operation.get("operation").set("assign-datasource");
        operation.get("address").set(address);
        operation.get("vdb-name").set(new ModelNode().set(vdbName));
        operation.get("vdb-version").set(new ModelNode().set(version));
        operation.get("model-name").set(new ModelNode().set(modelName));
        operation.get("source-name").set(new ModelNode().set(sourceName));
        operation.get("translator-name").set(new ModelNode().set(translatorName));
        operation.get("ds-name").set(new ModelNode().set(dataSourceName));
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new SimpleCallback<DMRResponse>(){

            public void onSuccess(DMRResponse result) {
                Console.info((String)("Changing the JNDI name of the data source on VDB =" + vdbName + "." + version + " on Model=" + modelName + " to " + dataSourceName));
            }
        });
    }

    public void reloadVDB(final String vdbName, final int version) {
        if (!this.isServerActive()) {
            return;
        }
        ModelNode address = RuntimeBaseAddress.get();
        address.add("subsystem", "teiid");
        ModelNode operation = new ModelNode();
        operation.get("operation").set("restart-vdb");
        operation.get("address").set(address);
        operation.get("vdb-name").set(new ModelNode().set(vdbName));
        operation.get("vdb-version").set(new ModelNode().set(version));
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new SimpleCallback<DMRResponse>(){

            public void onSuccess(DMRResponse result) {
                Console.info((String)("VDB " + vdbName + "." + version + " has been submitted for reload"));
                ((MyView)VDBPresenter.this.getView()).vdbReloaded(vdbName, version);
            }
        });
    }

    public void getCacheStatistics() {
        if (!this.isServerActive()) {
            return;
        }
        ModelNode address = RuntimeBaseAddress.get();
        address.add("subsystem", "teiid");
        ModelNode operation = new ModelNode();
        operation.get("operation").set("cache-statistics");
        operation.get("address").set(address);
        operation.get("cache-type").set(new ModelNode().set("QUERY_SERVICE_RESULT_SET_CACHE"));
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new SimpleCallback<DMRResponse>(){

            public void onSuccess(DMRResponse result) {
                ModelNode response = result.get();
                if (response.get("result").isDefined()) {
                    CacheStatistics cache = (CacheStatistics)VDBPresenter.this.cacheAdaptor.fromDMR(response.get("result"));
                    ((MyView)VDBPresenter.this.getView()).setCacheStatistics(cache);
                } else {
                    ((MyView)VDBPresenter.this.getView()).setCacheStatistics(null);
                }
            }
        });
    }

    public void getSourceRequests(final Request selection) {
        if (!this.isServerActive()) {
            ((MyView)this.getView()).setSourceRequests(selection, null);
        }
        ModelNode address = RuntimeBaseAddress.get();
        address.add("subsystem", "teiid");
        ModelNode operation = new ModelNode();
        operation.get("operation").set("list-requests-per-session");
        operation.get("address").set(address);
        operation.get("session").set(new ModelNode().set(selection.getSessionId()));
        operation.get("include-source").set(new ModelNode().set(true));
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new SimpleCallback<DMRResponse>(){

            public void onSuccess(DMRResponse result) {
                ModelNode response = result.get();
                if (response.get("result").isDefined()) {
                    List requests = VDBPresenter.this.requestAdaptor.fromDMRList(response.get("result").asList());
                    ((MyView)VDBPresenter.this.getView()).setSourceRequests(selection, requests);
                } else {
                    ((MyView)VDBPresenter.this.getView()).setSourceRequests(selection, null);
                }
            }
        });
    }

    private boolean isServerActive() {
        return this.serverSelection == null || this.serverSelection != null && this.serverSelection.isRunning();
    }

    public static interface MyView
    extends View {
        public void setDeployedVDBs(List<VDB> var1);

        public void setPresenter(VDBPresenter var1);

        public void setVDBRequests(List<Request> var1);

        public void setQueryPlan(String var1);

        public void cancelSubmitted(Request var1);

        public void setDataModelFactory(DataModelFactory var1);

        public void setModelSchema(String var1);

        public void terminateSessionSubmitted(Session var1);

        public void setVDBSessions(String var1, int var2, List<Session> var3);

        public <T> void setQueryResults(List<T> var1, String var2);

        public void connectionTypeChanged(String var1, int var2);

        public void vdbReloaded(String var1, int var2);

        public void setCacheStatistics(CacheStatistics var1);

        public void setSourceRequests(Request var1, List<Request> var2);
    }

    @RuntimeExtension(name="Virtual Databases", key="teiid")
    @AccessControl(resources={"/{selected.host}/{selected.server}/subsystem=teiid"})
    @ProxyCodeSplit
    @NameToken(value="vdb-runtime")
    public static interface MyProxy
    extends Proxy<VDBPresenter>,
    Place {
    }
}

