/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.loopback;

import com.metamatrix.connector.loopback.LoopbackCapabilities;
import com.metamatrix.connector.loopback.LoopbackExecution;
import com.metamatrix.data.api.Connection;
import com.metamatrix.data.api.ConnectorCapabilities;
import com.metamatrix.data.api.ConnectorEnvironment;
import com.metamatrix.data.api.ConnectorLogger;
import com.metamatrix.data.api.ConnectorMetadata;
import com.metamatrix.data.api.Execution;
import com.metamatrix.data.api.ExecutionContext;
import com.metamatrix.data.metadata.runtime.RuntimeMetadata;

public class LoopbackConnection
implements Connection {
    private ConnectorCapabilities capabilities;
    private ConnectorEnvironment env;

    public LoopbackConnection(ConnectorEnvironment env) {
        this.env = env;
        String capabilityClass = env.getProperties().getProperty("CapabilitiesClass");
        this.loadCapabilities(capabilityClass, env.getLogger());
    }

    void loadCapabilities(String capabilityClass, ConnectorLogger logger) {
        if (capabilityClass != null && capabilityClass.length() > 0) {
            try {
                this.capabilities = (ConnectorCapabilities)Class.forName(capabilityClass).newInstance();
                logger.logInfo("Loaded " + capabilityClass + " for LoopbackConnector");
            }
            catch (ClassNotFoundException cnfe) {
                logger.logError("Capabilities class not found: " + capabilityClass, (Throwable)cnfe);
            }
            catch (IllegalAccessException iae) {
                logger.logError("Unable to create capabilities class: " + capabilityClass, (Throwable)iae);
            }
            catch (InstantiationException ie) {
                logger.logError("Unable to create capabilities class: " + capabilityClass, (Throwable)ie);
            }
            catch (ClassCastException cce) {
                logger.logError("Capabilities class does not extend ConnectorCapabilities: " + capabilityClass, (Throwable)cce);
            }
        }
        if (this.capabilities == null) {
            this.capabilities = new LoopbackCapabilities();
        }
    }

    public ConnectorCapabilities getCapabilities() {
        return this.capabilities;
    }

    public Execution createExecution(int executionMode, ExecutionContext executionContext, RuntimeMetadata metadata) {
        return new LoopbackExecution(this.env, metadata);
    }

    public ConnectorMetadata getMetadata() {
        return null;
    }

    public void release() {
    }
}

