/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.teiid;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.sequencer.teiid.VdbDataRole;
import org.modeshape.sequencer.teiid.VdbEntry;
import org.modeshape.sequencer.teiid.VdbManifest;
import org.modeshape.sequencer.teiid.VdbModel;
import org.modeshape.sequencer.teiid.VdbTranslator;

public class VdbManifestTest {
    @Test
    public void shouldReadVdbManifestFromBooksVDB() throws Exception {
        VdbManifest manifest = VdbManifest.read((InputStream)this.streamFor("/model/books/BooksVDB_vdb.xml"), null);
        Assert.assertThat((Object)manifest.getName(), (Matcher)Is.is((Object)"BooksVDB"));
        Assert.assertThat((Object)manifest.getVersion(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)manifest.getDescription(), (Matcher)Is.is((Object)"This is a VDB description"));
        Assert.assertThat(manifest.getProperties().get("query-timeout"), (Matcher)Is.is((Object)"10000"));
        Assert.assertThat(manifest.getProperties().get("preview"), (Matcher)Is.is((Object)"true"));
        List models = manifest.getModels();
        Assert.assertThat((Object)models.size(), (Matcher)Is.is((Object)3));
        VdbModel model1 = (VdbModel)models.get(0);
        Assert.assertThat((Object)model1.getType(), (Matcher)Is.is((Object)"VIRTUAL"));
        Assert.assertThat((Object)model1.isVisible(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)model1.getName(), (Matcher)Is.is((Object)"BooksProcedures"));
        Assert.assertThat((Object)model1.getPathInVdb(), (Matcher)Is.is((Object)"TestRESTWarGen/BooksProcedures.xmi"));
        Assert.assertThat((Object)model1.getDescription(), (Matcher)Is.is((Object)"This is a model description"));
        Assert.assertThat((Object)model1.getChecksum(), (Matcher)Is.is((Object)1855484649L));
        Assert.assertThat((Object)model1.isBuiltIn(), (Matcher)Is.is((Object)false));
        Map props = model1.getProperties();
        Assert.assertThat((Object)props.size(), (Matcher)Is.is((Object)2));
        Assert.assertThat(props.get("modelClass"), (Matcher)Is.is((Object)"Relational"));
        Assert.assertThat(props.get("indexName"), (Matcher)Is.is((Object)"1159106455.INDEX"));
        VdbModel model2 = (VdbModel)models.get(1);
        Assert.assertThat((Object)model2.getType(), (Matcher)Is.is((Object)"PHYSICAL"));
        Assert.assertThat((Object)model2.isVisible(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)model2.getName(), (Matcher)Is.is((Object)"MyBooks"));
        Assert.assertThat((Object)model2.getPathInVdb(), (Matcher)Is.is((Object)"TestRESTWarGen/MyBooks.xmi"));
        Assert.assertThat((Object)model2.getDescription(), (Matcher)Is.is((Object)""));
        Assert.assertThat((Object)model2.getChecksum(), (Matcher)Is.is((Object)2550610907L));
        Assert.assertThat((Object)model2.isBuiltIn(), (Matcher)Is.is((Object)false));
        props = model2.getProperties();
        Assert.assertThat((Object)props.size(), (Matcher)Is.is((Object)2));
        Assert.assertThat(props.get("modelClass"), (Matcher)Is.is((Object)"Relational"));
        Assert.assertThat(props.get("indexName"), (Matcher)Is.is((Object)"718925066.INDEX"));
        Assert.assertEquals((long)1L, (long)model2.getSources().size());
        VdbModel.Source source = (VdbModel.Source)model2.getSources().iterator().next();
        Assert.assertThat((Object)source.getTranslator(), (Matcher)Is.is((Object)"MyBooks_mysql5"));
        Assert.assertThat((Object)source.getJndiName(), (Matcher)Is.is((Object)"MyBooks"));
        Assert.assertThat((Object)source.getName(), (Matcher)Is.is((Object)"MyBooks"));
        VdbModel model3 = (VdbModel)models.get(2);
        Assert.assertThat((Object)model3.getType(), (Matcher)Is.is((Object)"VIRTUAL"));
        Assert.assertThat((Object)model3.isVisible(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)model3.getName(), (Matcher)Is.is((Object)"MyBooksView"));
        Assert.assertThat((Object)model3.getPathInVdb(), (Matcher)Is.is((Object)"TestRESTWarGen/MyBooksView.xmi"));
        Assert.assertThat((Object)model3.getDescription(), (Matcher)Is.is((Object)""));
        Assert.assertThat((Object)model3.getChecksum(), (Matcher)Is.is((Object)825941341L));
        Assert.assertThat((Object)model3.isBuiltIn(), (Matcher)Is.is((Object)false));
        props = model3.getProperties();
        Assert.assertThat((Object)props.size(), (Matcher)Is.is((Object)2));
        Assert.assertThat(props.get("modelClass"), (Matcher)Is.is((Object)"Relational"));
        Assert.assertThat(props.get("indexName"), (Matcher)Is.is((Object)"2173178531.INDEX"));
        Assert.assertThat((Object)model3.getImports().size(), (Matcher)Is.is((Object)1));
        Assert.assertThat(model3.getImports().iterator().next(), (Matcher)Is.is((Object)"/TestRESTWarGen/MyBooks.xmi"));
        List problems = model3.getProblems();
        Assert.assertThat((Object)problems.size(), (Matcher)Is.is((Object)3));
        VdbModel.ValidationMarker problem1 = (VdbModel.ValidationMarker)problems.get(0);
        Assert.assertThat((Object)problem1.getSeverity(), (Matcher)Is.is((Object)VdbModel.Severity.ERROR));
        Assert.assertThat((Object)problem1.getPath(), (Matcher)Is.is((Object)"BOOKS"));
        Assert.assertThat((Object)problem1.getMessage(), (Matcher)Is.is((Object)"The name BOOKS is the same (ignoring case) as 1 other object(s) under the same parent"));
        VdbModel.ValidationMarker problem2 = (VdbModel.ValidationMarker)problems.get(1);
        Assert.assertThat((Object)problem2.getSeverity(), (Matcher)Is.is((Object)VdbModel.Severity.ERROR));
        Assert.assertThat((Object)problem2.getPath(), (Matcher)Is.is((Object)"BOOKS"));
        Assert.assertThat((Object)problem2.getMessage(), (Matcher)Is.is((Object)"Group does not exist: MyBooksView.BOOKS"));
        VdbModel.ValidationMarker problem3 = (VdbModel.ValidationMarker)problems.get(2);
        Assert.assertThat((Object)problem3.getSeverity(), (Matcher)Is.is((Object)VdbModel.Severity.ERROR));
        Assert.assertThat((Object)problem3.getPath(), (Matcher)Is.is((Object)"BOOKS"));
        Assert.assertThat((Object)problem3.getMessage(), (Matcher)Is.is((Object)"The name BOOKS is the same (ignoring case) as 1 other object(s) under the same parent"));
        List translators = manifest.getTranslators();
        Assert.assertThat((Object)translators.size(), (Matcher)Is.is((Object)1));
        VdbTranslator translator = (VdbTranslator)manifest.getTranslators().get(0);
        Assert.assertThat((Object)translator.getDescription(), (Matcher)Is.is((Object)"This is a translator description"));
        Assert.assertThat((Object)translator.getType(), (Matcher)Is.is((Object)"mysql5"));
        Assert.assertThat((Object)translator.getName(), (Matcher)Is.is((Object)"MyBooks_mysql5"));
        Assert.assertThat((Object)translator.getProperties().size(), (Matcher)Is.is((Object)2));
        Assert.assertThat(translator.getProperties().get("nameInSource"), (Matcher)Is.is((Object)"bogusName"));
        Assert.assertThat(translator.getProperties().get("supportsUpdate"), (Matcher)Is.is((Object)"true"));
        List dataRoles = manifest.getDataRoles();
        Assert.assertThat((Object)dataRoles.size(), (Matcher)Is.is((Object)1));
        VdbDataRole dataRole = (VdbDataRole)dataRoles.get(0);
        Assert.assertThat((Object)dataRole.getName(), (Matcher)Is.is((Object)"My Data Role"));
        Assert.assertThat((Object)dataRole.isAllowCreateTempTables(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)dataRole.isAnyAuthenticated(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)dataRole.getMappedRoleNames().size(), (Matcher)Is.is((Object)2));
        Assert.assertTrue((boolean)dataRole.getMappedRoleNames().contains("Sledge"));
        Assert.assertTrue((boolean)dataRole.getMappedRoleNames().contains("Hammer"));
        Assert.assertThat((Object)dataRole.getPermissions().size(), (Matcher)Is.is((Object)3));
        VdbDataRole.Permission perm1 = (VdbDataRole.Permission)dataRole.getPermissions().get(0);
        Assert.assertThat((Object)perm1.getResourceName(), (Matcher)Is.is((Object)"BooksProcedures"));
        Assert.assertFalse((boolean)perm1.canCreate());
        Assert.assertTrue((boolean)perm1.canRead());
        Assert.assertTrue((boolean)perm1.canUpdate());
        Assert.assertTrue((boolean)perm1.canDelete());
        Assert.assertFalse((boolean)perm1.canExecute());
        Assert.assertFalse((boolean)perm1.canAlter());
        VdbDataRole.Permission perm2 = (VdbDataRole.Permission)dataRole.getPermissions().get(1);
        Assert.assertThat((Object)perm2.getResourceName(), (Matcher)Is.is((Object)"sysadmin"));
        Assert.assertFalse((boolean)perm2.canCreate());
        Assert.assertTrue((boolean)perm2.canRead());
        Assert.assertFalse((boolean)perm2.canUpdate());
        Assert.assertFalse((boolean)perm2.canDelete());
        Assert.assertFalse((boolean)perm2.canExecute());
        Assert.assertFalse((boolean)perm2.canAlter());
        VdbDataRole.Permission perm3 = (VdbDataRole.Permission)dataRole.getPermissions().get(2);
        Assert.assertThat((Object)perm3.getResourceName(), (Matcher)Is.is((Object)"MyBooks"));
        Assert.assertFalse((boolean)perm3.canCreate());
        Assert.assertTrue((boolean)perm3.canRead());
        Assert.assertTrue((boolean)perm3.canUpdate());
        Assert.assertTrue((boolean)perm3.canDelete());
        Assert.assertFalse((boolean)perm3.canExecute());
        Assert.assertFalse((boolean)perm3.canAlter());
        List entries = manifest.getEntries();
        Assert.assertThat((Object)entries.size(), (Matcher)Is.is((Object)2));
        VdbEntry entry1 = (VdbEntry)entries.get(0);
        Assert.assertThat((Object)entry1.getPath(), (Matcher)Is.is((Object)"path1"));
        Assert.assertThat((Object)entry1.getDescription(), (Matcher)Is.is((Object)"This is entry 1 description"));
        Assert.assertThat((Object)entry1.getProperties().size(), (Matcher)Is.is((Object)2));
        Assert.assertThat(entry1.getProperties().get("drummer"), (Matcher)Is.is((Object)"Ringo"));
        Assert.assertThat(entry1.getProperties().get("guitar"), (Matcher)Is.is((Object)"John"));
        VdbEntry entry2 = (VdbEntry)entries.get(1);
        Assert.assertThat((Object)entry2.getPath(), (Matcher)Is.is((Object)"path2"));
        Assert.assertThat((Object)entry2.getDescription(), (Matcher)Is.is((Object)"This is entry 2 description"));
        Assert.assertThat((Object)entry2.getProperties().size(), (Matcher)Is.is((Object)2));
        Assert.assertThat(entry2.getProperties().get("bass"), (Matcher)Is.is((Object)"Paul"));
        Assert.assertThat(entry2.getProperties().get("leadGuitar"), (Matcher)Is.is((Object)"George"));
    }

    @Test
    public void shouldReadVdbManifestFromQuickEmployees() throws Exception {
        VdbManifest manifest = VdbManifest.read((InputStream)this.streamFor("/model/QuickEmployees/vdb.xml"), null);
        Assert.assertThat((Object)manifest.getName(), (Matcher)Is.is((Object)"qe"));
        Assert.assertThat((Object)manifest.getVersion(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)manifest.getDescription(), (Matcher)Is.is((Object)"This VDB is for testing Recursive XML documents and Text Sources"));
        Assert.assertThat((Object)manifest.getModels().size(), (Matcher)Is.is((Object)5));
        VdbModel model = null;
        Set imports = null;
        List problems = null;
        Map props = null;
        model = (VdbModel)manifest.getModels().get(0);
        Assert.assertThat((Object)model.getType(), (Matcher)Is.is((Object)"VIRTUAL"));
        Assert.assertThat((Object)model.isVisible(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)model.getName(), (Matcher)Is.is((Object)"EmpV"));
        Assert.assertThat((Object)model.getPathInVdb(), (Matcher)Is.is((Object)"QuickEmployees/EmpV.xmi"));
        Assert.assertThat((Object)model.getChecksum(), (Matcher)Is.is((Object)2273245105L));
        Assert.assertThat((Object)model.isBuiltIn(), (Matcher)Is.is((Object)false));
        props = model.getProperties();
        Assert.assertThat((Object)props.size(), (Matcher)Is.is((Object)1));
        Assert.assertThat(props.get("indexName"), (Matcher)Is.is((Object)"1646901791.INDEX"));
        imports = model.getImports();
        Assert.assertThat((Object)imports.size(), (Matcher)Is.is((Object)2));
        problems = model.getProblems();
        Assert.assertThat((Object)problems.size(), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)((VdbModel.ValidationMarker)problems.get(0)).getSeverity(), (Matcher)Is.is((Object)VdbModel.Severity.WARNING));
        Assert.assertThat((Object)((VdbModel.ValidationMarker)problems.get(0)).getPath(), (Matcher)Is.is((Object)"EmpTable/annualSalary"));
        Assert.assertThat((Object)((VdbModel.ValidationMarker)problems.get(0)).getMessage(), (Matcher)Is.is((Object)"Missing or invalid Precision on column with a numeric datatype (See validation Preferences)"));
    }

    @Test
    public void shouldReadVdbManifestWithModelMetadata() throws Exception {
        VdbManifest manifest = VdbManifest.read((InputStream)this.streamFor("/vdb/declarativeModels-vdb.xml"), null);
        Assert.assertThat((Object)manifest.getName(), (Matcher)Is.is((Object)"twitter"));
        Assert.assertThat((Object)manifest.getVersion(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)manifest.getDescription(), (Matcher)Is.is((Object)"Shows how to call Web Services"));
        Map props = manifest.getProperties();
        Assert.assertThat((Object)props.size(), (Matcher)Is.is((Object)1));
        Map.Entry prop = props.entrySet().iterator().next();
        Assert.assertThat(prop.getKey(), (Matcher)Is.is((Object)"UseConnectorMetadata"));
        Assert.assertThat(prop.getValue(), (Matcher)Is.is((Object)"cached"));
        boolean foundSource = false;
        boolean foundVirtual = false;
        List models = manifest.getModels();
        Assert.assertThat((Object)models.size(), (Matcher)Is.is((Object)2));
        for (VdbModel model : models) {
            if (!foundSource && "twitter".equals(model.getName())) {
                Assert.assertThat((Object)model.getType(), (Matcher)Is.is((Object)"PHYSICAL"));
                Assert.assertEquals((long)1L, (long)model.getSources().size());
                VdbModel.Source source = (VdbModel.Source)model.getSources().iterator().next();
                Assert.assertThat((Object)source.getTranslator(), (Matcher)Is.is((Object)"rest"));
                Assert.assertThat((Object)source.getJndiName(), (Matcher)Is.is((Object)"java:/twitterDS"));
                Assert.assertThat((Object)source.getName(), (Matcher)Is.is((Object)"twitter"));
                foundSource = true;
                continue;
            }
            if (!foundVirtual && "twitterview".equals(model.getName())) {
                Assert.assertThat((Object)model.getType(), (Matcher)Is.is((Object)"VIRTUAL"));
                Assert.assertThat((Object)model.getMetadataType(), (Matcher)Is.is((Object)"DDL"));
                String metadata = "CREATE VIRTUAL PROCEDURE getTweets(query varchar) RETURNS (created_on varchar(25), from_user varchar(25), to_user varchar(25), profile_image_url varchar(25), source varchar(25), text varchar(140)) AS select tweet.* from (call twitter.invokeHTTP(action => 'GET', endpoint =>querystring('',query as \"q\"))) w, XMLTABLE('results' passing JSONTOXML('myxml', w.result) columns created_on string PATH 'created_at', from_user string PATH 'from_user', to_user string PATH 'to_user', profile_image_url string PATH 'profile_image_url', source string PATH 'source', text string PATH 'text') tweet; CREATE VIEW Tweet AS select * FROM twitterview.getTweets;";
                Assert.assertThat((Object)model.getModelDefinition(), (Matcher)Is.is((Object)"CREATE VIRTUAL PROCEDURE getTweets(query varchar) RETURNS (created_on varchar(25), from_user varchar(25), to_user varchar(25), profile_image_url varchar(25), source varchar(25), text varchar(140)) AS select tweet.* from (call twitter.invokeHTTP(action => 'GET', endpoint =>querystring('',query as \"q\"))) w, XMLTABLE('results' passing JSONTOXML('myxml', w.result) columns created_on string PATH 'created_at', from_user string PATH 'from_user', to_user string PATH 'to_user', profile_image_url string PATH 'profile_image_url', source string PATH 'source', text string PATH 'text') tweet; CREATE VIEW Tweet AS select * FROM twitterview.getTweets;"));
                foundVirtual = true;
                continue;
            }
            Assert.fail();
        }
    }

    private InputStream streamFor(String resourcePath) throws Exception {
        InputStream istream = this.getClass().getResourceAsStream(resourcePath);
        Assert.assertThat((Object)istream, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        return istream;
    }
}

