/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.ddl.dialect.teiid;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.sequencer.ddl.dialect.teiid.OptionNamespaceParser;
import org.modeshape.sequencer.ddl.dialect.teiid.TeiidDdlParser;
import org.modeshape.sequencer.ddl.dialect.teiid.TeiidDdlTest;
import org.modeshape.sequencer.ddl.node.AstNode;

public class OptionNamespaceParserTest
extends TeiidDdlTest {
    private OptionNamespaceParser parser;
    private AstNode rootNode;

    @Before
    public void beforeEach() {
        TeiidDdlParser teiidDdlParser = new TeiidDdlParser();
        this.parser = new OptionNamespaceParser(teiidDdlParser);
        this.rootNode = teiidDdlParser.nodeFactory().node("ddlRootNode");
    }

    @Test
    public void shouldParseNamespace() {
        String uri = "http://teiid.org";
        String alias = "teiid";
        String content = "set namespace 'http://teiid.org' AS teiid;";
        this.parser.parse(this.getTokens("set namespace 'http://teiid.org' AS teiid;"), this.rootNode);
        Assert.assertThat((Object)this.parser.getNamespaceUri("teiid"), (Matcher)Is.is((Object)"http://teiid.org"));
    }

    @Test
    public void shouldParseOptionNamespaceQuotedAliasedIdentifier() {
        String content = "SET NAMESPACE 'http://teiid.org/rest' AS REST;";
        this.parser.parse(this.getTokens("SET NAMESPACE 'http://teiid.org/rest' AS REST;"), this.rootNode);
        Assert.assertThat((Object)this.parser.parseIdentifier(this.getTokens("'REST:name'")), (Matcher)Is.is((Object)"{http://teiid.org/rest}name"));
    }

    @Test
    public void shouldParseOptionNamespaceUnquotedAliasedIdentifier() {
        String content = "SET NAMESPACE 'http://teiid.org/rest' AS REST;";
        this.parser.parse(this.getTokens("SET NAMESPACE 'http://teiid.org/rest' AS REST;"), this.rootNode);
        Assert.assertThat((Object)this.parser.parseIdentifier(this.getTokens("REST:name")), (Matcher)Is.is((Object)"{http://teiid.org/rest}name"));
    }

    @Test
    public void shouldParseOptionNamespaceDoubleQuotedAlias() {
        String uri = "http://teiid.org/rest";
        String alias = "REST";
        String content = "SET NAMESPACE 'http://teiid.org/rest' AS \"REST\";";
        this.parser.parse(this.getTokens("SET NAMESPACE 'http://teiid.org/rest' AS \"REST\";"), this.rootNode);
        Assert.assertThat((Object)this.parser.getNamespaceUri("REST"), (Matcher)Is.is((Object)"http://teiid.org/rest"));
    }

    @Test
    public void shouldParseOptionNamespaceDoubleQuotedUri() {
        String uri = "http://teiid.org/rest";
        String alias = "REST";
        String content = "SET NAMESPACE \"http://teiid.org/rest\" AS REST;";
        this.parser.parse(this.getTokens("SET NAMESPACE \"http://teiid.org/rest\" AS REST;"), this.rootNode);
        Assert.assertThat((Object)this.parser.getNamespaceUri("REST"), (Matcher)Is.is((Object)"http://teiid.org/rest"));
    }

    @Test
    public void shouldParseOptionNamespaceIdentifier() {
        String uri = "http://teiid.org/rest";
        String alias = "REST";
        String content = "SET NAMESPACE 'http://teiid.org/rest' AS REST;";
        this.parser.parse(this.getTokens("SET NAMESPACE 'http://teiid.org/rest' AS REST;"), this.rootNode);
        String unqualifiedId = "name";
        String aliasedId = "REST:name";
        String id = "{http://teiid.org/rest}name";
        Assert.assertThat((Object)this.parser.parseIdentifier(this.getTokens("REST:name")), (Matcher)Is.is((Object)"{http://teiid.org/rest}name"));
    }

    @Test
    public void shouldParseOptionNamespaceSingleQuotedAlias() {
        String uri = "http://teiid.org/rest";
        String alias = "REST";
        String content = "SET NAMESPACE 'http://teiid.org/rest' AS 'REST';";
        this.parser.parse(this.getTokens("SET NAMESPACE 'http://teiid.org/rest' AS 'REST';"), this.rootNode);
        Assert.assertThat((Object)this.parser.getNamespaceUri("REST"), (Matcher)Is.is((Object)"http://teiid.org/rest"));
    }

    @Test
    public void shouldParseOptionNamespaceSingleQuotedUri() {
        String uri = "http://teiid.org/rest";
        String alias = "REST";
        String content = "SET NAMESPACE 'http://teiid.org/rest' AS REST;";
        this.parser.parse(this.getTokens("SET NAMESPACE 'http://teiid.org/rest' AS REST;"), this.rootNode);
        Assert.assertThat((Object)this.parser.getNamespaceUri("REST"), (Matcher)Is.is((Object)"http://teiid.org/rest"));
    }
}

