/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.teiid;

import java.io.InputStream;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.Property;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.api.sequencer.Sequencer;
import org.modeshape.sequencer.teiid.TeiidI18n;
import org.modeshape.sequencer.teiid.VdbManifest;
import org.modeshape.sequencer.teiid.VdbSequencer;

public class VdbDynamicSequencer
extends VdbSequencer {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean execute(Property inputProperty, Node outputNode, Sequencer.Context context) throws Exception {
        LOGGER.debug("VdbDynamicSequencer.execute called:outputNode name='{0}', path='{1}'", new Object[]{outputNode.getName(), outputNode.getPath()});
        Binary binaryValue = inputProperty.getBinary();
        CheckArg.isNotNull((Object)binaryValue, (String)"binary");
        InputStream vdbStream = null;
        try {
            vdbStream = binaryValue.getStream();
            VdbManifest manifest = this.readManifest(binaryValue, vdbStream, outputNode, context);
            if (manifest == null) {
                throw new Exception("VdbDynamicSequencer.execute failed. The xml cannot be read.");
            }
            if (vdbStream == null) return true;
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(TeiidI18n.errorReadingVdbFile.text(new Object[]{inputProperty.getPath(), e.getMessage()}), e);
            }
            catch (Throwable throwable) {
                if (vdbStream == null) throw throwable;
                try {
                    vdbStream.close();
                    throw throwable;
                }
                catch (Exception e2) {
                    this.getLogger().warn((Throwable)e2, TeiidI18n.errorClosingVdbFile.text(new Object[]{inputProperty.getPath(), e2.getMessage()}), new Object[0]);
                }
                throw throwable;
            }
        }
        try {
            vdbStream.close();
            return true;
        }
        catch (Exception e) {
            this.getLogger().warn((Throwable)e, TeiidI18n.errorClosingVdbFile.text(new Object[]{inputProperty.getPath(), e.getMessage()}), new Object[0]);
            return true;
        }
    }
}

