/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.ddl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.TreeSet;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.modeshape.jcr.sequencer.AbstractSequencerTest;

public abstract class AbstractDdlSequencerTest
extends AbstractSequencerTest {
    protected void verifyReference(Node node, String uuid, String resolvedPath) throws RepositoryException {
        Session session = node.getSession();
        Node referencedNode = session.getNodeByIdentifier(uuid);
        Assert.assertEquals((Object)resolvedPath, (Object)referencedNode.getPath());
    }

    protected void verifyProperty(Node node, String propertyName, String expectedValue) throws RepositoryException {
        Property property = node.getProperty(propertyName);
        Value value = property.isMultiple() ? property.getValues()[0] : property.getValue();
        Assert.assertEquals((Object)expectedValue, (Object)value.getString());
    }

    protected void verifyProperty(Node node, String propertyName, long expectedValue) throws RepositoryException {
        Property property = node.getProperty(propertyName);
        Value value = property.isMultiple() ? property.getValues()[0] : property.getValue();
        Assert.assertEquals((long)expectedValue, (long)value.getLong());
    }

    protected boolean verifyHasProperty(Node node, String propNameStr) throws RepositoryException {
        return node.hasProperty(propNameStr);
    }

    protected void verifyPrimaryType(Node node, String expectedValue) throws RepositoryException {
        this.verifyProperty(node, "jcr:primaryType", expectedValue);
    }

    protected void verifyMixinType(Node node, String expectedValue) throws RepositoryException {
        this.verifyProperty(node, "jcr:mixinTypes", expectedValue);
    }

    protected void verifyMixinTypes(Node node, String ... expectedValues) throws RepositoryException {
        Value[] values = node.getProperty("jcr:mixinTypes").getValues();
        TreeSet<String> valuesSet = new TreeSet<String>();
        for (Value value : values) {
            valuesSet.add(value.getString());
        }
        ArrayList<String> expectedValuesList = new ArrayList<String>(Arrays.asList(expectedValues));
        Iterator expectedValuesIterator = expectedValuesList.iterator();
        while (expectedValuesIterator.hasNext()) {
            Assert.assertTrue((boolean)valuesSet.contains(expectedValuesIterator.next()));
            expectedValuesIterator.remove();
        }
        Assert.assertTrue((boolean)expectedValuesList.isEmpty());
    }

    protected void verifyExpression(Node node, String expectedValue) throws RepositoryException {
        this.verifyProperty(node, "ddl:expression", expectedValue);
    }

    protected void verifyBaseProperties(Node node, String primaryType, String lineNum, String colNum, String charIndex, long numChildren) throws RepositoryException {
        this.verifyPrimaryType(node, primaryType);
        this.verifyProperty(node, "ddl:startLineNumber", lineNum);
        this.verifyProperty(node, "ddl:startColumnNumber", colNum);
        this.verifyProperty(node, "ddl:startCharIndex", charIndex);
        Assert.assertThat((Object)node.getNodes().getSize(), (Matcher)Is.is((Object)numChildren));
    }

    protected Node findNode(Node parent, String nodePath, String ... mixinTypes) throws Exception {
        Node child = parent.getNode(nodePath);
        Assert.assertNotNull((Object)child);
        this.verifyMixinTypes(child, mixinTypes);
        return child;
    }

    protected Node sequenceDdl(String ddlFile, int waitTimeSeconds) throws Exception {
        String fileName = ddlFile.substring(ddlFile.lastIndexOf("/") + 1);
        this.createNodeWithContentFromFile(fileName, ddlFile);
        Node outputNode = this.getOutputNode(this.rootNode, "ddl/" + fileName, waitTimeSeconds);
        Assert.assertNotNull((Object)outputNode);
        Assert.assertThat((Object)outputNode.getNodes().getSize(), (Matcher)Is.is((Object)1L));
        Node statementsNode = outputNode.getNode("ddl:statements");
        Assert.assertNotNull((Object)statementsNode);
        return statementsNode;
    }

    protected Node sequenceDdl(String ddlFile) throws Exception {
        String fileName = ddlFile.substring(ddlFile.lastIndexOf("/") + 1);
        this.createNodeWithContentFromFile(fileName, ddlFile);
        Node outputNode = this.getOutputNode(this.rootNode, "ddl/" + fileName);
        Assert.assertNotNull((Object)outputNode);
        Assert.assertThat((Object)outputNode.getNodes().getSize(), (Matcher)Is.is((Object)1L));
        Node statementsNode = outputNode.getNode("ddl:statements");
        Assert.assertNotNull((Object)statementsNode);
        return statementsNode;
    }
}

