/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.xpath;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.modeshape.common.collection.ReadOnlyIterator;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.HashCode;
import org.modeshape.common.util.ObjectUtil;
import org.modeshape.jcr.api.query.qom.Operator;
import org.modeshape.jcr.query.model.Order;

public class XPath {
    protected static String asString(Iterable<?> components, String delimiter) {
        StringBuilder sb = new StringBuilder();
        for (Object component : components) {
            if (sb.length() != 0) {
                sb.append(delimiter);
            }
            sb.append(component);
        }
        return sb.toString();
    }

    public static class OrderBySpec {
        private final Order order;
        private final FunctionCall scoreFunction;
        private final NameTest attributeName;
        private final PathExpression path;

        public OrderBySpec(Order order, FunctionCall scoreFunction) {
            assert (order != null);
            assert (scoreFunction != null);
            this.order = order;
            this.scoreFunction = scoreFunction;
            this.attributeName = null;
            this.path = null;
        }

        public OrderBySpec(Order order, NameTest attributeName) {
            assert (order != null);
            assert (attributeName != null);
            this.order = order;
            this.scoreFunction = null;
            this.attributeName = attributeName;
            this.path = null;
        }

        public OrderBySpec(Order order, PathExpression path) {
            this.order = order;
            this.scoreFunction = null;
            this.attributeName = null;
            this.path = path;
        }

        public PathExpression getPath() {
            return this.path;
        }

        public NameTest getAttributeName() {
            return this.attributeName;
        }

        public FunctionCall getScoreFunction() {
            return this.scoreFunction;
        }

        public Order getOrder() {
            return this.order;
        }

        public int hashCode() {
            return HashCode.compute((Object[])new Object[]{this.order});
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof OrderBySpec) {
                OrderBySpec that = (OrderBySpec)obj;
                if (this.order != that.order) {
                    return false;
                }
                if (this.attributeName != null && !this.attributeName.equals(that.attributeName)) {
                    return false;
                }
                return this.scoreFunction == null || this.scoreFunction.equals(that.scoreFunction);
            }
            return false;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.scoreFunction != null) {
                sb.append(this.scoreFunction.toString());
            } else {
                sb.append('@').append(this.attributeName.toString());
            }
            switch (this.order) {
                case ASCENDING: {
                    sb.append(" ascending");
                    break;
                }
                case DESCENDING: {
                    sb.append(" descending");
                }
            }
            return sb.toString();
        }
    }

    public static class OrderBy
    extends Component
    implements Iterable<OrderBySpec> {
        private final List<OrderBySpec> orderBySpecifications;

        public OrderBy(List<OrderBySpec> orderBySpecifications) {
            this.orderBySpecifications = orderBySpecifications;
        }

        public List<OrderBySpec> getOrderBySpecifications() {
            return this.orderBySpecifications;
        }

        @Override
        public Component collapse() {
            return super.collapse();
        }

        @Override
        public Iterator<OrderBySpec> iterator() {
            return new ReadOnlyIterator(this.orderBySpecifications.iterator());
        }

        public int hashCode() {
            return HashCode.compute((Object[])new Object[]{this.orderBySpecifications});
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof OrderBy) {
                OrderBy that = (OrderBy)obj;
                return this.orderBySpecifications.equals(that.orderBySpecifications);
            }
            return false;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("order-by(");
            boolean first = true;
            for (OrderBySpec spec : this.orderBySpecifications) {
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                sb.append(spec);
            }
            sb.append(')');
            return sb.toString();
        }
    }

    public static class SchemaAttributeTest
    extends KindTest {
        private final NameTest attributeDeclarationName;

        public SchemaAttributeTest(NameTest attributeDeclarationName) {
            this.attributeDeclarationName = attributeDeclarationName;
        }

        public NameTest getAttributeDeclarationName() {
            return this.attributeDeclarationName;
        }

        public int hashCode() {
            return HashCode.compute((Object[])new Object[]{this.attributeDeclarationName});
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof SchemaAttributeTest) {
                SchemaAttributeTest that = (SchemaAttributeTest)obj;
                return this.attributeDeclarationName.equals(that.attributeDeclarationName);
            }
            return false;
        }

        public String toString() {
            return "schema-attribute(" + this.attributeDeclarationName + ")";
        }
    }

    public static class SchemaElementTest
    extends KindTest {
        private final NameTest elementDeclarationName;

        public SchemaElementTest(NameTest elementDeclarationName) {
            this.elementDeclarationName = elementDeclarationName;
        }

        public NameTest getElementDeclarationName() {
            return this.elementDeclarationName;
        }

        public int hashCode() {
            return HashCode.compute((Object[])new Object[]{this.elementDeclarationName});
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof SchemaElementTest) {
                SchemaElementTest that = (SchemaElementTest)obj;
                return this.elementDeclarationName.equals(that.elementDeclarationName);
            }
            return false;
        }

        public String toString() {
            return "schema-element(" + this.elementDeclarationName + ")";
        }
    }

    public static class ElementTest
    extends KindTest {
        private final NameTest elementNameOrWildcard;
        private final NameTest typeName;

        public ElementTest(NameTest elementNameOrWildcard, NameTest typeName) {
            this.elementNameOrWildcard = elementNameOrWildcard;
            this.typeName = typeName;
        }

        public NameTest getElementName() {
            return this.elementNameOrWildcard;
        }

        public NameTest getTypeName() {
            return this.typeName;
        }

        public int hashCode() {
            return HashCode.compute((Object[])new Object[]{this.typeName, this.elementNameOrWildcard});
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof ElementTest) {
                ElementTest that = (ElementTest)obj;
                return ObjectUtil.isEqualWithNulls((Object)this.typeName, (Object)that.typeName) && ObjectUtil.isEqualWithNulls((Object)this.elementNameOrWildcard, (Object)that.elementNameOrWildcard);
            }
            return false;
        }

        public String toString() {
            return "element(" + this.elementNameOrWildcard + (this.typeName != null ? "," + this.typeName : "") + ")";
        }
    }

    public static class AttributeTest
    extends KindTest {
        private final NameTest attributeNameOrWildcard;
        private final NameTest typeName;

        public AttributeTest(NameTest attributeNameOrWildcard, NameTest typeName) {
            this.attributeNameOrWildcard = attributeNameOrWildcard;
            this.typeName = typeName;
        }

        public NameTest getAttributeName() {
            return this.attributeNameOrWildcard;
        }

        public NameTest getTypeName() {
            return this.typeName;
        }

        public int hashCode() {
            return HashCode.compute((Object[])new Object[]{this.typeName, this.attributeNameOrWildcard});
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof AttributeTest) {
                AttributeTest that = (AttributeTest)obj;
                return ObjectUtil.isEqualWithNulls((Object)this.typeName, (Object)that.typeName) && ObjectUtil.isEqualWithNulls((Object)this.attributeNameOrWildcard, (Object)that.attributeNameOrWildcard);
            }
            return false;
        }

        public String toString() {
            return "attribute(" + this.attributeNameOrWildcard + (this.typeName != null ? "," + this.typeName : "") + ")";
        }
    }

    public static class DocumentTest
    extends KindTest {
        private KindTest elementOrSchemaElementTest;

        public DocumentTest(ElementTest elementTest) {
            CheckArg.isNotNull((Object)elementTest, (String)"elementTest");
            this.elementOrSchemaElementTest = elementTest;
        }

        public DocumentTest(SchemaElementTest schemaElementTest) {
            CheckArg.isNotNull((Object)schemaElementTest, (String)"schemaElementTest");
            this.elementOrSchemaElementTest = schemaElementTest;
        }

        public ElementTest getElementTest() {
            return this.elementOrSchemaElementTest instanceof ElementTest ? (ElementTest)this.elementOrSchemaElementTest : null;
        }

        public SchemaElementTest getSchemaElementTest() {
            return this.elementOrSchemaElementTest instanceof SchemaElementTest ? (SchemaElementTest)this.elementOrSchemaElementTest : null;
        }

        public int hashCode() {
            return HashCode.compute((Object[])new Object[]{this.elementOrSchemaElementTest});
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof DocumentTest) {
                DocumentTest that = (DocumentTest)obj;
                return this.elementOrSchemaElementTest.equals(that.elementOrSchemaElementTest);
            }
            return false;
        }

        public String toString() {
            return "document-node(" + this.elementOrSchemaElementTest + ")";
        }
    }

    public static class ProcessingInstructionTest
    extends KindTest {
        private final String nameOrStringLiteral;

        public ProcessingInstructionTest(String nameOrStringLiteral) {
            this.nameOrStringLiteral = nameOrStringLiteral;
        }

        public String getNameOrStringLiteral() {
            return this.nameOrStringLiteral;
        }

        public int hashCode() {
            return HashCode.compute((Object[])new Object[]{this.nameOrStringLiteral});
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof ProcessingInstructionTest) {
                ProcessingInstructionTest that = (ProcessingInstructionTest)obj;
                return this.nameOrStringLiteral.equals(that.nameOrStringLiteral);
            }
            return false;
        }

        public String toString() {
            return "processing-instruction(" + this.nameOrStringLiteral + ")";
        }
    }

    public static class CommentTest
    extends KindTest {
        public int hashCode() {
            return 1;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof CommentTest;
        }

        public String toString() {
            return "comment()";
        }
    }

    public static class TextTest
    extends KindTest {
        public int hashCode() {
            return 1;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof TextTest;
        }

        public String toString() {
            return "text()";
        }
    }

    public static class AnyKindTest
    extends KindTest {
        public int hashCode() {
            return 1;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof AnyKindTest;
        }

        public String toString() {
            return "node()";
        }
    }

    public static class AttributeNameTest
    extends NodeTest {
        private final NameTest nameTest;

        public AttributeNameTest(NameTest nameTest) {
            this.nameTest = nameTest;
        }

        public NameTest getNameTest() {
            return this.nameTest;
        }

        public String toString() {
            return "@" + this.nameTest;
        }

        public int hashCode() {
            return HashCode.compute((Object[])new Object[]{this.nameTest});
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof AttributeNameTest) {
                AttributeNameTest that = (AttributeNameTest)obj;
                return this.nameTest.equals(that.nameTest);
            }
            return false;
        }
    }

    public static class NameTest
    extends NodeTest {
        private final String prefixTest;
        private final String localTest;

        public NameTest(String prefixTest, String localTest) {
            this.prefixTest = prefixTest;
            this.localTest = localTest;
        }

        public String getPrefixTest() {
            return this.prefixTest;
        }

        public String getLocalTest() {
            return this.localTest;
        }

        public boolean matches(String prefix, String local) {
            if (this.prefixTest != null && !this.prefixTest.equals(prefix)) {
                return false;
            }
            return this.localTest == null || this.localTest.equals(local);
        }

        public boolean isWildcard() {
            return this.prefixTest == null && this.localTest == null;
        }

        public int hashCode() {
            return HashCode.compute((Object[])new Object[]{this.prefixTest, this.localTest});
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof NameTest) {
                NameTest that = (NameTest)obj;
                return ObjectUtil.isEqualWithNulls((Object)this.prefixTest, (Object)that.prefixTest) && ObjectUtil.isEqualWithNulls((Object)this.localTest, (Object)that.localTest);
            }
            return false;
        }

        public String toString() {
            String local = this.localTest != null ? this.localTest : "*";
            return this.prefixTest == null ? local : this.prefixTest + ":" + local;
        }
    }

    public static abstract class KindTest
    extends NodeTest {
    }

    public static abstract class NodeTest
    extends Component {
    }

    public static class ParenthesizedExpression
    extends Component {
        private final Component wrapped;

        public ParenthesizedExpression() {
            this.wrapped = null;
        }

        public ParenthesizedExpression(Component wrapped) {
            this.wrapped = wrapped;
        }

        public Component getWrapped() {
            return this.wrapped;
        }

        @Override
        public Component collapse() {
            return this.wrapped instanceof BinaryComponent ? this : this.wrapped;
        }

        public int hashCode() {
            return HashCode.compute((Object[])new Object[]{this.wrapped});
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof ParenthesizedExpression) {
                ParenthesizedExpression that = (ParenthesizedExpression)obj;
                return this.wrapped.equals(that.wrapped);
            }
            return false;
        }

        public String toString() {
            return "(" + this.wrapped + ")";
        }
    }

    public static class AxisStep
    extends StepExpression {
        private final NodeTest nodeTest;
        private final List<Component> predicates;

        public AxisStep(NodeTest nodeTest, List<Component> predicates) {
            assert (nodeTest != null);
            assert (predicates != null);
            this.nodeTest = nodeTest;
            this.predicates = predicates;
        }

        public NodeTest getNodeTest() {
            return this.nodeTest;
        }

        public List<Component> getPredicates() {
            return this.predicates;
        }

        @Override
        public Component collapse() {
            return this.predicates.isEmpty() ? this.nodeTest.collapse() : this;
        }

        public int hashCode() {
            return HashCode.compute((Object[])new Object[]{this.nodeTest, this.predicates});
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof AxisStep) {
                AxisStep that = (AxisStep)obj;
                return this.nodeTest.equals(that.nodeTest) && this.predicates.equals(that.predicates);
            }
            return false;
        }

        public String toString() {
            return this.nodeTest + (this.predicates.isEmpty() ? "" : this.predicates.toString());
        }
    }

    public static class DescendantOrSelf
    extends StepExpression {
        public int hashCode() {
            return 1;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof DescendantOrSelf;
        }

        public String toString() {
            return "descendant-or-self::node()";
        }
    }

    public static class FilterStep
    extends StepExpression {
        private final Component primaryExpression;
        private final List<Component> predicates;

        public FilterStep(Component primaryExpression, List<Component> predicates) {
            assert (primaryExpression != null);
            assert (predicates != null);
            this.primaryExpression = primaryExpression;
            this.predicates = predicates;
        }

        public Component getPrimaryExpression() {
            return this.primaryExpression;
        }

        public List<Component> getPredicates() {
            return this.predicates;
        }

        @Override
        public Component collapse() {
            return this.predicates.isEmpty() ? this.primaryExpression.collapse() : this;
        }

        public int hashCode() {
            return HashCode.compute((Object[])new Object[]{this.primaryExpression, this.predicates});
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof FilterStep) {
                FilterStep that = (FilterStep)obj;
                return this.primaryExpression.equals(that.primaryExpression) && this.predicates.equals(that.predicates);
            }
            return false;
        }

        public String toString() {
            return this.primaryExpression + (this.predicates.isEmpty() ? "" : this.predicates.toString());
        }
    }

    public static abstract class StepExpression
    extends Component {
    }

    public static class PathExpression
    extends Component
    implements Iterable<StepExpression> {
        private final List<StepExpression> steps;
        private final boolean relative;
        private final OrderBy orderBy;

        public PathExpression(boolean relative, List<StepExpression> steps, OrderBy orderBy) {
            this.steps = steps;
            this.relative = relative;
            this.orderBy = orderBy;
        }

        public boolean isRelative() {
            return this.relative;
        }

        public OrderBy getOrderBy() {
            return this.orderBy;
        }

        public List<StepExpression> getSteps() {
            return this.steps;
        }

        public StepExpression getLastStep() {
            return this.steps.isEmpty() ? null : this.steps.get(this.steps.size() - 1);
        }

        public PathExpression withoutLast() {
            assert (!this.steps.isEmpty());
            return new PathExpression(this.relative, this.steps.subList(0, this.steps.size() - 1), this.orderBy);
        }

        public PathExpression withoutFirst() {
            assert (!this.steps.isEmpty());
            return new PathExpression(this.relative, this.steps.subList(1, this.steps.size()), this.orderBy);
        }

        @Override
        public Iterator<StepExpression> iterator() {
            return this.steps.iterator();
        }

        @Override
        public Component collapse() {
            return this.steps.size() == 1 ? this.steps.get(0).collapse() : this;
        }

        public int hashCode() {
            return HashCode.compute((Object[])new Object[]{this.relative, this.orderBy, this.steps});
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof PathExpression) {
                PathExpression that = (PathExpression)obj;
                return this.relative == that.relative && ObjectUtil.isEqualWithNulls((Object)this.orderBy, (Object)that.orderBy) && this.steps.equals(that.steps);
            }
            return false;
        }

        public String toString() {
            return (this.relative ? "" : "/") + XPath.asString(this.steps, "/");
        }
    }

    public static class FunctionCall
    extends Component {
        private final NameTest name;
        private final List<Component> arguments;

        public FunctionCall(NameTest name, List<Component> arguments) {
            assert (name != null);
            assert (arguments != null);
            this.name = name;
            this.arguments = arguments;
        }

        public NameTest getName() {
            return this.name;
        }

        public List<Component> getParameters() {
            return this.arguments;
        }

        @Override
        public Component collapse() {
            ArrayList<Component> args = new ArrayList<Component>(this.arguments.size());
            for (Component arg : this.arguments) {
                args.add(arg.collapse());
            }
            return new FunctionCall(this.name, args);
        }

        public int hashCode() {
            return HashCode.compute((Object[])new Object[]{this.name, this.arguments});
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof FunctionCall) {
                FunctionCall that = (FunctionCall)obj;
                return this.name.equals(that.name) && this.arguments.equals(that.arguments);
            }
            return false;
        }

        public String toString() {
            return this.name + "(" + XPath.asString(this.arguments, ",") + ")";
        }
    }

    public static class Literal
    extends Component {
        private final String value;

        public Literal(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public boolean isInteger() {
            try {
                Integer.parseInt(this.value);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }

        public int getValueAsInteger() {
            return Integer.parseInt(this.value);
        }

        public int hashCode() {
            return HashCode.compute((Object[])new Object[]{this.value});
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Literal) {
                return this.value.equals(((Literal)obj).value);
            }
            return false;
        }

        public String toString() {
            return this.value;
        }
    }

    public static class ContextItem
    extends Component {
        public int hashCode() {
            return 1;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof ContextItem;
        }

        public String toString() {
            return ".";
        }
    }

    public static class Or
    extends BinaryComponent {
        public Or(Component left, Component right) {
            super(left, right);
        }

        @Override
        public Component collapse() {
            return new Or(this.getLeft().collapse(), this.getRight().collapse());
        }

        public String toString() {
            return this.getLeft() + " or " + this.getRight();
        }

        public int hashCode() {
            return HashCode.compute((Object[])new Object[]{this.getLeft(), this.getRight()});
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Or) {
                Or that = (Or)obj;
                return this.getLeft().equals(that.getLeft()) && this.getRight().equals(that.getRight());
            }
            return false;
        }
    }

    public static class Except
    extends BinaryComponent {
        public Except(Component left, Component right) {
            super(left, right);
        }

        public String toString() {
            return this.getLeft() + " except " + this.getRight();
        }

        public int hashCode() {
            return HashCode.compute((Object[])new Object[]{this.getLeft(), this.getRight()});
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Except) {
                Except that = (Except)obj;
                return this.getLeft().equals(that.getLeft()) && this.getRight().equals(that.getRight());
            }
            return false;
        }
    }

    public static class Intersect
    extends BinaryComponent {
        public Intersect(Component left, Component right) {
            super(left, right);
        }

        public String toString() {
            return this.getLeft() + " intersect " + this.getRight();
        }

        public int hashCode() {
            return HashCode.compute((Object[])new Object[]{this.getLeft(), this.getRight()});
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Intersect) {
                Intersect that = (Intersect)obj;
                return this.getLeft().equals(that.getLeft()) && this.getRight().equals(that.getRight());
            }
            return false;
        }
    }

    public static class Union
    extends BinaryComponent {
        public Union(Component left, Component right) {
            super(left, right);
        }

        public String toString() {
            return this.getLeft() + " union " + this.getRight();
        }

        public int hashCode() {
            return HashCode.compute((Object[])new Object[]{this.getLeft(), this.getRight()});
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Union) {
                Union that = (Union)obj;
                return this.getLeft().equals(that.getLeft()) && this.getRight().equals(that.getRight());
            }
            return false;
        }
    }

    public static class And
    extends BinaryComponent {
        public And(Component left, Component right) {
            super(left, right);
        }

        @Override
        public Component collapse() {
            return new And(this.getLeft().collapse(), this.getRight().collapse());
        }

        public String toString() {
            return this.getLeft() + " and " + this.getRight();
        }

        public int hashCode() {
            return HashCode.compute((Object[])new Object[]{this.getLeft(), this.getRight()});
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof And) {
                And that = (And)obj;
                return this.getLeft().equals(that.getLeft()) && this.getRight().equals(that.getRight());
            }
            return false;
        }
    }

    public static class Subtract
    extends BinaryComponent {
        public Subtract(Component left, Component right) {
            super(left, right);
        }

        @Override
        public Component collapse() {
            return new Subtract(this.getLeft().collapse(), this.getRight().collapse());
        }

        public String toString() {
            return this.getLeft() + " - " + this.getRight();
        }

        public int hashCode() {
            return HashCode.compute((Object[])new Object[]{this.getLeft(), this.getRight()});
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Subtract) {
                Subtract that = (Subtract)obj;
                return this.getLeft().equals(that.getLeft()) && this.getRight().equals(that.getRight());
            }
            return false;
        }
    }

    public static class Add
    extends BinaryComponent {
        public Add(Component left, Component right) {
            super(left, right);
        }

        @Override
        public Component collapse() {
            return new Add(this.getLeft().collapse(), this.getRight().collapse());
        }

        public String toString() {
            return this.getLeft() + " + " + this.getRight();
        }

        public int hashCode() {
            return HashCode.compute((Object[])new Object[]{this.getLeft(), this.getRight()});
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Add) {
                Add that = (Add)obj;
                return this.getLeft().equals(that.getLeft()) && this.getRight().equals(that.getRight());
            }
            return false;
        }
    }

    public static class NodeComparison
    extends BinaryComponent {
        private final NodeComparisonOperator operator;

        public NodeComparison(Component left, NodeComparisonOperator operator, Component right) {
            super(left, right);
            this.operator = operator;
        }

        @Override
        public Component collapse() {
            return new NodeComparison(this.getLeft().collapse(), this.operator, this.getRight().collapse());
        }

        public String toString() {
            return this.getLeft() + " " + (Object)((Object)this.operator) + " " + this.getRight();
        }

        public int hashCode() {
            return HashCode.compute((Object[])new Object[]{this.operator, this.getLeft(), this.getRight()});
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof NodeComparison) {
                NodeComparison that = (NodeComparison)obj;
                if (this.operator != that.operator) {
                    return false;
                }
                return this.getLeft().equals(that.getLeft()) && this.getRight().equals(that.getRight());
            }
            return false;
        }
    }

    public static class Comparison
    extends BinaryComponent {
        private final Operator operator;

        public Comparison(Component left, Operator operator, Component right) {
            super(left, right);
            this.operator = operator;
        }

        public Operator getOperator() {
            return this.operator;
        }

        @Override
        public Component collapse() {
            return new Comparison(this.getLeft().collapse(), this.operator, this.getRight().collapse());
        }

        public String toString() {
            return this.getLeft() + " " + this.operator + " " + this.getRight();
        }

        public int hashCode() {
            return HashCode.compute((Object[])new Object[]{this.operator, this.getLeft(), this.getRight()});
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Comparison) {
                Comparison that = (Comparison)obj;
                if (this.operator != that.operator) {
                    return false;
                }
                return this.getLeft().equals(that.getLeft()) && this.getRight().equals(that.getRight());
            }
            return false;
        }
    }

    public static abstract class BinaryComponent
    extends Component {
        private final Component left;
        private final Component right;

        public BinaryComponent(Component left, Component right) {
            this.left = left;
            this.right = right;
        }

        public Component getLeft() {
            return this.left;
        }

        public Component getRight() {
            return this.right;
        }
    }

    public static class Negation
    extends UnaryComponent {
        public Negation(Component wrapped) {
            super(wrapped);
        }

        public Component getNegated() {
            return this.wrapped;
        }

        public String toString() {
            return "-" + this.wrapped;
        }

        public int hashCode() {
            return this.wrapped.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Negation) {
                Negation that = (Negation)obj;
                return this.wrapped.equals(that.wrapped);
            }
            return false;
        }
    }

    public static abstract class UnaryComponent
    extends Component {
        protected final Component wrapped;

        public UnaryComponent(Component wrapped) {
            this.wrapped = wrapped;
        }
    }

    public static abstract class Component {
        public Component collapse() {
            return this;
        }
    }

    public static enum NodeComparisonOperator {
        IS,
        PRECEDES,
        FOLLOWS;

    }
}

