/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.value.binary.infinispan;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.infinispan.distexec.DistributedCallable;
import org.infinispan.distexec.mapreduce.Collector;
import org.infinispan.distexec.mapreduce.MapReduceTask;
import org.infinispan.distexec.mapreduce.Mapper;
import org.infinispan.distexec.mapreduce.Reducer;
import org.infinispan.loaders.CacheLoader;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheLoaderManager;
import org.infinispan.manager.CacheContainer;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.modeshape.common.SystemFailureException;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.util.IoUtil;
import org.modeshape.common.util.SecureHash;
import org.modeshape.jcr.InfinispanUtil;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.value.BinaryKey;
import org.modeshape.jcr.value.BinaryValue;
import org.modeshape.jcr.value.binary.AbstractBinaryStore;
import org.modeshape.jcr.value.binary.BinaryStoreException;
import org.modeshape.jcr.value.binary.NamedLocks;
import org.modeshape.jcr.value.binary.StoredBinaryValue;
import org.modeshape.jcr.value.binary.infinispan.ChunkInputStream;
import org.modeshape.jcr.value.binary.infinispan.ChunkOutputStream;
import org.modeshape.jcr.value.binary.infinispan.Metadata;
import org.modeshape.jcr.value.binary.infinispan.RetryOperation;

@ThreadSafe
public class InfinispanBinaryStore
extends AbstractBinaryStore {
    public static final int DEFAULT_CHUNK_SIZE = 0x100000;
    private static final String META_SUFFIX = "-meta";
    private static final String DATA_SUFFIX = "-data";
    private static final String TEXT_SUFFIX = "-text";
    private static final int SUFFIX_LENGTH = 5;
    private static final int MIN_KEY_LENGTH;
    private static final int MAX_KEY_LENGTH;
    protected Cache<String, Metadata> metadataCache;
    protected LockFactory lockFactory;
    private CacheContainer cacheContainer;
    private boolean dedicatedCacheContainer;
    private Cache<String, byte[]> blobCache;
    private int chunkSize;
    private String metadataCacheName;
    private String blobCacheName;

    public InfinispanBinaryStore(CacheContainer cacheContainer, boolean dedicatedCacheContainer, String metadataCacheName, String blobCacheName) {
        this(cacheContainer, dedicatedCacheContainer, metadataCacheName, blobCacheName, 0x100000);
    }

    public InfinispanBinaryStore(CacheContainer cacheContainer, boolean dedicatedCacheContainer, String metadataCacheName, String blobCacheName, int chunkSize) {
        this.cacheContainer = cacheContainer;
        this.dedicatedCacheContainer = dedicatedCacheContainer;
        this.metadataCacheName = metadataCacheName;
        this.blobCacheName = blobCacheName;
        if (chunkSize <= 0) {
            throw new IllegalArgumentException("Invalid chunk size:" + chunkSize);
        }
        this.chunkSize = chunkSize;
    }

    protected final String lockKeyFrom(BinaryKey key) {
        return key.toString();
    }

    protected final String metadataKeyFrom(BinaryKey key) {
        return key.toString() + META_SUFFIX;
    }

    protected final String dataKeyFrom(BinaryKey key) {
        return key.toString() + DATA_SUFFIX;
    }

    protected final String textKeyFrom(BinaryKey key) {
        return key.toString() + TEXT_SUFFIX;
    }

    protected static boolean isMetadataKey(String str) {
        if (str == null) {
            return false;
        }
        int len = str.length();
        if (len < MIN_KEY_LENGTH || len > MAX_KEY_LENGTH) {
            return false;
        }
        if (!str.endsWith(META_SUFFIX)) {
            return false;
        }
        String key = str.substring(0, len - 5);
        return BinaryKey.isProperlyFormattedKey(key);
    }

    protected static BinaryKey binaryKeyFromCacheKey(String key) {
        String plainKey = InfinispanBinaryStore.isMetadataKey(key) ? key.replace(META_SUFFIX, "") : (key.contains(DATA_SUFFIX) ? key.replaceFirst("-data-\\d+$", "") : (key.contains(TEXT_SUFFIX) ? key.replaceFirst("-text-\\d+$", "") : key));
        return new BinaryKey(plainKey);
    }

    @Override
    public void start() {
        this.logger.debug("start()", new Object[0]);
        if (this.metadataCache != null) {
            this.logger.debug("Already started.", new Object[0]);
            return;
        }
        if (this.dedicatedCacheContainer) {
            this.cacheContainer.start();
        }
        this.metadataCache = this.cacheContainer.getCache(this.metadataCacheName);
        this.blobCache = this.cacheContainer.getCache(this.blobCacheName);
        this.lockFactory = new LockFactory(this.metadataCache);
    }

    @Override
    public void shutdown() {
        try {
            if (this.dedicatedCacheContainer) {
                this.cacheContainer.stop();
            }
        }
        finally {
            this.cacheContainer = null;
            this.metadataCache = null;
            this.blobCache = null;
        }
    }

    public List<Cache<?, ?>> getCaches() {
        ArrayList caches = new ArrayList(2);
        if (!this.dedicatedCacheContainer) {
            if (this.metadataCache != null) {
                caches.add(this.metadataCache);
            }
            if (this.blobCache != null) {
                caches.add(this.blobCache);
            }
        }
        return caches;
    }

    private void putMetadata(final String metadataKey, final Metadata metadata) throws IOException {
        new RetryOperation(){

            @Override
            protected boolean call() {
                InfinispanBinaryStore.this.metadataCache.put((Object)metadataKey, (Object)metadata);
                return true;
            }
        }.doTry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BinaryValue storeValue(InputStream inputStream, boolean markAsUnused) throws BinaryStoreException, SystemFailureException {
        File tmpFile = null;
        try {
            SecureHash.HashingInputStream hashingStream = SecureHash.createHashingStream((SecureHash.Algorithm)SecureHash.Algorithm.SHA_1, (InputStream)inputStream);
            tmpFile = File.createTempFile("ms-ispn-binstore", "hashing");
            IoUtil.write((InputStream)hashingStream, (OutputStream)new BufferedOutputStream(new FileOutputStream(tmpFile)), (int)65536);
            BinaryKey binaryKey = new BinaryKey(hashingStream.getHash());
            String metadataKey = this.metadataKeyFrom(binaryKey);
            Metadata metadata = (Metadata)this.metadataCache.get((Object)metadataKey);
            if (metadata != null) {
                this.logger.debug("Binary value already exists.", new Object[0]);
                if (metadata.isUnused() && !markAsUnused) {
                    metadata.markAsUsed();
                    this.putMetadata(metadataKey, metadata);
                }
                StoredBinaryValue storedBinaryValue = new StoredBinaryValue(this, binaryKey, metadata.getLength());
                return storedBinaryValue;
            }
            this.logger.debug("Store binary value into chunks.", new Object[0]);
            String dataKey = this.dataKeyFrom(binaryKey);
            long lastModified = tmpFile.lastModified();
            long fileLength = tmpFile.length();
            int bufferSize = InfinispanBinaryStore.bestBufferSize(fileLength);
            ChunkOutputStream chunkOutputStream = new ChunkOutputStream(this.blobCache, dataKey, this.chunkSize);
            IoUtil.write((InputStream)new FileInputStream(tmpFile), (OutputStream)chunkOutputStream, (int)bufferSize);
            Lock lock = this.lockFactory.writeLock(this.lockKeyFrom(binaryKey));
            try {
                metadata = new Metadata(lastModified, fileLength, chunkOutputStream.chunksCount(), this.chunkSize);
                if (markAsUnused) {
                    metadata.markAsUnusedSince(System.currentTimeMillis());
                }
                this.putMetadata(metadataKey, metadata);
                StoredBinaryValue storedBinaryValue = new StoredBinaryValue(this, binaryKey, fileLength);
                lock.unlock();
                return storedBinaryValue;
            }
            catch (Throwable throwable) {
                try {
                    lock.unlock();
                    throw throwable;
                }
                catch (IOException e) {
                    throw new BinaryStoreException(e);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new SystemFailureException((Throwable)e);
                }
            }
        }
        finally {
            try {
                IoUtil.closeQuietly((Closeable)inputStream);
            }
            finally {
                if (tmpFile != null) {
                    tmpFile.delete();
                }
            }
        }
    }

    @Override
    public InputStream getInputStream(BinaryKey binaryKey) throws BinaryStoreException {
        Metadata metadata = (Metadata)this.metadataCache.get((Object)this.metadataKeyFrom(binaryKey));
        if (metadata == null) {
            throw new BinaryStoreException(JcrI18n.unableToFindBinaryValue.text(new Object[]{binaryKey, "Infinispan cache " + this.metadataCache.getName()}));
        }
        if (metadata.getLength() == 0L) {
            return new ByteArrayInputStream(new byte[0]);
        }
        return new ChunkInputStream(this.blobCache, this.dataKeyFrom(binaryKey), metadata.getChunkSize(), metadata.getLength());
    }

    @Override
    public void markAsUsed(Iterable<BinaryKey> keys) throws BinaryStoreException {
        for (BinaryKey binaryKey : keys) {
            Lock lock = this.lockFactory.writeLock(this.lockKeyFrom(binaryKey));
            try {
                String metadataKey = this.metadataKeyFrom(binaryKey);
                Metadata metadata = (Metadata)this.metadataCache.get((Object)metadataKey);
                if (metadata == null) continue;
                metadata.markAsUsed();
                this.putMetadata(metadataKey, metadata);
            }
            catch (IOException e) {
                this.logger.debug((Throwable)e, "Error during mark binary value used {0}", new Object[]{binaryKey});
                throw new BinaryStoreException(JcrI18n.errorMarkingBinaryValuesUnused.text(new Object[]{e.getCause().getMessage()}), e);
            }
            finally {
                lock.unlock();
            }
        }
    }

    @Override
    public void markAsUnused(Iterable<BinaryKey> keys) throws BinaryStoreException {
        for (BinaryKey binaryKey : keys) {
            Lock lock = this.lockFactory.writeLock(this.lockKeyFrom(binaryKey));
            try {
                String metadataKey = this.metadataKeyFrom(binaryKey);
                Metadata metadata = (Metadata)this.metadataCache.get((Object)metadataKey);
                if (metadata == null || metadata.isUnused()) continue;
                metadata.markAsUnusedSince(System.currentTimeMillis());
                this.putMetadata(metadataKey, metadata);
            }
            catch (IOException ex) {
                this.logger.debug((Throwable)ex, "Error during mark binary value unused {0}", new Object[]{binaryKey});
                throw new BinaryStoreException(JcrI18n.errorMarkingBinaryValuesUnused.text(new Object[]{ex.getCause().getMessage()}), ex);
            }
            finally {
                lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeValuesUnusedLongerThan(long minimumAge, TimeUnit unit) throws BinaryStoreException {
        Lock lock;
        Metadata metadata;
        CacheLoader cacheLoader = null;
        boolean cacheLoaderShared = false;
        CacheLoaderManager cacheLoaderManager = (CacheLoaderManager)this.metadataCache.getAdvancedCache().getComponentRegistry().getComponent(CacheLoaderManager.class);
        if (cacheLoaderManager != null) {
            cacheLoader = cacheLoaderManager.getCacheLoader();
            cacheLoaderShared = cacheLoaderManager.isShared();
        }
        if (!this.metadataCache.getCacheManager().isCoordinator() && cacheLoaderShared) {
            return;
        }
        long minimumAgeInMS = unit.toMillis(minimumAge);
        HashSet<String> processedKeys = new HashSet<String>();
        if (this.metadataCache.getCacheConfiguration().clustering().cacheMode().isDistributed() && this.metadataCache.getCacheManager().isCoordinator()) {
            MapReduceTask task = new MapReduceTask(this.metadataCache);
            task.mappedWith((Mapper)new UnusedMapper(minimumAgeInMS));
            task.reducedWith((Reducer)new DummyReducer());
            Map result = task.execute();
            for (String key : result.values()) {
                Lock lock2 = this.lockFactory.writeLock(key);
                try {
                    InfinispanBinaryStore.removeUnusedBinaryValue(this.metadataCache, this.blobCache, key);
                }
                finally {
                    lock2.unlock();
                }
            }
        } else {
            for (String key : this.metadataCache.keySet()) {
                if (!InfinispanBinaryStore.isMetadataKey(key)) continue;
                metadata = (Metadata)this.metadataCache.get((Object)key);
                processedKeys.add(key);
                if (!InfinispanBinaryStore.isValueUnused(metadata, minimumAgeInMS)) continue;
                lock = this.lockFactory.writeLock(key);
                try {
                    InfinispanBinaryStore.removeUnusedBinaryValue(this.metadataCache, this.blobCache, key);
                }
                finally {
                    lock.unlock();
                }
            }
        }
        if (this.metadataCache.getCacheManager().isCoordinator() && cacheLoader != null) {
            try {
                for (String key : new ArrayList(cacheLoader.loadAllKeys(processedKeys))) {
                    if (!(key instanceof String) || !InfinispanBinaryStore.isMetadataKey(key) || !InfinispanBinaryStore.isValueUnused(metadata = (Metadata)this.metadataCache.get((Object)key), minimumAgeInMS)) continue;
                    lock = this.lockFactory.writeLock(key);
                    try {
                        InfinispanBinaryStore.removeUnusedBinaryValue(this.metadataCache, this.blobCache, key);
                    }
                    finally {
                        lock.unlock();
                    }
                }
            }
            catch (CacheLoaderException cle) {
                this.logger.debug("Error during cleanup of cache loader", new Object[]{cle});
                throw new BinaryStoreException(JcrI18n.errorDuringGarbageCollection.text(new Object[]{cle.getMessage()}));
            }
        }
    }

    static boolean isValueUnused(Metadata metadata, long minimumAgeInMS) {
        if (metadata == null || !metadata.isUnused()) {
            return false;
        }
        return System.currentTimeMillis() - metadata.unusedSince() > minimumAgeInMS;
    }

    static void removeUnusedBinaryValue(Cache<String, Metadata> metadataCache, Cache<String, byte[]> blobCache, String metadataKey) {
        int chunkIndex;
        Metadata metadata = (Metadata)metadataCache.get((Object)metadataKey);
        if (metadata == null || !metadata.isUnused()) {
            return;
        }
        metadataCache.remove((Object)metadataKey);
        String key = metadataKey.replace(META_SUFFIX, "");
        if (metadata.getNumberChunks() > 0) {
            for (chunkIndex = 0; chunkIndex < metadata.getNumberChunks(); ++chunkIndex) {
                blobCache.remove((Object)(key + DATA_SUFFIX + "-" + chunkIndex));
            }
        }
        if (metadata.getNumberTextChunks() > 0) {
            for (chunkIndex = 0; chunkIndex < metadata.getNumberTextChunks(); ++chunkIndex) {
                blobCache.remove((Object)(key + TEXT_SUFFIX + "-" + chunkIndex));
            }
        }
    }

    @Override
    protected String getStoredMimeType(BinaryValue binary) throws BinaryStoreException {
        BinaryKey key = binary.getKey();
        Metadata metadata = (Metadata)this.metadataCache.get((Object)this.metadataKeyFrom(key));
        if (metadata == null) {
            String msg = JcrI18n.unableToFindBinaryValueInCache.text(new Object[]{key, this.metadataCache.getName()});
            throw new BinaryStoreException(JcrI18n.errorStoringMimeType.text(new Object[]{msg}));
        }
        return metadata.getMimeType();
    }

    @Override
    protected void storeMimeType(BinaryValue binary, String mimeType) throws BinaryStoreException {
        BinaryKey key = binary.getKey();
        Lock lock = this.lockFactory.writeLock(this.lockKeyFrom(key));
        try {
            String metadataKeyStr = this.metadataKeyFrom(key);
            Metadata metadata = (Metadata)this.metadataCache.get((Object)metadataKeyStr);
            if (metadata == null) {
                String msg = JcrI18n.unableToFindBinaryValueInCache.text(new Object[]{key, this.metadataCache.getName()});
                throw new BinaryStoreException(JcrI18n.errorStoringMimeType.text(new Object[]{msg}));
            }
            this.putMetadata(metadataKeyStr, metadata.withMimeType(mimeType));
        }
        catch (IOException ex) {
            this.logger.debug((Throwable)ex, "Error during store of mime type for {0}", new Object[]{key});
            throw new BinaryStoreException(JcrI18n.errorStoringMimeType.text(new Object[]{ex.getCause().getMessage()}));
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public String getExtractedText(BinaryValue binary) throws BinaryStoreException {
        BinaryKey key = binary.getKey();
        String metadataKeyStr = this.metadataKeyFrom(key);
        Metadata metadata = (Metadata)this.metadataCache.get((Object)metadataKeyStr);
        if (metadata == null) {
            String msg = JcrI18n.unableToFindBinaryValueInCache.text(new Object[]{key, this.metadataCache.getName()});
            throw new BinaryStoreException(JcrI18n.errorStoringMimeType.text(new Object[]{msg}));
        }
        if (metadata.getNumberTextChunks() == 0) {
            return null;
        }
        try {
            String textKey = this.textKeyFrom(key);
            return IoUtil.read((InputStream)new ChunkInputStream(this.blobCache, textKey, metadata.getChunkSize(), metadata.getLength()), (String)"UTF-8");
        }
        catch (IOException ex) {
            this.logger.debug((Throwable)ex, "Error during read of extracted text for {0}", new Object[]{key});
            throw new BinaryStoreException(JcrI18n.errorReadingExtractedText.text(new Object[]{ex.getCause().getMessage()}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeExtractedText(BinaryValue binary, String extractedText) throws BinaryStoreException {
        BinaryKey key = binary.getKey();
        Lock lock = this.lockFactory.writeLock(this.lockKeyFrom(key));
        try {
            String metadataKey = this.metadataKeyFrom(key);
            Metadata metadata = (Metadata)this.metadataCache.get((Object)metadataKey);
            if (metadata == null) {
                String msg = JcrI18n.unableToFindBinaryValueInCache.text(new Object[]{key, this.metadataCache.getName()});
                throw new BinaryStoreException(JcrI18n.errorStoringMimeType.text(new Object[]{msg}));
            }
            String textKey = this.textKeyFrom(key);
            ChunkOutputStream chunkOutputStream = null;
            try {
                chunkOutputStream = new ChunkOutputStream(this.blobCache, textKey, this.chunkSize);
                chunkOutputStream.write(extractedText.getBytes("UTF-8"));
            }
            catch (Throwable throwable) {
                IoUtil.closeQuietly(chunkOutputStream);
                throw throwable;
            }
            IoUtil.closeQuietly((Closeable)chunkOutputStream);
            this.putMetadata(metadataKey, metadata.withNumberOfTextChunks(chunkOutputStream.chunksCount()));
        }
        catch (IOException ex) {
            this.logger.debug((Throwable)ex, "Error during store of extracted text for {0}", new Object[]{key});
            throw new BinaryStoreException(JcrI18n.errorStoringExtractedText.text(new Object[]{ex.getCause().getMessage()}));
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public Iterable<BinaryKey> getAllBinaryKeys() throws BinaryStoreException {
        try {
            return InfinispanUtil.execute(this.metadataCache, InfinispanUtil.Location.EVERYWHERE, this.newBinaryKeysCollector(), KeySetCombiner.INSTANCE);
        }
        catch (Exception ex) {
            throw new BinaryStoreException(ex);
        }
    }

    private UsedBinaryKeysCollector newBinaryKeysCollector() {
        return new UsedBinaryKeysCollector();
    }

    static {
        MAX_KEY_LENGTH = MIN_KEY_LENGTH = BinaryKey.maxHexadecimalLength() + 5;
    }

    protected static class DummyReducer
    implements Reducer<String, String> {
        private static final long serialVersionUID = 1L;

        protected DummyReducer() {
        }

        public String reduce(String s, Iterator<String> stringIterator) {
            return s;
        }
    }

    static interface Lock {
        public void unlock() throws BinaryStoreException;
    }

    static class LockFactory {
        private final NamedLocks namedLocks;
        private final boolean infinispanLocks;
        private final Cache<String, Metadata> metadataCache;
        private final Lock DUMMY_LOCK = new Lock(){

            @Override
            public void unlock() {
            }
        };

        public LockFactory(Cache<String, Metadata> metadataCache) {
            this.metadataCache = metadataCache;
            if (this.metadataCache != null) {
                this.infinispanLocks = metadataCache.getCacheConfiguration().transaction().transactionMode() != TransactionMode.NON_TRANSACTIONAL && metadataCache.getCacheConfiguration().transaction().lockingMode() == LockingMode.PESSIMISTIC;
                this.namedLocks = !this.infinispanLocks && !metadataCache.getCacheConfiguration().clustering().cacheMode().isClustered() ? new NamedLocks() : null;
            } else {
                this.namedLocks = null;
                this.infinispanLocks = false;
            }
        }

        public Lock readLock(String key) throws BinaryStoreException {
            if (this.namedLocks != null) {
                return new NamedLock(this.namedLocks.readLock(key));
            }
            if (this.infinispanLocks) {
                return new ISPNLock(this.metadataCache, key);
            }
            return this.DUMMY_LOCK;
        }

        public Lock writeLock(String key) throws BinaryStoreException {
            if (this.namedLocks != null) {
                return new NamedLock(this.namedLocks.writeLock(key));
            }
            if (this.infinispanLocks) {
                return new ISPNLock(this.metadataCache, key);
            }
            return this.DUMMY_LOCK;
        }

        private class ISPNLock
        implements Lock {
            private final Cache<String, Metadata> cache;
            private final String key;

            public ISPNLock(Cache<String, Metadata> cache, String key) throws BinaryStoreException {
                this.cache = cache;
                this.key = key;
                try {
                    cache.getAdvancedCache().getTransactionManager().begin();
                    boolean lockObtained = cache.getAdvancedCache().withFlags(new Flag[]{Flag.FAIL_SILENTLY}).lock((Object[])new String[]{key});
                    if (!lockObtained) {
                        throw new BinaryStoreException(JcrI18n.errorLockingBinaryValue.text(new Object[]{key}));
                    }
                }
                catch (BinaryStoreException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new BinaryStoreException(JcrI18n.errorStoringBinaryValue.text(new Object[]{key}), ex);
                }
            }

            @Override
            public void unlock() throws BinaryStoreException {
                try {
                    this.cache.getAdvancedCache().getTransactionManager().commit();
                }
                catch (Exception ex) {
                    throw new BinaryStoreException(JcrI18n.errorStoringBinaryValue.text(new Object[]{this.key}), ex);
                }
            }
        }

        private class NamedLock
        implements Lock {
            private final java.util.concurrent.locks.Lock lock;

            public NamedLock(java.util.concurrent.locks.Lock lock) {
                this.lock = lock;
            }

            @Override
            public void unlock() {
                this.lock.unlock();
            }
        }
    }

    private static class UsedBinaryKeysCollector
    implements DistributedCallable<String, Metadata, Set<BinaryKey>>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private transient Cache<String, Metadata> metadataCache;

        private UsedBinaryKeysCollector() {
        }

        public void setEnvironment(Cache<String, Metadata> cache, Set<String> inputKeys) {
            this.metadataCache = cache;
        }

        public Set<BinaryKey> call() throws Exception {
            HashSet<BinaryKey> result = new HashSet<BinaryKey>();
            for (String key : this.metadataCache.keySet()) {
                Metadata metadata;
                if (!InfinispanBinaryStore.isMetadataKey(key) || (metadata = (Metadata)this.metadataCache.get((Object)key)).isUnused()) continue;
                result.add(InfinispanBinaryStore.binaryKeyFromCacheKey(key));
            }
            return result;
        }
    }

    private static class KeySetCombiner
    implements InfinispanUtil.Combiner<Set<BinaryKey>> {
        private static final KeySetCombiner INSTANCE = new KeySetCombiner();

        private KeySetCombiner() {
        }

        @Override
        public Set<BinaryKey> combine(Set<BinaryKey> priorResult, Set<BinaryKey> newResult) throws InterruptedException, ExecutionException {
            if (priorResult == null) {
                priorResult = new HashSet<BinaryKey>();
            }
            if (newResult != null) {
                priorResult.addAll(newResult);
            }
            return priorResult;
        }
    }

    private static class UnusedMapper
    implements Mapper<String, Metadata, String, String> {
        private static final long serialVersionUID = 1L;
        private long minimumAgeInMS;

        public UnusedMapper(long minimumAgeInMS) {
            this.minimumAgeInMS = minimumAgeInMS;
        }

        public void map(String key, Metadata metadata, Collector<String, String> stringCollector) {
            if (InfinispanBinaryStore.isValueUnused(metadata, this.minimumAgeInMS)) {
                stringCollector.emit((Object)key, (Object)key);
            }
        }
    }
}

