package org.komodo.modeshape.teiid.parser.bnf;

import org.komodo.modeshape.teiid.parser.completion.TeiidCompletionParser;

/**
 * Constant values representing unique BNF identifiers for use
 * in the completion parser {@link TeiidCompletionParser}
 */
@SuppressWarnings( "javadoc" )
public interface BNFConstants {

    int stringVal = 9001;

    int nonReserved = 9002;

    int id = 9003;

    int command = 9004;

    int designerCommand = 9005;

    int createTrigger = 9006;

    int alter = 9007;

    int forEachRowTriggerAction = 9008;

    int userCommand = 9009;

    int errorStatement = 9010;

    int raiseStatement = 9011;

    int exceptionReference = 9012;

    int exception = 9013;

    int statement = 9014;

    int delimitedStatement = 9015;

    int compoundStatement = 9016;

    int branchingStatement = 9017;

    int returnStatement = 9018;

    int whileStatement = 9019;

    int loopStatement = 9020;

    int ifStatement = 9021;

    int declareStatement = 9022;

    int assignStatement = 9023;

    int assignStatementOperand = 9024;

    int sqlStatement = 9025;

    int createProcedure = 9026;

    int procedureBodyCommand = 9027;

    int dynamicCommand = 9028;

    int expression = 9029;

    int setClauseList = 9030;

    int createElementsWithTypes = 9031;

    int callableStatement = 9032;

    int storedProcedure = 9033;

    int executeNamedParams = 9034;

    int insert = 9035;

    int expressionList = 9036;

    int update = 9037;

    int delete = 9038;

    int queryExpression = 9039;

    int withListElement = 9040;

    int queryExpressionBody = 9041;

    int queryTerm = 9042;

    int queryPrimary = 9043;

    int query = 9044;

    int into = 9045;

    int select = 9046;

    int selectSymbol = 9047;

    int selectExpression = 9048;

    int derivedColumn = 9049;

    int allInGroupSymbol = 9050;

    int orderedAgg = 9051;

    int textAgg = 9052;

    int aggregateSymbol = 9053;

    int analyticAggregateSymbol = 9054;

    int filterClause = 9055;

    int from = 9056;

    int tableReference = 9057;

    int joinedTable = 9058;

    int crossJoin = 9059;

    int qualifiedJoin = 9060;

    int tablePrimary = 9061;

    int xmlSerialize = 9062;

    int arrayTable = 9063;

    int textTable = 9064;

    int textColumn = 9065;

    int xmlQuery = 9066;

    int objectTable = 9067;

    int objectColumn = 9068;

    int xmlTable = 9069;

    int xmlColumn = 9070;

    int intVal = 9071;

    int subqueryFromClause = 9072;

    int unaryFromClause = 9073;

    int where = 9074;

    int criteria = 9075;

    int compoundCritOr = 9076;

    int compoundCritAnd = 9077;

    int notCrit = 9078;

    int booleanPrimary = 9079;

    int operator = 9080;

    int compareCrit = 9081;

    int subquery = 9082;

    int subqueryCompareCriteria = 9083;

    int matchCrit = 9084;

    int regexMatchCrit = 9085;

    int charVal = 9086;

    int betweenCrit = 9087;

    int isNullCrit = 9088;

    int setCrit = 9089;

    int existsCriteria = 9090;

    int groupBy = 9091;

    int having = 9092;

    int orderby = 9093;

    int sortSpecification = 9094;

    int sortKey = 9095;

    int intParam = 9096;

    int limit = 9097;

    int fetchLimit = 9098;

    int option = 9099;

    int commonValueExpression = 9100;

    int plusExpression = 9101;

    int plusMinus = 9102;

    int timesExpression = 9103;

    int timesOperator = 9104;

    int valueExpressionPrimary = 9105;

    int parameterReference = 9106;

    int unescapedFunction = 9107;

    int nestedExpression = 9108;

    int unsignedValueExpressionPrimary = 9109;

    int windowSpecification = 9110;

    int caseExpression = 9111;

    int searchedCaseExpression = 9112;

    int function = 9113;

    int xmlParse = 9114;

    int queryString = 9115;

    int xmlElement = 9116;

    int xmlAttributes = 9117;

    int jsonObject = 9118;

    int derivedColumnList = 9119;

    int xmlForest = 9120;

    int xmlNamespaces = 9121;

    int namespaceItem = 9122;

    int parseDataTypePrimary = 9123;

    int parseDataType = 9124;

    int intervalType = 9125;

    int nonNumericLiteral = 9126;

    int unsignedNumericLiteral = 9127;

    int columnList = 9128;

}
