CREATE FOREIGN TABLE PARTS (
	PART_ID string(4) NOT NULL OPTIONS (FIXED_LENGTH 'true', NATIVE_TYPE 'CHAR', NAMEINSOURCE '"PART_ID"'),
	PART_NAME string(255) OPTIONS (NATIVE_TYPE 'VARCHAR2', NAMEINSOURCE '"PART_NAME"'),
	PART_COLOR string(30) OPTIONS (NATIVE_TYPE 'VARCHAR2', NAMEINSOURCE '"PART_COLOR"'),
	PART_WEIGHT string(255) OPTIONS (NATIVE_TYPE 'VARCHAR2', NAMEINSOURCE '"PART_WEIGHT"'),
	PRIMARY KEY(PART_ID, PART_ID)
) OPTIONS (NAMEINSOURCE '"PARTSSUPPLIER"."PARTS"');

CREATE FOREIGN TABLE SHIP_VIA (
	SHIPPER_ID bigdecimal NOT NULL OPTIONS (FIXED_LENGTH 'true', NATIVE_TYPE 'NUMBER', NAMEINSOURCE '"SHIPPER_ID"'),
	SHIPPER_NAME string(30) OPTIONS (NATIVE_TYPE 'VARCHAR2', NAMEINSOURCE '"SHIPPER_NAME"'),
	PRIMARY KEY(SHIPPER_ID)
) OPTIONS (NAMEINSOURCE '"PARTSSUPPLIER"."SHIP_VIA"');

CREATE FOREIGN TABLE STATUS (
	STATUS_ID bigdecimal NOT NULL OPTIONS (FIXED_LENGTH 'true', NATIVE_TYPE 'NUMBER', NAMEINSOURCE '"STATUS_ID"'),
	STATUS_NAME string(30) OPTIONS (NATIVE_TYPE 'VARCHAR2', NAMEINSOURCE '"STATUS_NAME"'),
	PRIMARY KEY(STATUS_ID)
) OPTIONS (NAMEINSOURCE '"PARTSSUPPLIER"."STATUS"');

CREATE FOREIGN TABLE SUPPLIER (
	SUPPLIER_ID string(10) NOT NULL OPTIONS (NATIVE_TYPE 'VARCHAR2', NAMEINSOURCE '"SUPPLIER_ID"'),
	SUPPLIER_NAME string(30) OPTIONS (NATIVE_TYPE 'VARCHAR2', NAMEINSOURCE '"SUPPLIER_NAME"'),
	SUPPLIER_STATUS bigdecimal OPTIONS (FIXED_LENGTH 'true', NATIVE_TYPE 'NUMBER', NAMEINSOURCE '"SUPPLIER_STATUS"'),
	SUPPLIER_CITY string(30) OPTIONS (NATIVE_TYPE 'VARCHAR2', NAMEINSOURCE '"SUPPLIER_CITY"'),
	SUPPLIER_STATE string(2) OPTIONS (NATIVE_TYPE 'VARCHAR2', NAMEINSOURCE '"SUPPLIER_STATE"'),
	PRIMARY KEY(SUPPLIER_ID)
) OPTIONS (NAMEINSOURCE '"PARTSSUPPLIER"."SUPPLIER"');

CREATE FOREIGN TABLE SUPPLIER_PARTS (
	SUPPLIER_ID string(10) NOT NULL OPTIONS (NATIVE_TYPE 'VARCHAR2', NAMEINSOURCE '"SUPPLIER_ID"'),
	PART_ID string(4) NOT NULL OPTIONS (FIXED_LENGTH 'true', NATIVE_TYPE 'CHAR', NAMEINSOURCE '"PART_ID"'),
	QUANTITY bigdecimal OPTIONS (FIXED_LENGTH 'true', NATIVE_TYPE 'NUMBER', NAMEINSOURCE '"QUANTITY"'),
	SHIPPER_ID bigdecimal OPTIONS (FIXED_LENGTH 'true', NATIVE_TYPE 'NUMBER', NAMEINSOURCE '"SHIPPER_ID"'),
	PRIMARY KEY(SUPPLIER_ID),
	PRIMARY KEY(PART_ID)
) OPTIONS (NAMEINSOURCE '"PARTSSUPPLIER"."SUPPLIER_PARTS"');
