/**
 * Copyright (c) 2021 Red Hat, Inc.
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *   Red Hat, Inc. - initial API and implementation
 */
import { Command, flags } from '@oclif/command';
import { BackupServerConfig } from '../../api/backup-restore';
export declare const BACKUP_REPOSITORY_URL_KEY = "repository-url";
export declare const backupRepositoryUrl: import("@oclif/parser/lib/flags").IOptionFlag<string | undefined>;
export declare const BACKUP_REPOSITORY_PASSWORD_KEY = "repository-password";
export declare const backupRepositoryPassword: import("@oclif/parser/lib/flags").IOptionFlag<string | undefined>;
export declare const BACKUP_REST_SERVER_USERNAME_KEY = "username";
export declare const backupRestServerUsername: import("@oclif/parser/lib/flags").IOptionFlag<string | undefined>;
export declare const BACKUP_REST_SERVER_PASSWORD_KEY = "password";
export declare const backupRestServerPassword: import("@oclif/parser/lib/flags").IOptionFlag<string | undefined>;
export declare const SSH_KEY_KEY = "ssh-key";
export declare const sshKey: import("@oclif/parser/lib/flags").IOptionFlag<string | undefined>;
export declare const SSH_KEY_FILE_KEY = "ssh-key-file";
export declare const sshKeyFile: import("@oclif/parser/lib/flags").IOptionFlag<string | undefined>;
export declare const AWS_ACCESS_KEY_ID_KEY = "aws-access-key-id";
export declare const awsAccessKeyId: import("@oclif/parser/lib/flags").IOptionFlag<string | undefined>;
export declare const AWS_SECRET_ACCESS_KEY_KEY = "aws-secret-access-key";
export declare const awsSecretAccessKey: import("@oclif/parser/lib/flags").IOptionFlag<string | undefined>;
export declare const BACKUP_SERVER_CONFIG_CR_NAME_KEY = "backup-server-config-name";
export declare const backupServerConfigName: import("@oclif/parser/lib/flags").IOptionFlag<string | undefined>;
export default class Backup extends Command {
    static description: string;
    static examples: string[];
    static flags: flags.Input<any>;
    run(): Promise<void>;
    private getBackupTasks;
}
export declare function getBackupServerConfiguration(flags: {
    [name: string]: any;
}): BackupServerConfig | string | undefined;
