"use strict";
/**
 * Copyright (c) 2019-2021 Red Hat, Inc.
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *   Red Hat, Inc. - initial API and implementation
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const command_1 = require("@oclif/command");
const flags_1 = require("@oclif/parser/lib/flags");
const Listr = require("listr");
const context_1 = require("../../api/context");
const common_flags_1 = require("../../common-flags");
const constants_1 = require("../../constants");
const che_1 = require("../../tasks/che");
const api_1 = require("../../tasks/platforms/api");
const util_1 = require("../../util");
class Logs extends command_1.Command {
    run() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const { flags } = this.parse(Logs);
            flags.chenamespace = yield util_1.findWorkingNamespace(flags);
            const ctx = yield context_1.ChectlContext.initAndGet(flags, this);
            const cheTasks = new che_1.CheTasks(flags);
            const apiTasks = new api_1.ApiTasks();
            const tasks = new Listr([], { renderer: flags['listr-renderer'] });
            yield this.config.runHook(constants_1.DEFAULT_ANALYTIC_HOOK_NAME, { command: Logs.id, flags });
            tasks.add(apiTasks.testApiTasks(flags));
            tasks.add(cheTasks.verifyCheNamespaceExistsTask(flags, this));
            tasks.add(cheTasks.serverLogsTasks(flags, false));
            try {
                this.log(`CodeReady Workspaces logs will be available in '${ctx.directory}'`);
                yield tasks.run(ctx);
                this.log(util_1.getCommandSuccessMessage());
            }
            catch (err) {
                this.error(util_1.wrapCommandError(err));
            }
            this.exit(0);
        });
    }
}
exports.default = Logs;
Logs.description = 'Collect CodeReady Workspaces logs';
Logs.flags = {
    help: command_1.flags.help({ char: 'h' }),
    chenamespace: common_flags_1.cheNamespace,
    'listr-renderer': common_flags_1.listrRenderer,
    'deployment-name': common_flags_1.cheDeployment,
    directory: flags_1.string({
        char: 'd',
        description: 'Directory to store logs into',
        env: 'CHE_LOGS',
    }),
    'skip-kubernetes-health-check': common_flags_1.skipKubeHealthzCheck,
    telemetry: common_flags_1.CHE_TELEMETRY,
};
//# sourceMappingURL=logs.js.map