/**
 * Copyright (c) 2019-2021 Red Hat, Inc.
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *   Red Hat, Inc. - initial API and implementation
 */
export declare class OpenShiftHelper {
    /**
     * Check status on existed `default` namespace.
     */
    isOpenShiftRunning(): Promise<boolean>;
    getRouteHost(name: string, namespace?: string): Promise<string>;
    getRouteProtocol(name: string, namespace?: string): Promise<string>;
    routeExist(name: string, namespace?: string): Promise<boolean>;
    deleteAllRoutes(namespace?: string): Promise<void>;
    deleteAllDeploymentConfigs(namespace?: string): Promise<void>;
}
